package code.security.ahs;

import code.security.SecureCore;
import java.io.*;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;

import code.security.SangminConfig;
import code.Immutable;

/**
 * An entry in the DVVMap
 * 
 * Should not return hash as it is as it may violate immutable semantics
 * @author princem
 *
 */
public class DVVMapEntry implements Externalizable, Immutable{
  private final long timeStamp;
  private final byte[] hash;
  private final boolean hasHash;
  
  // only for the readExternal callers
  public DVVMapEntry(){
    timeStamp = 0;
    hash = null;
    hasHash = false;
  }
  
  public DVVMapEntry(long ts, byte[] h){
    timeStamp = ts;
    hash = h;
    hasHash = true;
  }
  
  public DVVMapEntry(long ts){
    timeStamp = ts;
    hash = null;
    hasHash = false;
  }
  
  public DVVMapEntry resetHasHash(){
    if(hasHash){
      return new DVVMapEntry(timeStamp);
    }else{
      return this;
    }
  }
  
  public long getTimeStamp(){
    return timeStamp;
  }
  
  public byte[] getHashValue(){
      assert hasHash: this;
    return hash;
  }
  
  public boolean hasHash(){
    return this.hasHash;
  }
  
  public boolean equals(Object o){
    if(!(o instanceof DVVMapEntry)){
      return false;
    }
    DVVMapEntry dme = (DVVMapEntry)o;
    return this.timeStamp == dme.timeStamp &&
          this.hasHash == dme.hasHash && (hasHash?Arrays.equals(this.hash, dme.hash):true);
  }
  
  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{
    long _timeStamp = in.readLong();
    boolean _hasHash = in.readBoolean();
    byte[] _hash = null; 
    if(_hasHash){
      _hash = new byte[20];
      //    in.read(_hash, 0, 20);
      SecureCore.readBytes(in, 20, _hash, 0);
    }
    
    Field[] f = new Field[3];
    try{
      f[0] = DVVMapEntry.class.getDeclaredField("timeStamp");
      f[1] = DVVMapEntry.class.getDeclaredField("hash");
      f[2] = DVVMapEntry.class.getDeclaredField("hasHash");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
    try{
      f[0].set(this, _timeStamp);
      f[1].set(this, _hash); 
      f[2].set(this, _hasHash); 
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }
    
  }
  
  public void writeExternal(ObjectOutput out) throws IOException{
    out.writeLong(timeStamp);
    out.writeBoolean(hasHash);
    if(hasHash){
      assert hash.length == 20;
      out.write(hash);
    }
  }
  
    public static String byteString(byte[] byteA){
	if(byteA == null){
	    return "NULL";
	}
	String str = "";
	for(byte b: byteA){
	    int i = b + 0;
	    str += " " + i;
	}
	return str;
    }

  public String toString(){
      return ""+timeStamp + (hasHash?"HasHash" + (SangminConfig.printDebugHashes?" hash " + byteString(hash):""): "NoHash");
  }
  
}

