package code.security.ahs;
import code.*;


import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;


/***
 * A version vector for storing dependency
 * @author princem
 *
 */
public class DependencyVV extends VV{
  private Hashtable<NodeId,Long> stamps;

  public DependencyVV(){
    stamps = new Hashtable<NodeId,Long>();
  }

  public DependencyVV(VV toCopyVV){
    VVIterator vvIter = null;
    Object token = null;
    NodeId nid = null;
    long timeStamp = 0;

    this.stamps = new Hashtable<NodeId, Long>(toCopyVV.getSize());
    for(vvIter = toCopyVV.getIterator(); vvIter.hasMoreElements();){
      token = vvIter.getNext();
      nid = toCopyVV.getServerByIteratorToken(token);
      timeStamp = toCopyVV.getStampByIteratorToken(token);
      if(timeStamp >=0 ){
        this.stamps.put(nid, new Long(timeStamp));
      }
    }
  }

  private DependencyVV(Hashtable<NodeId, Long> stamps){
    this.stamps = stamps;
  }

  public void put(NodeId nodeId, long stamp){
    if(stamp < 0)
    {
      assert(!stamps.containsKey(nodeId));
    }
    else
    {
      this.stamps.put(nodeId,new Long(stamp));
    }
  }
  /*
  public long getLocalClock(NodeId nodeId){
    return ((Long)this.stamps.get(nodeId)).longValue();
  }
   */
  public Enumeration<NodeId> getEnumeratedNodes(){
    return stamps.keys();
  }

  public int getSize(){
    return stamps.size();
  }
  /*
  public int numNodes(){
    return stamps.size();
  }*/

  /** 
   *  Create new VV by copying all elements except the specified node 
   **/ 
  public AcceptVV
  makeVVexcludeNode(NodeId exclude){
    Hashtable h = new Hashtable(stamps.size());
    Enumeration keys = stamps.keys();
    while(keys.hasMoreElements()){
      NodeId nid = (NodeId)keys.nextElement();
      if(!nid.equals(exclude)){
        h.put(nid, stamps.get(nid));
      }
    }

    return new AcceptVV(h);
  }

  /** 
   *  Create new VV by copying all elements except the specified node 
   **/ 
  public void
  dropNode(NodeId exclude){
    if(stamps.containsKey(exclude)){
      stamps.remove(exclude);
    }
  }

  public DependencyVV extend(DependencyVV dvv){
    Enumeration keys = dvv.stamps.keys();
    while(keys.hasMoreElements()){
      NodeId nid = (NodeId)keys.nextElement();
      if(!stamps.containsKey(nid) || stamps.get(nid) <= dvv.stamps.get(nid)){
        stamps.put(nid, dvv.stamps.get(nid));
      }
    }
    return this;  
  }

  /**
   * subtract all components for which both this and vv have non-negative components and this > vv
   * @param vv
   * @return
   */
  public void subtract(VV vv){
    VVIterator vvIter = null;
    Object token = null;
    NodeId nid = null;
    long timeStamp = 0;

    for(vvIter = vv.getIterator(); vvIter.hasMoreElements();){
      token = vvIter.getNext();
      nid = vv.getServerByIteratorToken(token);
      timeStamp = vv.getStampByIteratorToken(token);
      if(stamps.containsKey(nid) && stamps.get(nid) > timeStamp){
        stamps.put(nid, new Long(stamps.get(nid) - timeStamp));
      }else{
        stamps.remove(nid);
      }
    }

  }

  /**
   * computes the max of current dvv and the dvv passed as parameter
   * @param dvv
   * @return
   */
  public void takeMax(DependencyVV dvv){
    for(NodeId nId:dvv.stamps.keySet()){
      if(stamps.containsKey(nId) && stamps.get(nId) < dvv.stamps.get(nId)){
        stamps.put(nId, dvv.stamps.get(nId));
      }else if(!stamps.containsKey(nId)){
        stamps.put(nId, dvv.stamps.get(nId));
      }
    }
  }

  /**
   * returns whether the current dvv is included in the passed vv or not
   * @param AVV
   * @return
   */
  public boolean isIncludedBy(AcceptVV AVV){
    for( Enumeration<NodeId> enu = this.getEnumeratedNodes(); enu.hasMoreElements();){
      NodeId nodeId = enu.nextElement();
      try{
        if(((Long)stamps.get(nodeId)).longValue() > 
        AVV.getStampByServer(nodeId)){
          return false;
        }
      } catch (NoSuchEntryException e){
        System.err.println(e.toString());
        e.printStackTrace();
        System.exit(-1);
      }
    }
    return true;
  }

  public boolean containsNodeId(NodeId n){
    return stamps.containsKey(n);
  }

  /**
   * returns whether the current dvv is included in the passed vv or not
   * @param AVV
   * @return
   */
  public boolean includes(VV vv){
    VVIterator i = vv.getIterator();
    while(i.hasMoreElements()){
      Object token = i.getNext();
      NodeId nodeId = vv.getServerByIteratorToken(token);

      try{
        if(this.getStampByServer(nodeId) < vv.getStampByIteratorToken(token)){
          return false;
        }
      }catch(NoSuchEntryException e){
        return false;
      }
    }
    return true;
  }


  /**
   * returns whether the passed accept stamp is included in the current DVV
   */
  public final boolean 
  includes(AcceptStamp ts){
    //return true if this has an entry for ts.nodeId and if
    //that entry has at least as high a counter as ts.acceptStamp

    NodeId s = null;
    Long thisClockLong = null;
    boolean result = false;

    assert ts != null;
    if(ts.getLocalClock()== AcceptStamp.BEFORE_TIME_BEGAN){
      return true;
    }
    s = ts.getNodeId();
    thisClockLong = (Long)this.stamps.get(s);
    if(thisClockLong != null){
      result = (thisClockLong.longValue() >= ts.getLocalClock());
    }else{
      assert ts.getLocalClock() != AcceptStamp.BEFORE_TIME_BEGAN;
      result = false;
    }
    return(result);
  }

  /**
   * Return false if all components of vv are greater than the same in this
   */
  public final boolean 
  includesAnyPartOf(VV vv){
    //return true if this *includesAnyPartOf* vv

    //that is, if any event that happened before vv could also have
    //happened before this

    //that is, if there exists any server s.t. this.getStampByServer(s)
    //>= vv.getStampByServer(s)

    // TEST: If includes is true, includesAnyPartOf must be true
    // NOTE: If there exists a server s that is not in vv but is in this
    //       vector, return true.

    NodeId s = null;
    boolean result = false;
    Enumeration<NodeId> e = null;

    for(e = this.stamps.keys(); (e.hasMoreElements() && (!result));){
      try{
        s = (NodeId)e.nextElement();

        if(this.getStampByServer(s) == AcceptStamp.BEFORE_TIME_BEGAN){
          continue;
        }
        if(this.getStampByServer(s) >= vv.getStampByServer(s)){
          result = true;
        }
      }catch(NoSuchEntryException excp){
        result = true;
      }
    }
    return(result);
  }

  public long getStampByServer(NodeId nodeId)
  throws NoSuchEntryException{
    if(!this.containsNodeId(nodeId)){
      throw new NoSuchEntryException();
    }
    return ((Long)this.stamps.get(nodeId)).longValue();
  }

  public VVIterator getIterator(){
    return new VVIterator(this.stamps.keys());
  }
  /** 
   *  Return true if any component of "this" is greater than the same in "vv" 
   **/ 
  public final boolean isAnyPartGreaterThan(VV vv){
    //return true, only if there exists any server s s.t.
    //   (1)s is a valid component in both this and vv 
    //&& (2)this.getStampByServer(s) > vv.getStampByServer(s)
    // Note. the difference of this method and the above method
    //    is > and >=
    //    and if there's a s exists in "this", but not exist in "vv",
    //           isAnyPartGreaterThan() will not return true
    //       but includesAnyPartOf() will return true
    NodeId s = null;
    boolean result = false;
    Enumeration<NodeId> e = null;

    for(e = this.stamps.keys(); (e.hasMoreElements() && (!result));){
      try{
        s = (NodeId)e.nextElement();
        if(this.getStampByServer(s) > vv.getStampByServer(s)){
          result = true;
        }
      }catch(NoSuchEntryException excp){
        // result = true;
      }
    }
    return(result);

  }
  /** 
   * Return the server name stored at the token 
   **/ 
  public NodeId 
  getServerByIteratorToken(Object iterToken){
    NodeId nodeId = null;

    assert(iterToken instanceof NodeId);
    nodeId = (NodeId)iterToken;
    assert(this.stamps.get(nodeId) != null);
    return(nodeId);
  }

  /** 
   * Return the time stamp stored at the token 
   **/ 
  public long 
  getStampByIteratorToken(Object iterToken){
    NodeId nodeId = null;
    Long tsLong = null;

    assert(iterToken instanceof NodeId);
    nodeId = (NodeId)iterToken;
    tsLong = (Long)this.stamps.get(nodeId);
    assert(tsLong != null);
    return(tsLong.longValue());
  }

  /** 
   * Of all the <NodeId, TimeStamp> pairs in the version vector, 
   * return the largest TimeStamp. 
   **/ 
  public final long 
  getMaxTimeStamp(){
    long largestTimeStamp = Long.MIN_VALUE;
    Object token = null;

    for(VVIterator i = this.getIterator(); i.hasMoreElements();){
      token = i.getNext();
      if(this.getStampByIteratorToken(token) > largestTimeStamp){
        largestTimeStamp = this.getStampByIteratorToken(token);
      }
    }
    return(largestTimeStamp);
  }

  /** 
   * Of all the <NodeId, TimeStamp> pairs in the version vector, 
   * return the smallest TimeStamp. 
   **/ 
  public final long 
  getMinTimeStamp(){
    if(stamps.size() == 0){
      return AcceptStamp.BEFORE_TIME_BEGAN;
    }
    long smallestTimeStamp = Long.MAX_VALUE;
    Object token = null;

    for(VVIterator i = this.getIterator(); i.hasMoreElements();){
      token = i.getNext();
      if(this.getStampByIteratorToken(token) < smallestTimeStamp){
        smallestTimeStamp = this.getStampByIteratorToken(token);
      }
    }
    return(smallestTimeStamp);
  }


  /** 
   * Return true if this > vv (not if this == vv) 
   **/ 
  public final boolean greaterThan(VV vv){
//  return true if this > vv, where A > B if (1) for all {node, stamp}
//  in B, A has a larger or equal stamp, and (2) at least one stamp
//  in A has a larger value than the corresponding value in B or A
//  has more entries than B (copied from AcceptVV)
    boolean seenLarger = false;
    boolean result = true;
    NodeId s = null;
    Object token = null;
    VVIterator vvIter = null;
    int numVVElements = 0;

    try{
      for(vvIter = vv.getIterator(); vvIter.hasMoreElements();){
        numVVElements++;
        token = vvIter.getNext();
        s = vv.getServerByIteratorToken(token);
        if(this.getStampByServer(s) <
            vv.getStampByIteratorToken(token)){
          result = false;
          break;
        }else if((!seenLarger) && (this.getStampByServer(s) >
        vv.getStampByIteratorToken(token))){
          seenLarger = true;
        }
      }
    }catch(NoSuchEntryException e){
      result = false;
    }
    if(result && (!seenLarger)){
      // If we have more entries, even if the common entries match,
      // we are still larger
      seenLarger = (this.stamps.size() > numVVElements);
    }
    return(result && seenLarger);
  }

  /** 
   * Clone -- not clonable 
   * since we are mutable, we cannot return a pointer to ourself. 
   **/ 
  public DependencyVV clone(){
    Hashtable<NodeId, Long> newstamps = new Hashtable<NodeId, Long>();
    for(NodeId nId: stamps.keySet()){
      newstamps.put(nId, stamps.get(nId));
    }
    return new DependencyVV(newstamps);
  }

  public String toString(){
    String ret = "( ";
    for( Enumeration<NodeId> enu = this.getEnumeratedNodes(); enu.hasMoreElements();){
      NodeId nodeId = (NodeId)enu.nextElement();
      ret += "<" + ((Long)stamps.get(nodeId)).longValue() + "," + "\"" +
      nodeId + "\">, " ;
    }
    ret += " )";
    return ret;
  }

  /**
   * Update oldId to newId if the oldId's time stamp is greater 
   * than or equal to timestamp 
   * @param oldId NodeId to be updated
   * @param timestmp
   * @param newId new NodeId
   * @return true if this dvvMap has oldId component to be updated, false otherwise
   */
  public boolean updateNodeId(NodeId oldId, long timestamp, NodeId newId){
    if(!stamps.containsKey(oldId))
      return false;
    long val = stamps.remove(oldId);
    if(val >= timestamp){    
      stamps.put(newId, val);
      return true;
    } else {
      stamps.put(oldId, val);
      return false;
    }
  }
  
//  public boolean equalsIgnoreBranches(DependencyVV dvv){
//    HashMap<Long, Long> vvMap1 = new HashMap<Long, Long>();
//    HashMap<Long, Long> vvMap2 = new HashMap<Long, Long>();
//    
//    VVIterator vvi = this.getIterator();
//    while(vvi.hasMoreElements()){
//      
//    }
//  }
  
  public boolean equals(Object o){
    if(!(o instanceof DependencyVV)){
      return false;
    }
    DependencyVV dvv = (DependencyVV)o;
    return new AcceptVV(this).equals(new AcceptVV(dvv));
    
  }
  
  public int hashCode(){
    return new AcceptVV(this).hashCode();
  }

  public DependencyVV applyBranchMap(HashMap<NodeId, NodeId> branchMap){
    // TODO Auto-generated method stub
    return new DependencyVV(new AcceptVV(this).applyBranchMap(branchMap));
  }

  @Override
  public Collection<NodeId> getNodes(){
    // TODO Auto-generated method stub
    return this.stamps.keySet();
  }
}