package code.security.ahs;

import code.InvalTarget;
import code.security.SecureImpreciseInv;
import code.security.ahs.*;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

/***
 * Basically IH is AHSEntry plus some functionality
 * @author princem
 *
 */
public class IH implements Serializable, Comparable{
  private AHSEntry ahsEntry;
  
  public IH(AHSEntry ahsEntry_){
    this.ahsEntry = ahsEntry_;
  }
  
  public AHSEntry getAHSEntry(){
    return ahsEntry;
  }
    
  public long getStartTS(){
    return ahsEntry.getStartTS();
  }
  
  public long getEndTS(){
    return ahsEntry.getEndTS();    
  }
  
  public InvalTarget getInvalTarget(){
    return ahsEntry.getInvalTarget();
  }
  
  public boolean equals(Object o){
    
    if(!(o instanceof IH)){
      return false;
    }
    IH ih = (IH)o;
    return ahsEntry.equals(ih.ahsEntry);    
    
  }

  public String toString(){
    return ahsEntry.toString();
  }
  
  public int compareTo(Object o){
    // TODO Auto-generated method stub
    IH c = (IH)o;
    
    if(getStartTS() < c.getStartTS()){
      return -1;
    }else if(getStartTS() > c.getStartTS()){
      return 1;
    }    
    
    return 0;
  }
  
  private void readObject(ObjectInputStream in) 
  throws IOException, ClassNotFoundException{
    AHSEntry _ahsEntry = (AHSEntry)in.readObject();
    Field[] f = new Field[1];
    try{
      f[0] = IH.class.getDeclaredField("ahsEntry");   
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
    try{
      f[0].set(this, _ahsEntry); 
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }
  }
  
  private void writeObject(ObjectOutputStream out) throws IOException{
    out.writeObject(ahsEntry);
  }
  
}

