package code.security.ahs;
import code.*;
import code.security.SecureInv;
import code.security.SecureImpreciseInv;

public class ImpreciseTreeNode extends TreeNode{
  protected RootList precisedRootList;
  protected TreeNode parent;

  /**
   * I think this field is there to accomodate the rare possibility that an imprecise invalidate might have been made precise while 
   * it is being accessed. If that is true, then under the current locking model, it wont happen.
   */
  protected transient boolean isPrecise;
  private ImpreciseTreeNode(ImpreciseTreeNode org){
    super(org);
    isPrecise = org.isPrecise;
    precisedRootList = null;
    parent = null;
  }
  
  public ImpreciseTreeNode(AHSEntry ahsEntry, SecureInv sii, NodeId writer){
    super(ahsEntry);
    this.precisedRootList = new RootList(writer); 
    this.inval = sii;
    this.isPrecise = false;
  }
  
  /**
   * Returns the AHS corresponding to the range [start, end]
   * Only values known in the range are included. Hence, even 
   * if you give larger range, it will silently report the AHS
   * @param start
   * @param end
   * @param ahs
   */
  public void getTreeAHS(long start, long end, AHS ahs){

    if(this.startTS >= start && this.endTS <= end){
      ahs.add(this);
      return;
    }
    
    if(this.endTS < start || this.startTS > end){
      return;
    }

    if(start < this.startTS){
      start = this.startTS;
    }
    if(end > this.endTS){
      end = this.endTS;
    }

    for(int i=0; i < precisedRootList.size(); i++){
	      precisedRootList.NodeAt(i).getTreeAHS(start, end, ahs);
	}
    
   
  }
  
  /**
   * returns the most precise tree (traversing RootLists recursive for impreciseTreeNodes)
   * node that contains this ts
   * @param ts
   * @return
   */
  public TreeNode getImpreciseTreeNodeAS(long ts){
    if(this.startTS > ts || this.endTS < ts){
      return null;
    }
    
    TreeNode ret;
    for(int i=0; i < precisedRootList.size(); i++){
      ret = precisedRootList.NodeAt(i).getTreeNodeTS(ts);
      if (ret != null){
        return ret;
      }
    }
    
    return this;
    
  }
  
  /** 
   * return the next treeNode after this node
   */
  public synchronized TreeNode getNext(){
	 if(isPrecise){
		 //System.out.println(this  +"getNext " + super.getNext() + " precisedRootList" + precisedRootList.toString());
		 assert precisedRootList.getTreeNodeTS(precisedRootList.getEndTS()).getNext() == precisedRootList.getTreeNodeAfter(this.endTS);
    	return precisedRootList.getTreeNodeTS(precisedRootList.getEndTS()).getNext();
    }else{
      return super.getNext();
    }
  }
  
  public ImpreciseTreeNode clone(){
    ImpreciseTreeNode ret = new ImpreciseTreeNode(this);

    assert(getLeftChild() == null);
    assert(getRightChild() == null);

    ret.precisedRootList = this.precisedRootList.clone();
    ret.parent = null;
    ret.isPrecise = isPrecise;
    return ret;
  }

  public synchronized boolean isPrecise() {
	  assert !isPrecise;
    return isPrecise;
  }

  public synchronized void setPrecise(boolean isPrecise) {
	  if(isPrecise)
		  {
		  	System.out.println("this " + this + " made precise " + this.precisedRootList);
		  }
    this.isPrecise = isPrecise;
  }

  public final RootList getPrecisedRootList(){
    return precisedRootList;
  }

  public synchronized void applyTreeNode(TreeNode v)
  throws UnmatchingTreeNodeException{
    if(precisedRootList.size() == 0){
      assert(this.startTS == v.startTS): "This: " + this + "\nnode being applied" + v;
    }
    this.precisedRootList.applyTreeNode(v);
  }
  
  public String toString(){
      String ret =  "ImpreciseTreeNode" + super.toString() + "\n PrecisedRootList <" + precisedRootList.toLongString() + ">";
      return ret;
  }


}
