package code.security.ahs;

import java.io.*;
import code.NodeId;

/**
 * Represents a tuple comprising of nodeId and ahs
 * @author princem
 *
 */
public class NodeAHSTuple implements Serializable{
  private NodeId nodeId;
  private AHS ahs;

  public NodeAHSTuple(NodeId nodeId, AHS ahs){
    this.nodeId = nodeId;
    this.ahs = ahs;
  }

  public NodeAHSTuple(){
    this.nodeId = null;
    this.ahs = null;
  }

  public NodeId getNodeId(){
    return nodeId;
  }

  public AHS getAHS(){
    return ahs;
  }

  public void setNodeId(NodeId nodeId){
    this.nodeId = nodeId;
  }

  public void setAHS(AHS ahs){
    this.ahs = ahs;
  }

  public String toString(){
    return ((nodeId != null)?nodeId.toString():"NULL") + ":" + ((ahs!=null)?ahs.toString():"NULL");
  }
  
  public int hashCode(){
	  return ((nodeId != null)?nodeId.hashCode():0) + ((ahs!=null)?ahs.hashCode():0);
  }
  
  public boolean equals(Object o){
	  if(o instanceof NodeAHSTuple){
		  NodeAHSTuple n = (NodeAHSTuple)o;
		  return ((nodeId != null)?nodeId.equals(n.getNodeId()):(n.getNodeId() == null)) && 
				  ((ahs!=null)?ahs.equals(n.getAHS()):(n.getAHS() == null));

	  }else{
		  return false;
	  }
  }
}