package code.security.ahs;

import code.AcceptStamp;
import code.NodeId;

/**
 * A tuple comprising of node and treeNode
 * @author princem
 *
 */
public class NodeTreeNodeTuple{
  private NodeId nodeId;
  private TreeNode treeNode;

  public NodeTreeNodeTuple(NodeId nodeId, TreeNode treeNode){
    this.nodeId = nodeId;
    this.treeNode = treeNode;
  }

  public NodeTreeNodeTuple(){
    this.nodeId = null;
    this.treeNode = null;
  }

  public NodeId getNodeId(){
    return nodeId;
  }

  public TreeNode getTreeNode(){
    return treeNode;
  }

  public void setNodeId(NodeId nodeId){
    this.nodeId = nodeId;
  }

  public void setTreeNode(TreeNode treeNode){
    this.treeNode = treeNode;
  }

  public String toString(){
    return ((nodeId != null)?nodeId.toString():"NULL") + ":" + ((treeNode!=null)?treeNode.toString():"NULL");
  }

  public int hashCode(){
    return ((nodeId != null)?nodeId.hashCode():0) + ((treeNode!=null)?treeNode.hashCode():0);
  }

  public boolean equals(Object o){
    if(o instanceof NodeTreeNodeTuple){
      NodeTreeNodeTuple n = (NodeTreeNodeTuple)o;
      return ((nodeId != null)?nodeId.equals(n.getNodeId()):(n.getNodeId() == null)) && 
      ((treeNode!=null)?treeNode.equals(n.getTreeNode()):(n.getTreeNode() == null));

    }else{
      return false;
    }
  }
  
  public int compareTo(Object o) throws ClassCastException {
    if( o instanceof NodeTreeNodeTuple){
      NodeTreeNodeTuple ntnt = (NodeTreeNodeTuple)o;
      return new AcceptStamp(treeNode.getEndTS(), nodeId).compareTo(new AcceptStamp(ntnt.treeNode.endTS, ntnt.nodeId));
      
    }else{
      System.out.println("My name is " + o.getClass().getName());
      throw new ClassCastException();
    }
        
  }

}
