package code.security.ahs;

import code.*;
import code.security.*;
import code.security.holesync.Range;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;


public class RootList{  
		
  
  /**
   * can have upto logN entries where N is the number of updates
   */
  private Vector<TreeNode> rootList;

  /**
   * the last added treeNode (leaf or imprecise) 
   */
  private TreeNode lastAdded;
  /**
   * the first treeNode in the list: only for linear chaining and not used in the hierarchy
   */
  private TreeNode dummyNode;

  /**
   * the writer for whom this treeNode is constructed
   */
  private NodeId writer;
  
  final static boolean dbg = false;


  public RootList(NodeId _writer){
    rootList = new Vector<TreeNode>();
    lastAdded = new TreeNode(); 
    dummyNode = lastAdded;
    writer = _writer;
  }

  public synchronized int size(){
    return rootList.size();
  }

  public synchronized boolean isEmpty(){
    return rootList.isEmpty();
  }
  
  /**
   * return the i'th element in the rootList (frm among the logN values)
   * @param i
   * @return
   */
  public synchronized TreeNode NodeAt(int i){
    return rootList.elementAt(i);
  }

  /**
   * Appends an newNode at the end of this rootList
   * @param newNode
   */
  private void append(TreeNode newNode){
	  if(dbg)System.out.println("Append: " + newNode);
    rootList.addElement(newNode);

    if(dbg)System.out.println("lastAdded " + lastAdded + " cur root list" + getAllNodes() + " toString " + toString() );
    assert(newNode.startTS > lastAdded.endTS);
    /*
    while( rootList.size() >=2 &&
        (((TreeNode)(rootList.elementAt(rootList.size()-2))).level 
            == ((TreeNode)(rootList.lastElement())).level)){      
      TreeNode last = (TreeNode)rootList.remove(rootList.size()-1);
      TreeNode lastToLast = (TreeNode)rootList.remove(rootList.size()-1);
      rootList.add(new TreeNode(lastToLast,last,writer));    
    }
    */
    // Only leaves and imprecise tree nodes are linked
    assert(newNode.level == 0 || newNode instanceof ImpreciseTreeNode);
//  if( !newNode.isPrecise()){
//  System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
//  System.out.println("lastAdded s:"+lastAdded.startTS);
//  System.out.println("lastAdded e:"+lastAdded.endTS);

//  System.out.println("newNode s:"+ newNode.startTS);
//  System.out.println("newNode e:"+ newNode.endTS);
//  }
    if(lastAdded != null){
      lastAdded.setNext(newNode);      
    }
    else
    {
    	assert false:" Prince thinks this is a bad scenario as there must always be a lastAdded";
    }
    newNode.setPrev(lastAdded);
    if(SangminConfig.forkjoin){
      try {
        newNode.updateSuperHash();
      } catch (IOException e) {
        assert false;
      }
    }
    if(dbg)System.out.println("\n LastAdded->next:" + (lastAdded.getNext()!=null?lastAdded.getNext().toString():"NULL"));
    if(dbg)System.out.println("\n newNode->prev:" + (newNode.getPrev()!=null?newNode.getPrev().toString():"NULL"));
    if(dbg)System.out.println("lastAdded " + lastAdded + "newNode " + newNode + " cur root list" + getAllNodes() + " toString " + toString() + " lastAdded->next" );

    //if(! newNode.isPrecise()){
    //  ImpreciseTreeNode iTN = (ImpreciseTreeNode)newNode;
    //  iTN.precisedRootList.lastAdded = lastAdded;        
    //}
    lastAdded = newNode;
    
    while( rootList.size() >=2 &&
        (((TreeNode)(rootList.elementAt(rootList.size()-2))).level 
            == ((TreeNode)(rootList.lastElement())).level)){      
      TreeNode last = (TreeNode)rootList.remove(rootList.size()-1);
      TreeNode lastToLast = (TreeNode)rootList.remove(rootList.size()-1);
      rootList.add(new TreeNode(lastToLast,last,writer));    
    }

  }

  /**
   * append a bunch of sorted treenodes 
   * @param treeNodes
   */
  private void append(TreeNode[] treeNodes){
    for(int i=0; i < treeNodes.length; i++){
      assert (!SecurityFilter.sanityCheck || isConsistent());

      append(treeNodes[i]);
      assert isConsistent();

    }
  }

  /**
   * Returns an AHS that spans from beginning to as
   * @param as
   * @return
   */
  public synchronized AHS asAHS(long as){
    AHS ahs = new AHS();
    for(int i = 0; i < rootList.size(); i++){
      TreeNode t = rootList.elementAt(i);
      if(t.endTS < (as)){       
        ahs.add(t);
      }else if(t.endTS == as){        
        ahs.add(t);
        return ahs;
      }else if(t.startTS <= as && t.endTS > as){        
        ((TreeNode)rootList.elementAt(i)).getTreeAHS(as, ahs);
        return ahs;
      }else{
        // this shouldn't happen for now
        if(dbg){
          for(int k=0; k<rootList.size(); k++){
            TreeNode t2 = rootList.elementAt(k);
            System.out.println("@@@ StartTS: " + t2.startTS +" , EndTS: " +t2.endTS);
          }
          System.out.println("@@@ looking for ts=" + as);
        }
        assert(false);
      }
    } 
    return ahs;
  }
  
  /**
   * Returns an AHS that spans from beginning to as
   * @param as
   * @return
   */
  public synchronized String toString(){
      String str = "";
      for(TreeNode tn: rootList){
	  str += "\n" + tn.toString();
      }
      return str;
  }
  
  /**
   * Returns an AHS that spans from beginning to as
   * @param as
   * @return
   */
  public synchronized String toLongString(){
      String str = "";
      for(TreeNode tn: this.getAllNodes()){
	  str += "\n" + tn.toString();
      }
      return str;
  }


  /**
   * returns the hash value of this rootList (just the root nodes)
   * @return
   */
  public synchronized byte[] getHash(){
  	if(SangminConfig.forkjoin){
  		return rootList.get(rootList.size()-1).superhash;
  	}
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    for(int i=0; i<rootList.size(); i++){
      try{
        buffer.write(((TreeNode)rootList.elementAt(i)).superhash);
      }catch(Exception e){
        System.err.println(e.toString());
        System.exit(-1);
      }
    }
    return DataHash.getMD(buffer.toByteArray());
  }

  /**
   * return the index of the rootList element that contains the time stamp "ts"
   * @param ts
   * @return
   */
  private int binarySearch(long ts){
    int start = 0;
    int end = rootList.size();
    int i = end/2;
    //while i'th element doesnt contain ts
    while(!(((TreeNode)rootList.elementAt(i)).startTS <= ts
        && ((TreeNode)rootList.elementAt(i)).endTS >= ts)){
      if(((TreeNode)rootList.elementAt(i)).startTS > ts){
        end = i-1; // prince changed it from i to i-1
      }else if(((TreeNode)rootList.elementAt(i)).endTS < ts){
        start = i+1; // prince changed it from i to i+1
      }else{
        // Must not get here
        assert(false);
      }
      i = (start+end)/2;
    }
    return i;
  }

  /**
   * Apply ImpreciseTreeNode to this RootList
   */
  private Range applyImpreciseTreeNode(ImpreciseTreeNode iTN)
  throws UnmatchingTreeNodeException{

    if(dbg){      
      System.out.println("!!!!! applying iTN start:"+iTN.startTS+" end:"+iTN.endTS + " rootList " +rootList.toString() );
    }

    if(rootList.isEmpty() || 
        ((TreeNode)rootList.lastElement()).endTS < iTN.startTS ){
      append(iTN);
      return null;
    }

    if(dbg)System.out.println("simple case of applyImpreciseTreeNode");
    // Binary search for rootList[i] which includes iTN.startTS
    int i = binarySearch(iTN.startTS);

    if(((TreeNode)rootList.elementAt(i)).endTS < iTN.endTS){
      // rootList[i...] are subtrees of iTN
      assert(((TreeNode)rootList.elementAt(i)).startTS == iTN.startTS);

      assert iTN.precisedRootList.size() == 0: "princem: next while loop only valid if this condition is true";
      
      // move the subtrees to iTN and replace them with iTN
      while(rootList.size() > i){
        //princem: can optimize here
        //iTN.precisedRootList.append((TreeNode)rootList.remove(i));
    	  iTN.precisedRootList.rootList.add((TreeNode)rootList.remove(i));        
      }
      
      // adjust prevNode of the left-most leaf of iTN.precisedRootList such that
      // it points to dummyNode of iTN.precisedRootList
      TreeNode tempNode = (TreeNode)iTN.precisedRootList.rootList.firstElement();
      while(tempNode.level > 0 && !(tempNode instanceof ImpreciseTreeNode)){
        tempNode = tempNode.getLeftChild();
      }
      iTN.precisedRootList.dummyNode.setNext(tempNode);
      tempNode.setPrev(iTN.precisedRootList.dummyNode);
      // adjust lastAdded of iTN.precisedRootList such that it points to
      // the right-most leaf of iTN.precisedRootList
      tempNode = (TreeNode)iTN.precisedRootList.rootList.lastElement();
      while(tempNode.level > 0 && !(tempNode instanceof ImpreciseTreeNode)){
        tempNode = tempNode.getRightChild();
      }
      iTN.precisedRootList.lastAdded = tempNode;

      // adjust lastAdded of this RootList so that iTN get linked correctly
      // when it gets appended
      if(rootList.size() > 0){
        TreeNode t = (TreeNode)rootList.lastElement();
        while(t.level > 0 && !(t instanceof ImpreciseTreeNode)){
          t = t.getRightChild();
        }
        lastAdded = t;
      }else{
        lastAdded = dummyNode;
      }
      append(iTN);     
      
      return null;
    }else{
      TreeNode t = ((TreeNode)rootList.elementAt(i));

      while(!(t.startTS == iTN.startTS && t.endTS == iTN.endTS)){
        if(t.level == 0){
          throw new UnmatchingTreeNodeException();
        }

        if(t instanceof ImpreciseTreeNode){

          ImpreciseTreeNode IT = (ImpreciseTreeNode)t;

         // debug code added and later commented by Prince
//          if(t.startTS == iTN.startTS && t.endTS == iTN.endTS){
//              if(!Arrays.equals(t.superhash, iTN.superhash)){
//                throw new UnmatchingTreeNodeException();
//              }
//              else
//              {
//            	  return;
//              }
//          }
          IT.applyTreeNode(iTN);          

          //If possible, replace ImpreciseTreeNode with precise one
          if( !IT.precisedRootList.rootList.isEmpty() &&
              IT.level == ((TreeNode)IT.precisedRootList.rootList.firstElement()).level){
            makeItPrecise(IT, i, iTN);
            return new Range(IT.startTS, IT.endTS);
          }

          return null;
        }

        if(t.getLeftChild().endTS < iTN.startTS){
          t = t.getRightChild();
        }else{
          t = t.getLeftChild();
        }
      }
      // Here t should match iTN
      if(t.startTS == iTN.startTS && t.endTS == iTN.endTS){
        if(!Arrays.equals(t.superhash, iTN.superhash)){
          throw new UnmatchingTreeNodeException();
        }
      }
    }// end of else
    
    return null;
  }

  /**
   * Add a preciseTreeNode
   * @param pTN
   * @throws UnmatchingTreeNodeException
   */
  private Range applyPreciseTreeNode(TreeNode pTN) 
  throws UnmatchingTreeNodeException{
    
    if(rootList.isEmpty() 
        || ((TreeNode)rootList.lastElement()).endTS < pTN.startTS){
      append(pTN);
      return null;
    }
    // Binary search for rootList[i] which includes pTN.startTS
    int i = binarySearch(pTN.startTS);

    TreeNode t = ((TreeNode)rootList.elementAt(i)).getLeafTS(pTN.startTS);

    if( t instanceof ImpreciseTreeNode){
      ImpreciseTreeNode IT = (ImpreciseTreeNode)t;
      IT.applyTreeNode(pTN);      

      //If possible, replace ImpreciseTreeNode with precise one
      if( !IT.precisedRootList.rootList.isEmpty() &&
          IT.level == ((TreeNode)IT.precisedRootList.rootList.firstElement()).level){
        if(!Arrays.equals(IT.precisedRootList.rootList.firstElement().superhash, IT.superhash)){
          System.out.println("IT" + IT);
          System.out.println("precisedRootList" + IT.precisedRootList.rootList);
          throw new UnmatchingTreeNodeException();
        }else{
          makeItPrecise(IT, i, pTN);
          return new Range(IT.getStartTS(), IT.getEndTS());
        }
      }

    }else{
      // t is not ImpreciseTreeNode, hence t should match pTN
      if(!t.equals(pTN)){
        throw new UnmatchingTreeNodeException();
      }
    }
    return null;

  }

  /**
   * make an imprecise tree node precise that has become precise due to addition of appliedNode (last Node)
   * @param iTN
   * @param index index of the rootList entry that contains the impreciseTreeNode iTN
   * @param appliedNode the node which was applied and caused the impreciseTreeNode to become precise
   */
  private void makeItPrecise(ImpreciseTreeNode iTN, int index, TreeNode appliedNode){
    assert iTN.precisedRootList.size() == 1;
    if(iTN == ((TreeNode)rootList.elementAt(index))){
      rootList.setElementAt(iTN.precisedRootList.rootList.firstElement(), index);
    }else{
      if(iTN.parent.endTS == iTN.endTS){
        iTN.parent.setRightChild((TreeNode)iTN.precisedRootList.rootList.firstElement());
      }else if(iTN.parent.startTS == iTN.startTS){
        iTN.parent.setLeftChild((TreeNode)iTN.precisedRootList.rootList.firstElement());
      }else
      {
    	  assert false: "Prince thinks this case shouldn't occur";
      }
    }

    // adjust link
    TreeNode tempNode = (TreeNode)iTN.precisedRootList.rootList.firstElement();
    while(!(tempNode.level == 0 || tempNode instanceof ImpreciseTreeNode)){
      tempNode = tempNode.getLeftChild();
    }
    TreeNode prev = iTN.getPrev();
    assert prev != null;
    prev.setNext(tempNode);
    tempNode.setPrev(prev);

    tempNode = (TreeNode)iTN.precisedRootList.rootList.lastElement();
    while(!(tempNode.level == 0 || tempNode instanceof ImpreciseTreeNode)){
      tempNode = tempNode.getRightChild();
    }
    assert(tempNode == appliedNode);
    TreeNode next = iTN.getNext();
    if(next != null){
      next.setPrev(tempNode);
    }else{
      //princem: see if the following change makes sense
      assert lastAdded.endTS == tempNode.endTS;
      lastAdded = tempNode;
      
//      if(iTN.parent == null){
//        assert lastAdded.endTS == tempNode.endTS;
//        lastAdded = tempNode;
//      }else if(tempNode instanceof ImpreciseTreeNode){
//        assert(false);
//        //This case can't happen: an imprecise inval inside another imprecise inval and inner imprecise inval is made precise without 
//        // making the outer imprecise inval precise
//        // ((ImpreciseTreeNode)iTN.parent).precisedRootList.lastAdded = tempNode;
//      }else if(lastAdded.endTS == tempNode.endTS){
//    	  lastAdded = tempNode;
//      }
    }

    
    tempNode.setNext(next);
    iTN.setPrecise(true);
    
  }




 /** 
  /*
  private void xapplyPreciseTreeNode(TreeNode pTN) 
  throws UnmatchingTreeNodeException{
    if(rootList.isEmpty() 
        || ((TreeNode)rootList.lastElement()).endTS < pTN.startTS){
      append(pTN);
      return;
    }

    // Binary search for rootList[i] which includes pTN.startTS
    int i = binarySearch(pTN.startTS);

    // Search a tree for TreeNode that matches pTN
    TreeNode t = ((TreeNode)rootList.elementAt(i)).getTreeNodeTS(pTN.startTS);

    if(!t.isPrecise()){
      ImpreciseTreeNode IT = (ImpreciseTreeNode)t;

      TreeNode next = IT.getNext();

      IT.precisedRootList.applyTreeNode(pTN);

      //If possible, replace ImpreciseTreeNode with precise one
      if( !IT.precisedRootList.rootList.isEmpty() &&
          IT.level == ((TreeNode)IT.precisedRootList.rootList.firstElement()).level){

        assert IT.precisedRootList.size() == 1;
        if(t == ((TreeNode)rootList.elementAt(i))){
          rootList.setElementAt(IT.precisedRootList.rootList.firstElement(), i);
        }else{
          if(IT.parent.endTS == IT.endTS){
            IT.parent.setRightChild((TreeNode)IT.precisedRootList.rootList.firstElement());
          }else if(IT.parent.startTS == IT.startTS){
            IT.parent.setLeftChild((TreeNode)IT.precisedRootList.rootList.firstElement());
          }
        }

        // adjust link
        TreeNode tempNode = (TreeNode)IT.precisedRootList.rootList.firstElement();
        while(!(tempNode.level == 0 || !tempNode.isPrecise())){
          tempNode = tempNode.getLeftChild();
        }
        TreeNode prev = IT.getPrev();
        assert prev != null;
        prev.setNext(tempNode);
        tempNode.setPrev(prev);

        tempNode = (TreeNode)IT.precisedRootList.rootList.lastElement();
        while(!(tempNode.level == 0 || !tempNode.isPrecise())){
          tempNode = tempNode.getRightChild();
        }

        if(next != null){
          next.setPrev(tempNode);
        }else{
          if(IT.parent == null){
            assert lastAdded.endTS == tempNode.endTS;
            lastAdded = tempNode;
          }else if(!IT.parent.isPrecise()){
            ((ImpreciseTreeNode)IT.parent).precisedRootList.lastAdded = tempNode;
          }
        }
        tempNode.setNext(next);
        IT.setPrecise(true);
      }

    }else{
      // t is not ImpreciseTreeNode, hence t should match pTN
      if(!t.equals(pTN)){
        throw new UnmatchingTreeNodeException();
      }
    }


  }
   */

  /**
   * Apply a treenode to the RootList
   * @param v
   * @throws UnmatchingTreeNodeException if the tree contains a conflicting node or non FIFO-compliant node
   */
  public synchronized Range applyTreeNode(TreeNode v) throws UnmatchingTreeNodeException{
    if(dbg)System.out.println("applyTreeNode: " + v);

    Range r = null;
    if(v instanceof ImpreciseTreeNode){
      assert (!SecurityFilter.sanityCheck || isConsistent());

      r = applyImpreciseTreeNode((ImpreciseTreeNode)v);
      assert isConsistent();

    }else{
      if(dbg){
        System.out.println("RootList::apply() called:" + v.getInv());
      }
      assert (!SecurityFilter.sanityCheck || isConsistent());

      r = applyPreciseTreeNode(v);
      assert isConsistent();

    }    
    return r;
  }

//  /**
//   * Apply an AHS  to the RootList
//   * @param v
//   * @throws UnmatchingTreeNodeException if the tree contains a conflicting node or non FIFO-compliant node
//   */
//
//  public synchronized void applyAHS(AHS ahs, SecureInv sii) throws UnmatchingTreeNodeException{
//	  if(dbg)System.out.println("applyAHS: " + sii + " current root list " + this.getAllNodes() + " this "+ this.hashCode());
//
//    List<AHSEntry> l = ahs.getSortedListOfEntries();
//    Iterator<AHSEntry> iter;
//    assert isConsistent();
//
//    for(iter = l.iterator(); iter.hasNext();){
//      assert isConsistent();
//      applyTreeNode(new ImpreciseTreeNode(iter.next(), sii, writer));
//      assert isConsistent();
//
//    }
//    if(dbg)System.out.println("current rootlist: " + this.getAllNodes()+ " this "+ this.hashCode());
//
//
//  }
  
  /**
   * Apply an AHS  to the RootList
   * @param v
   * @return the range in the older AHS where the new inval is inserted. For appended invals, null is returned
   * @throws UnmatchingTreeNodeException if the tree contains a conflicting node or non FIFO-compliant node
   */

  public synchronized Range applyAHSEntry(AHSEntry ahsEntry, SecureInv sii) throws UnmatchingTreeNodeException{
          if(dbg)System.out.println("applyAHS: " + sii + " current root list " + this.getAllNodes() + " this "+ this.hashCode());

   
    assert (!SecurityFilter.sanityCheck || isConsistent());


    Range r = applyTreeNode(new ImpreciseTreeNode(ahsEntry, sii, writer));
    assert isConsistent();

    if(dbg)System.out.println("current rootlist: " + this.getAllNodes()+ " this "+ this.hashCode());

    return r;

  }

  /**
   * Apply a securePreciseInv to the RootList after creating a treenode for this securePreciseInv
   * @param spi
   * @param ahsMap
   * @return the range in the older AHS where the new inval is inserted. For appended invals, null is returned
   * @throws UnmatchingTreeNodeException
   */
  public synchronized Range applySecurePreciseInv(SecurePreciseInv spi, AHSMap ahsMap) throws UnmatchingTreeNodeException{
	  if(dbg)System.out.println("apply: " + spi);

	  assert (!SecurityFilter.sanityCheck || isConsistent());

    Range r = this.applyTreeNode(new TreeNode(spi, ahsMap));
    if(dbg)System.out.println("current rootlist: " + getAllNodes() + " this "+ this.hashCode());

    assert isConsistent();
    return r;

  }

  /**
   * creats an AHS for a given range
   * @param startTS
   * @param endTS
   * @return
   */
  public synchronized AHS createAHS(long startTS, long endTS){
    AHS ahs = new AHS();
 // TODO: rootList is sorted; Do a binary search 
    for(int i=0; i < rootList.size(); i++){
      ((TreeNode)rootList.elementAt(i)).getTreeAHS(startTS, endTS, ahs);
    }
    return ahs;
  }

  /**
   * returns immediately preceeding treenode for the given ts
   * always returns DummyTreeNode if ts < first valid ts or no valid ts exists
   * @param ts
   * @return
   */
  public synchronized TreeNode getLastTreeNodePriorTo(long ts){
    if(size() <= 0){
      return lastAdded;
 // return null; 
    }
    TreeNode lastRootNode =(TreeNode)rootList.lastElement();

    if(lastRootNode.endTS < ts){
      return lastRootNode.getTreeNodeTS(lastRootNode.endTS);
    }

    for(int i=0; i < rootList.size(); i++){
      TreeNode t = (TreeNode)rootList.elementAt(i);

      if( t.startTS <= ts && t.endTS >= ts){
//        TreeNode t1 = t.getTreeNodeTS(ts);
        TreeNode t1 = t.getLeafTS(ts);
        if(t1.level == 0){
          // t1 is a leaf
          return t1.getPrev();
        }else if(t1 instanceof ImpreciseTreeNode){
          // t1 is an imprecise tree node
          TreeNode prevTreeNode = ((ImpreciseTreeNode)t1).precisedRootList.getLastTreeNodePriorTo(ts);
          if(prevTreeNode == null || prevTreeNode.equals(dummyNode)){
            return t1.getPrev();
          }else{
            return prevTreeNode;
          }
        }else{
          // t1 is an internal node
          assert(t1.getLeftChild().endTS < ts);
          return t1.getLeftChild();
        }
      }else if( ts < t.startTS){
        TreeNode t1 = t.getTreeNodeTS(t.startTS);
        return t1.getPrev();
      }
    }
    assert(false);
    return null;
  }

  /**
   * returns immediately next treenode for the given ts
   * always returns null if ts > last valid ts or no valid treenode with startTS > ts exists
   * @param ts
   * @return
   */
  public synchronized TreeNode getTreeNodeAfter(long ts){
    if(size() <= 0){
      return null;
    }

    TreeNode firstRootNode = (TreeNode)rootList.firstElement();

    if(firstRootNode.startTS > ts){
      return firstRootNode.getTreeNodeTS(firstRootNode.startTS);
    }

    for(int i=0; i<rootList.size(); i++){
      TreeNode t = (TreeNode)rootList.elementAt(i);
      if( t.startTS <= ts && t.endTS >= ts){
        TreeNode t1 = t.getTreeNodeTS(ts);
        if(t1.level == 0){
          return t1.getNext();
        }else if(t1 instanceof ImpreciseTreeNode){
          TreeNode nextTreeNode = ((ImpreciseTreeNode)t1).precisedRootList.getTreeNodeAfter(ts);
          if(nextTreeNode == null){
            return t1.getNext();
          }else{
            return nextTreeNode;
          }
        }else{
          assert(t1.getRightChild().startTS > ts);
          return t1.getRightChild();
        }
      }else if( ts < t.startTS){
        TreeNode t1 = t.getTreeNodeTS(t.startTS);
        return t1;
      }
    }

    return null;
  }

  /**
   * returns the most precise tree (traversing RootLists recursive for impreciseTreeNodes)
   * node that contains this ts
   * returns null if no matching treenode
   * @param ts
   * @return
   */
  public synchronized TreeNode getTreeNodeTS(long ts){

    if(ts < 0){
      return dummyNode;
    }

    if(this.getStartTS() > ts || this.getEndTS() < ts){
      return null;
    }

    for(int i=0; i<rootList.size(); i++){
      TreeNode t = rootList.elementAt(i);
      if(ts < t.startTS){
        return null;
      }else if(ts >= t.startTS && ts <= t.endTS){
        return t.getTreeNodeTS(ts);
      }
    }

    return null;    
  }
  
  /**
   * Returns a treeNode containing a given TS (most precise node present in the chain)
   * @param ts
   * @return
   */
  public synchronized TreeNode getLeafNodeTS(long ts){

    if(ts < 0){
      return dummyNode;
    }

    if(this.getStartTS() > ts || this.getEndTS() < ts){
      return null;
    }

    for(int i=0; i<rootList.size(); i++){
      TreeNode t = rootList.elementAt(i);
      if(ts < t.startTS){
        return null;
      }else if(ts >= t.startTS && ts <= t.endTS){
        return t.getLeafTS(ts);
      }
    }

    return null;    
  }

  /**
   * returns startTS
   * @return
   */
  public synchronized long getStartTS(){
    if(rootList.size() > 0){
      return ((TreeNode)rootList.firstElement()).getStartTS();
    }else{
      return -1;
    }
  }

  /**
   * returns EndTS
   * @return
   */
  public synchronized long getEndTS(){
    if(rootList.size() > 0){
      return ((TreeNode)rootList.lastElement()).getEndTS();
    }else{
      return -1;
    }
  }

  /**
   * clones
   */
  public synchronized RootList clone(){
    assert (!SecurityFilter.sanityCheck || this.isConsistent());
    RootList ret = new RootList(writer);
    for(int i=0; i < this.rootList.size(); i++){
      ret.rootList.add(((TreeNode)this.rootList.elementAt(i)).clone());

      if(i>0){
        TreeNode t1 = ret.rootList.elementAt(i-1).getRightMostChild();
        TreeNode t2 = ret.rootList.elementAt(i).getLeftMostChild();
        t1.setNext(t2);
        t2.setPrev(t1);

      }else{
        TreeNode t1 = ret.rootList.elementAt(i).getLeftMostChild();
        ret.dummyNode.setNext(t1);
        assert t1 != null;
        t1.setPrev(ret.dummyNode);
      }
    }
    assert ret.isConsistent();
    return ret;
  }
  
  public TreeNode getDummyNode(){
    return dummyNode;
  }

  private synchronized Vector<TreeNode> getAllNodes()
  {
	  Vector<TreeNode> allNodeList = new Vector<TreeNode>();
	    for(TreeNode t: rootList){
	      allNodeList.addAll(t.getAllChildren());
	    }
	    return allNodeList;
  }
  
  public synchronized Vector<Integer> onDiskSize()
  {
    Vector<Integer> v = new Vector<Integer>();
    int onDiskSize= 0;
    int logicalSize = 0;
    for(TreeNode t: rootList){
      Vector<Integer> s = t.onDiskSize();
      onDiskSize += s.get(0);
      logicalSize += s.get(1);
    }
    v.add(onDiskSize);
    v.add(logicalSize);
    return v;
  }
  
  public synchronized boolean isConsistent(){
    assert lastAdded!=null;
    TreeNode cur = dummyNode;
    Vector<TreeNode> allNodeList = getAllNodes();

    for(TreeNode iteratorNode: allNodeList){
      assert(cur.getNext() != null):"Inconsistent AHS graph: treePointers:" + allNodeList + " curTreePtr:"+iteratorNode+" linkPtr:"+cur+" nextPtr NULL \n";
      assert(iteratorNode == cur.getNext()):"Inconsistent AHS graph: treePointers:" + allNodeList + " curTreePtr:"+iteratorNode+" linkNextPtr:"+cur.getNext() + " \n ";
      cur = cur.getNext();
    }
    return true;
  }
  
  public synchronized boolean isLinear(){
    assert lastAdded!=null;
    TreeNode cur = dummyNode;
    
    while(cur!=null){
      if(cur instanceof ImpreciseTreeNode){
        ImpreciseTreeNode itn = (ImpreciseTreeNode)cur;
        if( itn.precisedRootList.size() != 0){
	    System.out.println("ImpreciseTreeNode" + itn + " preciseRootList " + itn.precisedRootList);
	    return false;
	}
      }else{
        assert cur.level <= 0: cur;// <0 to accomodate the dummynode
      }
      cur = cur.getNext();
    }
    return true;
  }

  /**
   * returns the "union" of IDVV since last pi till the provided ts (inclusive)
   * @param pi
   * @return
   */
  public synchronized DVVMap getUnverifiedIDVV(long ts){
    DVVMap dvvMap = new DVVMap();
    if(ts >=0 ){
      int index = this.binarySearch(ts);
      TreeNode tn = rootList.get(index).getLeafTS(ts);
      if(SecurityFilter.dbg)System.out.println("binary search of " + ts +" gave " + tn);
      if(tn == null){
        assert false: "don't have precise information to verify this inval" + " ts  " + ts ;
      }else if(tn.getEndTS() > ts){
        if(tn instanceof ImpreciseTreeNode){
          RootList innerRootList = ((ImpreciseTreeNode)tn).getPrecisedRootList();
          if(innerRootList.lastAdded.endTS >= ts){
	      //if(SecurityFilter.dbg)System.out.println("--- extending dvvMap with " + tn + " old DVVMap " + dvvMap);
            dvvMap = dvvMap.extend(innerRootList.getUnverifiedIDVV(ts));
	    if(SecurityFilter.dbg)System.out.println("--- extending dvvMap with " + tn + " new DVVMap " + dvvMap);
	    tn = tn.getPrev();
          }
        }else{
          assert false: "don't have precise information to verify this inval" + " ts  " + ts ;
        }
      }
      
      while(!tn.equals(dummyNode) && !(tn.getInv() != null && tn.getInv() instanceof PreciseInv)){
	  if(SecurityFilter.dbg)System.out.println("extending dvvMap with " + tn + " new DVVMap " + dvvMap);
        dvvMap = dvvMap.extend(tn.maxDVVMap);
        assert tn.getPrev() != null || tn.equals(dummyNode): dummyNode + " tn " + tn;
        tn = tn.getPrev();
      }
      if(SecurityFilter.dbg){
	  System.out.println("exitting while loop because reached " + tn.equals(dummyNode) + " second CONDITION " + (tn.getInv()!= null && tn.getInv() instanceof PreciseInv) + "\n " + tn);
      }
    }
    
    if(SecurityFilter.sanityCheck){
    DependencyVV dvv =dvvMap.getDVV();
    VVIterator vvi = dvv.getIterator();
    while(vvi.hasMoreElements()){
      NodeId n = vvi.getNext();
      assert dvv.getStampByIteratorToken(n) <= ts: dvv + " ts " + ts + "\n rootList" + this;
    }
    }
    
    return dvvMap;
  }
}
