package code.security.ahs;

import code.AcceptVV;
import code.NodeId;
import code.SingleWriterInval;

// TreeNode -> TreeNode
public class SecureReverseTreeNodeIterator{

    private TreeNodePointers sentPointers;

    /**
     * 
     */
    public SecureReverseTreeNodeIterator(AcceptVV includedEndVV, AHSMap ahs){
      //populate the next items for each writer
      assert ahs != null;
      sentPointers = ahs.getIncludedReverseSentPointers(includedEndVV.dropNegatives());        
      
    }
    
    
    
    //tbd, are we sure that we can call nextPointers.size()
    //without any locking of the items?
    public boolean hasPrev(){
      return sentPointers.hasPrev();
    }

    /**
     * just get the next sentable item with the minimum start
     * advance cvv
     * 
     * tbd, make sure that it's ok
     */
    public NodeTreeNodeTuple prev(){
      
      NodeTreeNodeTuple prevItem = sentPointers.prevSentableItem();
      if(prevItem != null){
        sentPointers.retreat(prevItem.getNodeId(), prevItem.getTreeNode().getPrev());
      }
    
      return prevItem;
    }       
    
    public void remove()
    throws UnsupportedOperationException{
      throw new UnsupportedOperationException("InMemLogIterator.remove() is not supported"); 
    }
}
