package code.security.ahs;

import java.util.Iterator;
import code.AcceptVV;
import code.NodeId;
import code.SingleWriterInval;

// TreeNode -> TreeNode
public class SecureTreeNodeIterator implements Iterator<NodeTreeNodeTuple>{

    private TreeNodePointers sentPointers;

    /**
     * 
     */
    public SecureTreeNodeIterator(AcceptVV excludedStartVV, AHSMap ahs){
      //populate the next items for each writer
      assert ahs != null;
      sentPointers = ahs.getSentPointers(excludedStartVV);        
      
    }
    
    
    
    //tbd, are we sure that we can call nextPointers.size()
    //without any locking of the items?
    public boolean hasNext(){
      return sentPointers.hasNext();
    }

    /**
     * just get the next sentable item with the minimum start
     * advance cvv
     * 
     * tbd, make sure that it's ok
     */
    public NodeTreeNodeTuple next(){
      
      NodeTreeNodeTuple nextItem = sentPointers.nextSentableItem();
      if(nextItem != null){
        sentPointers.advance(nextItem.getNodeId(), nextItem.getTreeNode());
      }
    
      return nextItem;
    }       
    
    public void remove()
    throws UnsupportedOperationException{
      throw new UnsupportedOperationException("InMemLogIterator.remove() is not supported"); 
    }
}
