package code.security.ahs;

import code.AcceptStamp;
import code.AcceptVV;
import code.InvalListItem;
import code.NodeId;
import code.SingleWriterInval;
import code.security.*;
import code.security.ahs.*;
import java.util.TreeMap;
import java.util.HashMap;
import code.GeneralInv;


/**
 * This class is a util class to store a set of <writerId, InvalListItem>
 * to represent the current position in the per-writer-log of writerId.
 * 
 * 
 * @author zjiandan
 *
 */
public class TreeNodePointers{
  private final static boolean dbg = false;
  /**
   * this map gives the last TreeNode that was sent for each NodeId
   */
  TreeMap<NodeId, TreeNode> pointers = null;
  
  public TreeNodePointers(HashMap<NodeId, TreeNode> pointers){
    super();
    this.pointers = new TreeMap<NodeId, TreeNode>(pointers);
  }

  public TreeNodePointers(){
    super();
    pointers = new TreeMap<NodeId, TreeNode>();
  }
  
  public NodeId[]
  getAllNodeIds(){
    return (NodeId[]) pointers.keySet().toArray();
  }
  
  public TreeNode
  getTreeNode(NodeId id){
    return pointers.get(id);
  }
              
  public boolean
  contains(NodeId id){
    return pointers.containsKey(id);
  }
  
  
  
  public void
  add(NodeId id, TreeNode item){
    assert !pointers.containsKey(id);
    assert item != null;
    pointers.put(id, item);
  }
  
  public void
  remove(NodeId id, TreeNode item){
    assert item.equals(pointers.get(id));
    pointers.remove(id);
  }

  public void
  advance(NodeId id, TreeNode item){
    assert pointers.containsKey(id);
    assert pointers.get(id).getNext() == item:pointers.get(id).getNext() + " it should be item: " + item;
    assert item != null;
    pointers.put(id, item);
  }
  
  /**
   * return the next sentable items such that its DVV lies within sentVV (there must be one)
   * null is returned if we are at the last item
   * @param sentvv
   * @return
   */
  public TreeNode nextSentableItem(AcceptVV sentvv){
    TreeNode ret = null;
    if (pointers.size()!=0){
      
      Object[] allkeys = pointers.keySet().toArray();
      assert allkeys.length != 0;
      
      TreeNode curItem = null, lastSentItem = null;
      boolean found = false;
      boolean hasNewItem = false;
      for(int i = 0; i < allkeys.length; i++){
    	curItem = ((TreeNode)pointers.get(allkeys[i])).getNext();
        lastSentItem = (TreeNode)pointers.get(allkeys[i]);
        assert lastSentItem != null;
        if(dbg){
          System.out.println("lastSentItem=" + lastSentItem.getInv());
        }
    	curItem = lastSentItem.getNext();
    	if(dbg && curItem != null){
          System.out.println("lastSentItem.getNext=" + lastSentItem.getInv());
        }
    	AcceptStamp endStamp = null;
    	if(curItem != null){
    	  endStamp = new AcceptStamp(curItem.getEndTS(), (NodeId)(allkeys[i]));
    	  if(dbg){
    	    System.out.println("ignore the curItem:" + curItem.getInv() + " \n cvv: " + sentvv);
            System.out.println("curItem.start=" + curItem.getStartTS() + "curItem.end = " + curItem.getEndTS());
    	  }
    	}
    	//while((curItem != null) && sentvv.includes(curItem.getInv().getEndVV())){//already sent by looking at inv.endVV
    	while((curItem != null) && sentvv.includes(endStamp)){//already sent by looking at TreeNode.endStamp
    	  
    	  this.advance((NodeId)(allkeys[i]), 
    	                curItem);
    	  curItem = curItem.getNext();    	  
    	  if(curItem != null){
    	    endStamp = new AcceptStamp(curItem.getEndTS(), (NodeId)(allkeys[i]));
    	    if(dbg){
      	    System.out.println("**ignore the curItem:" + curItem.getInv() + " \n cvv: " + sentvv);
              System.out.println("**curItem.start=" + curItem.getStartTS() + "curItem.end = " + curItem.getEndTS());
              System.out.println("**curItem.hashCode()=" + curItem.hashCode());
    	    }
    	  }
    	  
    	  if(dbg && curItem == null){
            System.out.println("node " + allkeys[i] + " has been advanced to the end.");
          }
    	  
    	}
    	
    	if(curItem != null) {
    	   hasNewItem = true;
    	   
    	   if(sentvv.includes(((SecureInv)(curItem.getInv())).getExternalDVV())){//sentable
    	     ret = curItem;
    	     found = true;
    	     break;
    	   }else{
    	     if(dbg){
    	       System.out.println("\n \n sentVV = " + sentvv + " item: " + curItem.getInv() + " with externalDVV= " 
    	         + ((SecureInv)(curItem.getInv())).getExternalDVV());
    	     }
    	   }
    	}else{
    	  if(dbg){
    	    System.out.println("no new item at node" + allkeys[i] + " sentvv=" +sentvv);
    	  }
    	}
      }
      assert !hasNewItem || found;// for uni-writer imprecise, either nothing to send 
      //or has at least one item sentable.
      //
      //for multi-writer imprecise, need more sophisticated algorithm to find the next sentable one
    }
    
    return ret;
  }
  
  public int size(){
    return pointers.size();
  }
  
 /** 
 *  Return true if "this" equals "obj" 
 **/ 
  public boolean
  equals(Object obj){
    boolean result = false;
    TreeNodePointers target = null;
    if(obj instanceof TreeNodePointers){
      result = true;
      target = (TreeNodePointers) obj;
      NodeId[] nodes = pointers.keySet().toArray(new NodeId[0]);
      for(int i = 0; i < nodes.length; i++){
        if((pointers.get(nodes[i]) != target.pointers.get(nodes[i]))){
          return false;
        }
      }
    }
    return(result);
  }

  public boolean hasNext(){
    if(pointers.size()==0){
      if(dbg){
        System.out.println("hasNext() return false because the pointer has no sent items.");
      }
      return false;
    }
    Object[] allItems = pointers.values().toArray();
    assert allItems.length != 0;
    
    TreeNode curItem = null;
    
    for(int i = 0; i < allItems.length; i++){
      curItem = (TreeNode)allItems[i];
      assert curItem != null;
      if(dbg){
          System.out.println("item " + i + ":" + curItem.getInv());
      }
      if(curItem.getNext() != null){
        if(dbg){
          System.out.println("hasNext() return true.");
        }
        return true;
      }
    }
    if(dbg){
      System.out.println("hasNext() return false because no more new items.");
    }
    return false;
  } 

  public boolean hasPrev(){
    if(pointers.size()==0){
      return false;
    }
    Object[] allItems = pointers.values().toArray();
    assert allItems.length != 0;
    
    TreeNode curItem = null;
    
    for(int i = 0; i < allItems.length; i++){
      curItem = (TreeNode)allItems[i];
      if(curItem != null && curItem.endTS != -1){
        return true;
      }
    }
    return false;
  } 
  
  //princem: can be optimized by replacing pointers with a heap
  private NodeTreeNodeTuple max(){
    
    NodeTreeNodeTuple ret = new NodeTreeNodeTuple();
    if (pointers.size()!=0){
      
      Object[] allItems = pointers.keySet().toArray();
      assert allItems.length != 0;
      int counter = 0;
      // loop till first non-default entry found
      while(counter < allItems.length){
        ret.setTreeNode((TreeNode)pointers.get(allItems[counter]));
        ret.setNodeId((NodeId)allItems[counter]);
        
        if(ret.getTreeNode().endTS != -1){
          break;
        }
        counter++;
      }
      
      // if no entry found, return null
      if(counter == allItems.length){
        return null;
      }
      
      // if some non-null entry found, then search amongst the remaining entries to get the largest entry
      NodeId nId = ret.getNodeId();
      TreeNode inv = ret.getTreeNode();
      AcceptStamp maxTime = new AcceptStamp(inv.getEndTS(), nId);
      AcceptStamp newTime = null;
      for(int i = counter+1; i < allItems.length; i++){
        inv = pointers.get(allItems[i]);
        newTime = new AcceptStamp(inv.getEndTS(), (NodeId)allItems[i]);
        if(newTime.gt(maxTime)){
          maxTime = newTime;
          ret.setNodeId((NodeId)allItems[i]);
          ret.setTreeNode(pointers.get(allItems[i]));
        }
      }
    }
    
    return ret;
  }
  
  
//princem: can be optimized by replacing pointers with a heap
  /**
   * returns the min Next entry based on the endTS
   */
  private NodeTreeNodeTuple min(){
    
    NodeTreeNodeTuple ret = new NodeTreeNodeTuple();
    if (pointers.size()!=0){
      
      Object[] allItems = pointers.keySet().toArray();
      assert allItems.length != 0;
      int counter = 0;
      // loop till first non-default entry found
      while(counter < allItems.length){
        if(pointers.get(allItems[counter]).getNext() != null){
          ret.setTreeNode(pointers.get(allItems[counter]).getNext());
          ret.setNodeId((NodeId)allItems[counter]);
          break;
        }
        counter++;
      }
      
      // if no entry found, return null
      if(counter == allItems.length){
        return null;
      }
      
      // if some non-null entry found, then search amongst the remaining entries to get the largest entry
      NodeId nId = ret.getNodeId();
      TreeNode inv = ret.getTreeNode();
      AcceptStamp minTime = new AcceptStamp(inv.getEndTS(), nId);
      AcceptStamp newTime = null;
      for(int i = counter+1; i < allItems.length; i++){
        inv = pointers.get(allItems[i]).getNext();
        if(inv != null){
          newTime = new AcceptStamp(inv.getEndTS(), (NodeId)allItems[i]);
          if(newTime.lt(minTime)){
            minTime = newTime;
            ret.setNodeId((NodeId)allItems[i]);
            ret.setTreeNode(pointers.get(allItems[i]).getNext());
          }
        }
      }
    }
    
    return ret;
  }
  
  /**
   * returns the min Next entry based on the endTS
   */
  private NodeTreeNodeTuple minStartTS(){
    
    NodeTreeNodeTuple ret = new NodeTreeNodeTuple();
    if (pointers.size()!=0){
      
      Object[] allItems = pointers.keySet().toArray();
      assert allItems.length != 0;
      int counter = 0;
      // loop till first non-default entry found
      while(counter < allItems.length){
        if(pointers.get(allItems[counter]).getNext() != null){
          ret.setTreeNode(pointers.get(allItems[counter]).getNext());
          ret.setNodeId((NodeId)allItems[counter]);
          break;
        }
        counter++;
      }
      
      // if no entry found, return null
      if(counter == allItems.length){
        return null;
      }
      
      // if some non-null entry found, then search amongst the remaining entries to get the largest entry
      NodeId nId = ret.getNodeId();
      TreeNode inv = ret.getTreeNode();
      AcceptStamp minTime = new AcceptStamp(inv.getStartTS(), nId);
      AcceptStamp newTime = null;
      for(int i = counter+1; i < allItems.length; i++){
        inv = pointers.get(allItems[i]).getNext();
        if(inv != null){
          newTime = new AcceptStamp(inv.getStartTS(), (NodeId)allItems[i]);
          if(newTime.lt(minTime)){
            minTime = newTime;
            ret.setNodeId((NodeId)allItems[i]);
            ret.setTreeNode(pointers.get(allItems[i]).getNext());
          }
        }
      }
    }
    
    return ret;
  }
  
  public NodeTreeNodeTuple prevSentableItem(){
    NodeTreeNodeTuple maxTreeNode = max();
    if(maxTreeNode!= null && 
        maxTreeNode.getTreeNode() != null && 
        maxTreeNode.getTreeNode().endTS != -1){
      return maxTreeNode;
    }else{
      return null;
    }
  }
  
  public NodeTreeNodeTuple nextSentableItem(){
    NodeTreeNodeTuple minTreeNode = minStartTS();
    if(minTreeNode!= null && 
        minTreeNode.getTreeNode() != null){
      return minTreeNode;
    }else{
      return null;
    }
  }

  public void
  retreat(NodeId id, TreeNode item){
    assert pointers.containsKey(id);
    assert pointers.get(id).getPrev() == item:"Expected " + item + " found " + pointers.get(id).getPrev();
    pointers.put(id, item);
  }
}
