package code.security.ahs.unit;

import java.security.PrivateKey;
import java.security.PublicKey;

import code.*;
import code.security.*;
import code.security.ahs.AHS;
import code.security.ahs.AHSEntry;
import code.security.ahs.AHSMap;
import code.security.ahs.DVVMap;
import code.security.ahs.DependencyVV;
import code.security.ahs.UnmatchingTreeNodeException;
import code.security.holesync.filter.*;
import code.security.holesync.*;
import code.security.ahs.TreeNode;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import java.util.Vector;

public class RootListUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  AHSMap ahsMap = null;
  AHSMap copyAHSMap = null;

  PrivateKey privKey;
  PublicKey pubKey;
  NodeId nodeId;

  byte[] buffer;
  byte[] buffer2;
  Filter f;

  Vector invals = new Vector();


  public void testApplyImprecise(){
    // by setUp(), we already have 0-9 precise treenodes

    AHSMap newAHSMap = new AHSMap();
    newAHSMap.addFilter(new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*")));

    for(int i = 0; i < 10; i++)
    {
      try{
        newAHSMap.applySecurePreciseInv((SecurePreciseInv)invals.get(i));
        FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
        assert fk.getCVV().includes(((SecurePreciseInv)invals.get(i)).getAcceptStamp()): fk;
        assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
      }catch(UnmatchingTreeNodeException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }
    // apply three imprecise tree nodes 8-11, 12-13 and 0-31
    InvalTarget invTarget = new ObjInvalTarget(new ObjId("/rand4"), 5, 10);
    try{      

      AHSEntry ahsEntry = copyAHSMap.getRootList(nodeId).createAHS(8, 11).elementAt(0);
      newAHSMap.applyAHS(nodeId, new AHS(ahsEntry), null);
      FilterKnowledge fk = newAHSMap.getKnowledge().getFilterKnowledge(f);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry.getRange()): fk;
      
      AHSEntry ahsEntry2 = copyAHSMap.getRootList(nodeId).createAHS(12, 15).elementAt(0);
      
      newAHSMap.applyAHS(nodeId, new AHS(ahsEntry2), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry2.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry2.getRange()): fk;
      
      AHSEntry ahsEntry3 = copyAHSMap.getRootList(nodeId).createAHS(16, 31).elementAt(0);

      newAHSMap.applyAHS(nodeId, new AHS(ahsEntry3), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry3.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry3.getRange()): fk;
      
    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }

    // Now make imprecise tree node that spans 8-11 precise 
    // (currently 0 .. 9 are precise)
    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);

    try{
      FilterKnowledge fk = newAHSMap.getKnowledge().getFilterKnowledge(f);

      for(int i=10; i < 12; i++){
        DependencyVV dvv = new DependencyVV();
        dvv.put(nodeId, i-1);

        SecurePreciseInv spi =
          (SecurePreciseInv)invals.get(i);

        newAHSMap.applySecurePreciseInv(spi);
        assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
        for(Range r: fk.getHoles().get(nodeId)){
          assert (r.getEnd() > spi.getEnd()): r + " fk " + fk;
        }
      }  
        for(int i = 12; i < 13; i++){
          DependencyVV dvv = new DependencyVV();
          dvv.put(nodeId, i-1);

          SecurePreciseInv spi = (SecurePreciseInv)invals.get(i);

          newAHSMap.applySecurePreciseInv(spi);
          
        }
        TreeNode tn = newAHSMap.getLastTreeNodePriorTo(nodeId, 12);
        assert tn.getEndTS() == 11: tn;
        
    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }


  }

  public void testMakeItPrecise(){
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    AHSMap ahsMap = new AHSMap();
    ahsMap.addFilter(new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*")));

    for(int i=0; i < 10; i++){
      SecurePreciseInv spi =
        (SecurePreciseInv)invals.get(i);

      try {
        ahsMap.applySecurePreciseInv(spi);
        FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
        assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
        assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
      } catch (UnmatchingTreeNodeException e) {
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }    

    try{      

      AHSEntry ahsEntry = copyAHSMap.getRootList(nodeId).createAHS(10, 10).elementAt(0);

      ahsMap.applyAHS(nodeId, new AHS(ahsEntry), null);
      
      FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      assert fk.getCVV().includes(new AcceptStamp(10, nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry.getRange()): fk + " " + fk.getHoles().get(nodeId) ;
      SecurePreciseInv spi =
        (SecurePreciseInv)invals.get(10);

      try {
        ahsMap.applySecurePreciseInv(spi);
        assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
      } catch (UnmatchingTreeNodeException e) {
        // TODO Auto-generated catch block
        e.printStackTrace();
      }


    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }

  }

  public void testApplyAHSSecureImpreciseInv(){

    try{
      AHS ahs = copyAHSMap.getRootList(nodeId).createAHS(8, 11);
      assert ahs.size() == 1;
      ahsMap.applyAHS(nodeId, ahs, null);
      FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      assert fk.getCVV().includes(new AcceptStamp(11, nodeId)): fk;
      assert fk.getHoles().get(nodeId).contains(new Range(8, 11)): fk;
    }catch(Exception e){
      e.printStackTrace();
      fail("got exception");
    }

    
  }




  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    ahsMap = new AHSMap();
    copyAHSMap = new AHSMap();
    nodeId = new NodeId(10);
    f = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    ahsMap.addFilter(f);
    copyAHSMap.addFilter(f);

    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));

    buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);



    for(int i=0; i < 10; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand1/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals.add(spi);
      ahsMap.applySecurePreciseInv(spi);
      copyAHSMap.applySecurePreciseInv(spi);
      FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
      assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
    }    

    // Now we make imprecise iTn precise by applying precise
    // tree node from 10 to 19
    for(int i = 10; i<40; i++){

      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand1/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      try{
        copyAHSMap.applySecurePreciseInv(spi);
        FilterKnowledge fk = copyAHSMap.getKnowledge().getFilterKnowledge(f);
        assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
        assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
        invals.add(spi);
      } catch (Exception e){
        e.printStackTrace();
        fail("exception" + e);
      }
    }


  }


///*
//* Fixtures are run before and after each test case
//* to set up environment in which tests must run.
//*/
//protected void setUp() throws Exception{
//super.setUp();
//nodeId = new NodeId(10);

//Config.readKeys();
//privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
//pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));


//}

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(RootListUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "RootListUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
