package code.security.ahs.unit;

import	code.Config;
import code.AcceptStamp;
import code.GeneralInv;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.ObjId;
import code.NodeId;
import code.SubscriptionSet;
import code.security.SecureCore;
import code.security.SecureInMemLogIterator;
import code.security.SecureRMIClient;
import code.SingleWriterImpreciseInv;

import java.io.File;
import java.util.LinkedList;

import code.AcceptVV;
import code.PreciseInv;
import code.ObjInvalTarget;
import code.ImmutableBytes;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.security.SecurityFilter;
import code.security.ahs.NodeTreeNodeTuple;
import code.security.ahs.RootList;
import code.security.ahs.SecureTreeNodeIterator;
import code.security.ahs.TreeNode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;

public class SecureTreeNodeIteratorUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  private static final boolean dbg = true; 
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();

  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";

    for(int i = 0; i < total; i++){

      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
          NODE_1_IP,
          port++,
          port++,
          port++,
          port++,
          port++,
          "test" + File.separatorChar + "local-" + 
          NODE_1_ID + ".db",
          "/*",
          -1L,
          NODE_1_IP,
          port++,
          port++,
          -1,
          Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES,
          Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi

  }

  public void testIterator()
  throws Exception{
    SecureTreeNodeIterator iter1 = null, iter2 = null, iter3 = null, 
    iter4 = null, iter5 = null, iter6 = null;
    SecureInMemLogIterator iter10, iter11, iter12;
    TreeNode gi = null;
    //case 1: 1 log, 1 iter, write one, get one, write two, get two
    int totalNodes = 5;
    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4
    SecureRMIClient myRMIClient = new SecureRMIClient();

    //create SecureCore as URANode constructor did
    boolean filterOn = true;
    boolean cleanDb = true;  // start from empty


    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    for(int i = 0; i < totalNodes; i++){
      SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(ss);
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[i] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(i), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[i].testSkipRecoverLocalState();
      filters[i] = SecureCores[i].getSecurityFilter();
    }

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    //
    // empty log
    //
    iter1 = filters[0].makeSecureTreeNodeIterator(AcceptVV.makeVVAllNegatives());

    //needed in the late stage, but have to setup before anything is populated due to the bug
    iter6 = filters[3].makeSecureTreeNodeIterator(AcceptVV.makeVVAllNegatives());
    assert !iter1.hasNext();
    assert iter1.next() == null;

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int nodeId = 0;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);

      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));


      assert iter1.hasNext();
    }
    AcceptStamp[] as0 = new AcceptStamp[2];
    as0[0] = new AcceptStamp(10, new NodeId(0));
    as0[1] = new AcceptStamp(10, new NodeId(1));
    iter1 = filters[0].makeSecureTreeNodeIterator(new AcceptVV(as0));
    assert !iter1.hasNext():iter1.hasNext() + " : " + iter1.next();

//  for(int i = 0; i < writeNum ; i ++ ){
//  oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
//  pi1 = new PreciseInv(new ObjInvalTarget(oid, 
//  offset, 
//  len),
//  new AcceptStamp(i, new NodeId((long)nodeId)));

//  NodeTreeNodeTuple inv = iter1.next();
//  assert inv != null;
//  assert inv.getTreeNode() != null;
//  assert inv.getTreeNode().getEndTS() == i;
//  assert inv.getTreeNode().getInvalTarget().equals(pi1.getInvalTarget()); // check the object type etc
//  }
//  assert !iter1.hasNext();

    as0 = new AcceptStamp[2];
    as0[0] = new AcceptStamp(-1, new NodeId(0));
    as0[1] = new AcceptStamp(-1, new NodeId(1));

    iter3 = filters[0].makeSecureTreeNodeIterator(new AcceptVV(as0));
    for(int i = 0; i < writeNum ; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      NodeTreeNodeTuple inv = iter3.next();
      assert inv != null;
      assert inv.getTreeNode() != null;
      assert inv.getTreeNode().getEndTS() == i:"Expected ts:" + i + " found " + inv;
      assert inv.getTreeNode().getInvalTarget().equals(pi1.getInvalTarget()); // check the object type etc
    }
    assert !iter3.hasNext();



    //
    // sanityCheck
    //
    AcceptVV startVV1 = null;
    int start2 = 2;
    //
    //a normal iter start from the middle
    //
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(start2, new NodeId(0));
    as[1] = new AcceptStamp(start2, new NodeId(1));
    startVV1 = new AcceptVV(as);

    iter2 = filters[0].makeSecureTreeNodeIterator(startVV1);

    for(int i = start2+1; i < writeNum; i++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));


      assert (i==0 || iter2.hasNext());

      NodeTreeNodeTuple inv = iter2.next();
      assert new AcceptStamp(inv.getTreeNode().getEndTS(), inv.getNodeId()).equals(pi1.getAcceptStamp()):inv.toString()
      + " expected: " + pi1.toString();
      assert inv.getTreeNode().getInvalTarget().equals(pi1.getInvalTarget());
    }
    assert !iter2.hasNext();

    //
    // an iter start from the end;
    //
    int start3 = 9;
    as[0] = new AcceptStamp(start3, new NodeId(0));
    as[1] = new AcceptStamp(start3, new NodeId(1));
    startVV1 = new AcceptVV(as);
    iter3 = filters[0].makeSecureTreeNodeIterator(startVV1);

//  for(int i = start3; i >= 0 ; i -- ){
//  oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
//  pi1 = new PreciseInv(new ObjInvalTarget(oid, 
//  offset, 
//  len),
//  new AcceptStamp(i, new NodeId((long)nodeId)));


//  assert (i==0 || iter3.hasNext());

//  NodeTreeNodeTuple inv = iter3.next();
//  assert new AcceptStamp(inv.getTreeNode().getEndTS(), inv.getNodeId()).equals(pi1.getAcceptStamp()):inv.toString()
//  + " expected: " + pi1.toString();
//  assert inv.getTreeNode().getInvalTarget().equals(pi1.getInvalTarget());
//  }
    assert !iter3.hasNext();

    //
    //an iter start from the future;
    //
    int start4 = 15;
    as[0] = new AcceptStamp(start4, new NodeId(0));
    as[1] = new AcceptStamp(start4, new NodeId(1));
    startVV1 = new AcceptVV(as);
    iter4 = filters[0].makeSecureTreeNodeIterator(startVV1);
//  for(int i = writeNum-1; i >= 0 ; i-- ){
//  oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
//  pi1 = new PreciseInv(new ObjInvalTarget(oid, 
//  offset, 
//  len),
//  new AcceptStamp(i, new NodeId((long)nodeId)));


//  assert (i==0 || iter4.hasNext());

//  NodeTreeNodeTuple inv = iter4.next();
//  assert new AcceptStamp(inv.getTreeNode().getEndTS(), inv.getNodeId()).equals(pi1.getAcceptStamp()):inv.toString()
//  + " expected: " + pi1.toString();
//  assert inv.getTreeNode().getInvalTarget().equals(pi1.getInvalTarget());
//  }
    assert !iter4.hasNext();
    assert iter4.next() == null;

    // two nodes case
    // each node has some updates
    // ensure that the order of received treenodes is correct
    nodeId = 1;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);

      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

    }
    iter10 = filters[0].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    GeneralInv gInv;
    while(iter10.hasNext()){
      gInv = iter10.next();
      assert gInv!=null;
      if(dbg){
        System.out.println(" applying " + gInv + " to 2 and 1");
      }
      assert verifyAndApplyToNode(SecureCores[2], gInv, SecureCores[0].getMyNodeId());

      assert verifyAndApplyToNode(SecureCores[1], gInv, SecureCores[0].getMyNodeId());
    }


    int start5 = -1;
    as[0] = new AcceptStamp(start5, new NodeId(0));
    as[1] = new AcceptStamp(start5, new NodeId(1));
    startVV1 = new AcceptVV(as);
    iter5 = filters[1].makeSecureTreeNodeIterator(startVV1);

    for(int i = 0; i < writeNum; i++){
      for(nodeId = 0; nodeId <= 1; nodeId++){
        oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(i, new NodeId((long)nodeId)));
        assert (i==0 || iter5.hasNext());

        NodeTreeNodeTuple inv = iter5.next();
        assert new AcceptStamp(inv.getTreeNode().getEndTS(), inv.getNodeId()).equals(pi1.getAcceptStamp()):inv.toString()
        + " expected: " + pi1.toString();
        assert inv.getTreeNode().getInvalTarget().equals(pi1.getInvalTarget());
      }
    }

    assert !iter5.hasNext();
    assert iter5.next() == null;

    for(int i = 0; i < totalNodes; i++){
      SecureCores[i].close();
      
    }
  }

  private boolean verifyAndApplyToNode(SecureCore SecureCore, GeneralInv gi, NodeId src){
    SecurityFilter filter = SecureCore.getSecurityFilter();
    boolean ret = filter.verifyAndApply(gi, src);
    SecureCore.applyInval(gi, null);
    return ret;
  }

  private void syncNodes(SecureCore src, SecureCore dest){
    SecureInMemLogIterator srcIter = src.securityFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    SecureInMemLogIterator destIter = dest.securityFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert dest.securityFilter.verifyAndApply((GeneralInv)srcIter.next(), src.getMyNodeId());
    }
    //reset source
    srcIter = src.securityFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert destIter.hasNext();
      assert destIter.next().equals(srcIter.next());
    }
  }
  private void applyToFilter(SecureCore destfilter, 
      SecureCore srcFilter,
      ImpreciseInv ii){
    ImpreciseInv sii = srcFilter.securityFilter.createImpreciseInv(ii);
    assert destfilter.securityFilter.verifyAndApply(sii, srcFilter.getMyNodeId());
  }
  private void verifyIter(SecureTreeNodeIterator iter, 
      long stamp,
      long nodeId){
    //assert iter.hasNext();
    NodeTreeNodeTuple gi = iter.next();
    assert gi.getTreeNode() != null;
    assert gi.getTreeNode().getEndTS() == stamp:
      gi.getTreeNode().toString() + "expected:" + stamp +"@"+nodeId;
    assert gi.getNodeId().equals(new NodeId(nodeId)):
      gi.getTreeNode().toString() + "expected:" + stamp +"@"+nodeId;
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SecureTreeNodeIteratorUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecureTreeNodeIteratorUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

