package code.security.application.BasicObjShare;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.Controller;
import code.Env;
import code.GeneralInv;
import code.LocalInterface;
import code.NodeId;
import code.PreciseSet;
import code.RMIApplicationException;
import code.RMIClient;
import code.RMINetworkException;
import code.StreamId;
import code.SubscriptionSet;
import code.SummaryHash;
import code.URANode;
import code.VV;
import code.security.SangminConfig;
import code.security.SecureController;
import code.security.SecureCore;
import code.security.SecureIncomingInvalConnection;
import code.security.SecureRMIClient;
import code.security.SecureURANode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;
import code.BodyMsg;
import code.ObjId;

public class SimpleApp{
  private static long forkCheckPeriod = 10000;
  SecureURANode uraNode;
  NodeId myId;
  SecureRMIClient rmiClient;
  MyController myController;
  String configfile;
  NodeId trustedServer;
  ForkChecker forkChecker;
  
  private boolean recreate;
  
  synchronized boolean isTimeTorecreate(){
    return recreate;
  }
  synchronized void setRecreate(){
    recreate = true;
  }

  private class MyController implements SecureController {

    public void informBecameImprecise(PreciseSet is){
      // TODO Auto-generated method stub

    }

    public void informBecamePrecise(PreciseSet is){
      // TODO Auto-generated method stub

    }

    public void informBodyStreamInitiated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informBodyStreamTerminated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informCheckpointApplied(NodeId senderId, boolean status){
      try{
        if(!status && myId == trustedServer){
          rmiClient.clearState(senderId);
        }
      }catch(RemoteException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }catch(RMINetworkException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }catch(RMIApplicationException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }

    public void informCheckpointStreamInitiated(NodeId senderNodeId,
        String cpPath, String[] exclChildNames, VV vvStart,
        boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informCheckpointStreamReceiveStatus(NodeId senderNodeId,
        String cpPath, String[] exclChildNames, VV vvStart,
        boolean applyStatus, boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informCheckpointStreamTerminated(NodeId senderNodeId,
        String cpPath, String[] exclChildNames, VV vvStart,
        boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informCommitStreamInitiated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informCommitStreamTerminated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informDemandImprecise(ObjId objId, PreciseSet enclosingIS,
        VV lpVV){
      // TODO Auto-generated method stub

    }

    public void informDemandReadHit(ObjId objId, long offset, long length){
      // TODO Auto-generated method stub

    }

    public void informDemandReadMiss(ObjId objId, long offset, long length){
      // TODO Auto-generated method stub

    }

    public void informGapExistForSubscribeInv(NodeId invReceiver,
        SubscriptionSet ss, VV startVV, VV omitVV){
      // TODO Auto-generated method stub

    }

    public void informInvalStreamInitiated(NodeId senderNodeId,
        SubscriptionSet ss, VV vvStart, boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informInvalStreamTerminated(NodeId senderNodeId,
        SubscriptionSet is, VV vvStart, boolean placeholderWriterSet,
        StreamId id){
      // TODO Auto-generated method stub

    }

    public void informLocalDelete(ObjId objId){
      // TODO Auto-generated method stub

    }

    public void informLocalReadImprecise(ObjId objId, long offset, long length){
      // TODO Auto-generated method stub

    }

    public void informLocalReadInvalid(ObjId objId, long offset, long length,
        AcceptStamp inval){
      // TODO Auto-generated method stub

    }

    public void informLocalWrite(ObjId objId, long offset, long length,
        AcceptStamp as, boolean isBound, boolean isEmbargoed){
      // TODO Auto-generated method stub

    }

    public void informOutgoingBodyStreamInitiated(NodeId receiverNodeId,
        boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingBodyStreamTerminated(NodeId receiverNodeId,
        SubscriptionSet subscriptionSet, boolean placeholderWriteSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingCheckpointStreamInitiated(NodeId targetNodeId,
        String cpPath, String[] exclChildNames, VV startVV,
        boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
        String cpPath, String[] exclChildNames, VV startVV,
        boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingInvalStreamInitiated(NodeId targetNodeId,
        VV startVV, boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingInvalStreamTerminated(NodeId receiverNodeId,
        SubscriptionSet is, VV startVV, boolean placeholderWriterSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingSubscribeBodyInitiated(NodeId receiverID,
        SubscriptionSet subscriptionSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingSubscribeBodyTerminated(NodeId receiverId,
        SubscriptionSet subscriptionSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingSubscribeInvalInitiated(NodeId receiverId,
        SubscriptionSet subscriptionSet){
      // TODO Auto-generated method stub

    }

    public void informOutgoingSubscribeInvalTerminated(NodeId receiverId,
        SubscriptionSet subscriptionSet){
      // TODO Auto-generated method stub

    }

    public void informReceiveDemandReply(NodeId senderNodeId, BodyMsg msg){
      // TODO Auto-generated method stub

    }

    public void informReceiveInval(GeneralInv inv, NodeId senderId){
      // TODO Auto-generated method stub

    }

    public void informReceivePushBody(BodyMsg msg){
      // TODO Auto-generated method stub

    }

    public void informSubscribeBodyRemoved(NodeId senderNodeId,
        SubscriptionSet ss){
      // TODO Auto-generated method stub

    }

    public void informSubscribeBodySucceeded(NodeId senderNodeId,
        SubscriptionSet ss){
      // TODO Auto-generated method stub

    }

    public void informSubscribeInvalFailed(NodeId senderNodeId,
        NodeId receiverNodeId, SubscriptionSet ss, VV vvStart){

    }

    public void informSubscribeInvalSucceeded(NodeId senderNodeId,
        NodeId receiverNodeId, SubscriptionSet ss, VV vvStart){
      // TODO Auto-generated method stub
    }

    public void informSyncRplyStreamInitiated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informSyncRplyStreamTerminated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informUnbindStreamInitiated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void informUnbindStreamTerminated(NodeId senderNodeId){
      // TODO Auto-generated method stub

    }

    public void recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
      // TODO Auto-generated method stub

    }

    public void informRecoverState(){
      System.out.println("We are in a different branch from the serve.."
          +"\nClearing my state and connecting to the server");
      setRecreate();      
    }

  }

  private class ForkChecker extends Thread {

    boolean run;
    
    public ForkChecker(){run=true;}
    public void run(){
      while(run){
        
        try{
          sleep(forkCheckPeriod);
        }catch(InterruptedException e1){
          e1.printStackTrace();
        }
        
        try{
          VV cvv = uraNode.getCurrentVV();
          SummaryHash h = ((SecureCore)uraNode.getCore()).getSecurityFilter().getSummaryHash(cvv);
          
          if(!rmiClient.testState(trustedServer, myId, cvv, h)){
            // Current state is not consistent with the server
            System.out.println("We are in a different branch from the serve.."
                +"\nClearing my state and connecting to the server");
            setRecreate(); 
          }
        }catch(Exception e){          
          e.printStackTrace();
        }
      }
    }
    public void shutdown(){
      run = false;
    }
    
  }
  
  public SimpleApp (){

  }
  
  synchronized void recreateNode(){
    recreate = false;
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    uraNode = new SecureURANode(configfile, myId, myController, true, true
        ,new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    rmiClient = (SecureRMIClient) uraNode.getRMIClientInterface();
    
    try{
      connectTo(trustedServer);
    }catch (Exception e){
      System.err.print(e.getLocalizedMessage());
      System.exit(-1);
    }
    
    forkChecker = new ForkChecker();
    forkChecker.start();    
  }

  private LocalInterface getLocalInterface(){
    return uraNode.getLocalInterface();
  }

  private void connectTo(NodeId dst) throws RMINetworkException, RMIApplicationException{

    rmiClient.subscribeInval(dst, myId, SubscriptionSet.makeSubscriptionSet("/*"),
        AcceptVV.makeVVAllNegatives(), true);
  }



  public void init(int id, int serverId, String configFile){ 
    myId = new NodeId(id);
    trustedServer = new NodeId(serverId);
    configfile = configFile;
    myController = new MyController();
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    uraNode = new SecureURANode(configfile, myId, myController, true, true
        ,new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    rmiClient = (SecureRMIClient) uraNode.getRMIClientInterface();
    if(id!=serverId){
      forkChecker = new ForkChecker();
      forkChecker.start();
    }
  }

  public void shutdown(){
    uraNode.shutdown();
    forkChecker.run = false;    
  }

  public static void main(String[] args){
    //SecureIncomingInvalConnection.dbg = true;
    SangminConfig.attachBodyToCheckpoint = true;
    SimpleApp node = new SimpleApp();
    try{
      String configPath = null;
      if(args.length < 3){
        configPath = "./simpleApp" + args[0] + ".config";
        makeDummyConfig(configPath);
      }else{
        configPath = args[2];
      }
      node.init(Integer.parseInt(args[0]), Integer.parseInt(args[1]), configPath);      
    }catch(Exception e){
      e.printStackTrace();
      System.err.println(e);
      System.err.println("java SimpleApp <node id> <server id> [<config file>]");
      System.exit(-1);
    }
    node.userInterface(System.in, node.getLocalInterface());
    node.shutdown();
  }
  
  public static int NUM_DUMMY_NODES = 5;
  
  public static void  makeDummyConfig(String path){


    Config.createEmptyConfig();


    int ii;
    for(ii = 0; ii < NUM_DUMMY_NODES; ii++){
      NodeId id = new NodeId(ii);
      Config.addOneNodeConfig(id, "localhost", 
                                (ii*100)+9478, (ii*100)+9479, (ii*100)+9480,
                                (ii*100)+9481, (ii*100)+9482,
                              "simpleApp" + File.separatorChar + "tmp.db",
                              "/*",
                              -1L,
                              "localhost",
                              (ii*100)+2483,
                              (ii*100)+2484,
                              -1, 
                              Config.CACHE_SIZE_BYTES_DEFAULT,
                              Config.MAX_LOG_DISK_SIZE_BYTES,
                              Config.MAX_LOG_MEM_SIZE_BYTES);

    }

    Config.writeToFile(path);
    File configFile = new File(path);
    try{
      configFile.deleteOnExit();
      
    } catch (SecurityException se){
      assert false; //should never be here.
    }

  }

  private void printCommand(){
    System.out.println("Enter action:  ");
    System.out.println("Connect        : c [node ID]");
    System.out.println("Write          : w [ObjId] [String]");
    System.out.println("Read           : r [ObjId] [String]");
    System.out.println("End            : e");
  }

  public void userInterface(InputStream is, LocalInterface li){

    boolean dbg = true;
    long writeNum = 0;

    BufferedReader din = null;

    din = new BufferedReader(new InputStreamReader(is));


    String input = null;
    boolean run = true;
    while(run){
      
      if(isTimeTorecreate()){
        recreateNode();
      }
      
      printCommand();
      System.out.print("Enter command: ");
      try{
        input = din.readLine();
      }catch(IOException e1){
        System.err.println(e1.getLocalizedMessage());
        continue;
      }
      
      if(input.length() <= 0 || input.trim() == ""){        
        continue;
      }
      byte[] action = input.getBytes();

      if(action[0] == 'w'){
        writeNum++;
        StringTokenizer st = new StringTokenizer(input.substring(2));
        ObjId objId = new ObjId(st.nextToken());
        String str = "";
        while(st.hasMoreElements()){
          str = str+st.nextToken();
          str += " ";
        }
        str.trim();


        try{
          Env.dprintln(dbg, "Writing obj:" + objId);
          li.write(objId, 0, str.length(), str.getBytes(), false);
        }catch(Exception e){
          e.printStackTrace();
          continue;
        }

      } else if (action[0] == 'r'){
        StringTokenizer st = new StringTokenizer(input.substring(2));
        ObjId objId = new ObjId(st.nextToken());
        String str = "";

        try{
          Env.dprintln(dbg, "Reading obj:" + objId);
          BodyMsg bm = li.read(objId, 0, 10000, false, false);
          str = bm.getBody().toString();
          System.out.println(str);
        }catch(Exception e){
          //
          // ObjNotFoundException or EOFException
          //
          System.err.println(e.getLocalizedMessage());
          e.printStackTrace();
          continue;
        }

      } else if (action[0] == 'e'){
        run = false;
        System.exit(-1);
        continue;
      } else if (action[0] == 'c'){
        StringTokenizer st = new StringTokenizer(input.substring(2));
        int node = Integer.parseInt(st.nextToken());
        try{
          NodeId target = new NodeId(node);

          connectTo(target);

        }catch(Exception e){
          e.printStackTrace();
          System.err.println(e);
          continue;
        }
      }

    }
  }

}
