package code.security.application.MapShare;

/**
 * this class represents the granularity of objects in our file system 
 * @author princem
 *
 */
public class MapBlock{
  /**
   * identifies the area name of the map
   */
  String mapName;
  
  /**
   * the x and y coordinate of the block
   */
  int x, y;
  
  public MapBlock(String mapName, int x, int y){
    this.mapName = mapName;
    this.x = x;
    this.y = y;
  }
  
  public int hashCode(){
    return (mapName+x+y).hashCode() + x + y;
  }
  
  public String toString(){
    return "MapBlock: " + mapName + " ("+x+","+y+")";
  }
  
  public String toPath(){
    return mapName + "/"+x+"/"+y;
  }
  public boolean equals(Object o){
    if(o instanceof MapBlock){
      MapBlock mapBlock = (MapBlock)o;
      return mapName.equals(mapBlock.mapName) && x == mapBlock.x && y == mapBlock.y;
    }else{
      return false;
    }
  }
}
