package code.security.application.MapShare;
/* MapConfig.java
 *
 * Read config file and provide interface for accessing it.
 * 
 * Config file has
 *
 *    MODE     READER_FROM_PICSHARE|WRITER_TO_PICSHARE    // Reader Node ID > LOWEST_READER_NODE_ID
 *    ALBUM_NAME  name
 *    PASSWORD    password
 *    INPUT_PATH  path-to-input files // for WRITER only
 *    OUTPUT_PATH path to output files // for READER only
 *
 * Defines layout of where data stored in PRACTI id space
 * H(data_key)/ 
 *             update_list/node[nodeId] -- history of updates
 *             receive_list[reader]/node[writer] -- which updates from 
 *                                                  [writer] has [reader] 
 *                                                  processed?
 *             data/* -- replicated files
 *             metadata/* -- per-object metadata
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */


import code.*;
import java.io.*;
import java.security.MessageDigest;
import java.util.List;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.Enumeration;

 /** 
 *  Config:: parse config file and store it in the in-mem data structure
 
 *           
 
 *           to add a new field:
 
 *              0. Update MAX_CONFIG_FIELDS
 
 *              1. add a member to store the value
 
 *              2. add an element for longopts in readConfig()
 
 *                 longopts[14] =  new LongOpt("COMM_PORT", LongOpt.REQUIRED_ARGUMENT, null, 14);
 
 *              3. add a case like this:
 
 *                  case 14:
 
 * 	           commPort = (new Integer(g.getOptarg())).intValue();
 
 * 	           break ;
 
 *              4. Update sanityCheckConfig to make sure required fields present
 
 **/ 

public class MapConfig{

  SubscriptionSet readerTargets;
  
  LinkedList<AccessControlPolicyTuple> baseAccessControl;
  LinkedList<NodeId> friends;
  
  public MapConfig(String path){
    readerTargets = SubscriptionSet.makeSubscriptionSet("/*");
  }

}
