package code.security.application.MapShare;

import java.util.LinkedList;

import code.security.*;
import code.signedVV.RURANode;
import code.*;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;
import code.security.liveness.*;

public class MapManager{
  private final static String defaultMapConfigPath = "MapConfig";
  private final static String defaultConfigPath = "PRACTIConfig";
  //private final static boolean useSecure = (SangminConfig.securityLevel == SangminConfig.COMPLETE);;
  private boolean catchupWithCP = true;
  
  private String userName;
  private URANode uraNode;
  
  private MapWriter mapWriter;
  private MapRenderer mapRenderer;
  private MapConfig mapConfig;
  private AccessControl accessControl;
  private MapController mapController;
  private LocalInterface localInterface;
  private RMIClient rmiClient;
  public static SubscriptionSet ss;
  
  private NodeId myNodeId;
  public static NodeId trustedNode = null;
  public final static int LIVENESS_NORMAL_FILTER = 0;
  public final static int LIVENESS_TRACE_FILTER = 1;
  public final static int LIVENESS_TRUSTED_BLOCKING_FILTER = 2;
  public static int livenessFilterType = LIVENESS_TRUSTED_BLOCKING_FILTER;
  
  public boolean cpfailure = false; // this should be synchronized..for now..just leave it... 
  
  public MapManager(String userName, int nodeId, String mapConfigFilePath, String practiConfig, MapController controller){
    mapConfig = new MapConfig(mapConfigFilePath);
    mapController = controller;
    accessControl = new MapAccessControl(mapConfig);
    myNodeId = new NodeId(nodeId);
    if(SangminConfig.securityLevel >= SangminConfig.SIGNATURE){
	CertificateAuthority ca;
	if(myNodeId.equals(trustedNode)){
	    ca = new TrustedServerCertificateAuthority();
	}else{
	    ca = new NoopCertificateAuthority();
	}
	LivenessFilter filter;
	if(livenessFilterType == LIVENESS_TRACE_FILTER){
	  System.out.println("Using LIVENESS_TRACE_FILTER");
	  filter = new code.security.liveness.TrustedServerBlockingLivenessFilter(trustedNode);
	  //	  filter = new code.security.liveness.TrustedServerLivenessFilter(trustedNode, ca);
	}else if(livenessFilterType == LIVENESS_NORMAL_FILTER){
	  System.out.println("Using LIVENESS_NORMAL_FILTER");
	  filter = new code.security.liveness.TrustedServerLivenessFilter(trustedNode, ca);
	  filter = new code.security.liveness.TrustedServerLivenessFilter(trustedNode, ca);
	}else{
	  System.out.println("Using LIVENESS_TRUSTED_BLOCKING_FILTER");
          filter = new code.security.liveness.TrustedServerBlockingLivenessFilter(trustedNode);
	}
	 SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
	      LinkedList<Filter> f = new LinkedList<Filter>();
	      f.add(ssf);
	        
      uraNode = new SecureURANode(practiConfig, myNodeId, 
          mapController,
          true,//cleanDB 
          true,
          filter, 
          f);
          //new code.security.liveness.TrustedServerLivenessFilter(trustedNode, ca));//noSyncLog          
          //new code.security.liveness.TrustedServerTraceLivenessFilter(trustedNode));//noSyncLog
    }else if(SangminConfig.securityLevel == SangminConfig.SIGNEDVV){
      uraNode = new RURANode(practiConfig, myNodeId, 
          mapController,
          true,//cleanDB 
          true);//noSyncLog
    }else{
      uraNode = new URANode(practiConfig, myNodeId, 
          mapController,
          true,//cleanDB 
          true);//noSyncLog
    }
    
    
    localInterface = uraNode.getLocalInterface();
    rmiClient = uraNode.getRMIClientInterface();
    mapRenderer = new MapRenderer(mapConfig, uraNode);
    mapWriter = new MapWriter(this);
    mapController.setAccessControl(accessControl);
    mapController.setMapManager(this);
    ss = mapConfig.readerTargets;
  }
  
  public MapManager(String userName, int nodeId, String mapConfigFilePath, String practiConfig){
    mapConfig = new MapConfig(mapConfigFilePath);
    accessControl = new MapAccessControl(mapConfig);
    mapController = new MapController(accessControl, this);
    myNodeId = new NodeId(nodeId);
    if(SangminConfig.securityLevel >= SangminConfig.SIGNATURE){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
        
      uraNode = new SecureURANode(practiConfig, myNodeId, 
          mapController,
          true,//cleanDB 
          true, 
          new code.security.liveness.TrustedServerTraceLivenessFilter(trustedNode), f);//noSyncLog
    }else if(SangminConfig.securityLevel == SangminConfig.SIGNEDVV){
      uraNode = new RURANode(practiConfig, myNodeId, 
          mapController,
          true,//cleanDB 
          true);//noSyncLog
    }else{
      uraNode = new URANode(practiConfig, myNodeId, 
          mapController,
          true,//cleanDB 
          true);//noSyncLog
    }
    
    
    localInterface = uraNode.getLocalInterface();
    rmiClient = uraNode.getRMIClientInterface();
    mapRenderer = new MapRenderer(mapConfig, uraNode);
    mapWriter = new MapWriter(this);
    mapController.setAccessControl(accessControl);
    mapController.setMapManager(this);
    ss = mapConfig.readerTargets;
  }
  
  
  
  public MapManager(String userName, int nodeId){
    this(userName, nodeId, defaultMapConfigPath, defaultConfigPath);
  }
  
  public MapManager(String userName, int nodeId, MapController c){
    this(userName, nodeId, defaultMapConfigPath, defaultConfigPath, c);
  }
  
//new connection found to node nId
  public AcceptVV addConnection(NodeId nId/*, boolean includeAll*/){
    //sync information
    //open a connection to this nodeId
    try{
      //assert uraNode.getCore().getCurrentVV().equalsIgnoreNegatives(uraNode.getCore().getLpVV(ss)): "cvv" + uraNode.getCore().getCurrentVV() + " lpvv" + uraNode.getCore().getLpVV(ss);
      //return rmiClient.subscribeInval(nId, myNodeId, ss, uraNode.getCore().getLpVV(ss), catchupWithCP/*, includeAll*/);
      return rmiClient.subscribeInval(nId, myNodeId, ss, uraNode.getCore().getCurrentVV(), catchupWithCP/*, includeAll*/);
      
    }catch(RMINetworkException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(RMIApplicationException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    return null;
  }
  
  // connection to nId terminated
  public void removeConnection(NodeId nId){
	  System.out.println("Requested to close connection to " + nId);
    //connection closed
    try{
      rmiClient.removeConnection(nId, myNodeId);
    }catch(RMINetworkException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(RMIApplicationException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
	  System.out.println("Requested to close connection to " + nId + " rmi request sent");

  }

//  public static final boolean isUseSecure(){
//    return useSecure;
//  }

  public final boolean isCatchupWithCP(){
    return catchupWithCP;
  }

  public final String getUserName(){
    return userName;
  }

  public final URANode getUraNode(){
    return uraNode;
  }

  public final MapWriter getMapWriter(){
    return mapWriter;
  }

  public final MapRenderer getMapRenderer(){
    return mapRenderer;
  }

  public final MapConfig getMapConfig(){
    return mapConfig;
  }

  public final AccessControl getAccessControl(){
    return accessControl;
  }

  public final MapController getMapController(){
    return mapController;
  }

  public final LocalInterface getLocalInterface(){
    return localInterface;
  }

  public final RMIClient getRmiClient(){
    return rmiClient;
  }

  public final SubscriptionSet getSs(){
    return ss;
  }

  public final NodeId getMyNodeId(){
    return myNodeId;
  }

  public void setSs(SubscriptionSet ss){
    this.ss = ss;
    LinkedList<Filter> filters = new LinkedList<Filter>();
    filters.add(new SubscriptionSetFilter(ss));
    if(SangminConfig.securityLevel >= SangminConfig.SIGNATURE){
      ((SecureURANode)uraNode).setFilter(filters);
    }
  }
  public void cpApplicationFailed(){
    cpfailure = true;
  }
}
