package code.security.application.MapShare;

import java.io.IOException;

import code.LocalInterface;
import code.ObjId;

public class MapWriter{
  
  MapManager mapManager;
  LocalInterface localInterface;
  
  public MapWriter(MapManager mapManager){
    this.mapManager = mapManager;
    this.localInterface = mapManager.getLocalInterface();
  }
  
  public void doWrite(boolean fire, MapBlock blockAddr, String basePath){
    byte[] write = new byte[1];
    write[0]=(fire?(byte)1:(byte)0);
    ObjId oid = new ObjId(basePath + "/" + blockAddr.toPath());
    try{
     long got = localInterface.write(oid, 0, write.length, write, false);
     assert(got == write.length);
    }
    catch(IOException e){
      System.out.println("IO Exception in PreciseInvalStreamTest.write("
                         + oid.toString()
                         + ") -- "
                         + e.toString());
      assert false;
    }
    
  }

}
