package code.security.application.MapShare.trace;

import java.io.*;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Scanner;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.NoSuchEntryException;
import code.NodeId;
import code.ObjId;
import code.PreciseInv;
import code.SubscriptionSet;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.simulator.*;
import code.simulator.store.Store;
import code.simulator.store.StoreInterface;
import code.CounterVV;

import java.net.*;
import java.util.TreeSet;
import java.util.Set;


public class TraceExecutor extends Thread{

  private Hashtable<Integer, Socket> listenerMap;
  private Hashtable<Integer, ObjectInputStream> inputStreamMap;
  private Hashtable<Integer, ObjectOutputStream> outputStreamMap;
  private Hashtable<Integer, AcceptVV> acceptVVMap;
  private int totalCount;
  private int port;
  private ServerSocket ss;
  private BufferedReader br;
  private int numCommands = 0;
  private int commandCounter = 0;
  public static boolean partialInterestSet = false;
  public static boolean useTrustedNode = false;
  public static boolean useLivenessFilter = true;
  public static boolean initializeState = false;
  private int trustedNode = -1;
  private Hashtable<Integer, Integer> syncCount  = new Hashtable<Integer, Integer>();
  private Hashtable<Integer, Integer> updateCount = new Hashtable<Integer, Integer>();

  private Hashtable<Integer, Node> nodeMap = new Hashtable<Integer, Node>();
  public final static int defaultPort = 5001;
  public final static boolean execute = code.security.SangminConfig.executeTrace;
  public final static boolean analyze = code.security.SangminConfig.analyzeTrace;

  public final static int STARTNODE = 0; // STARTNODE TIME NODEID
  public final static int KILLNODE = 1; // KILLNODE TIME NODEID
  public final static int SETINTERESTSET = 2; // SETINTERESTSET TIME NODEID <INTEREST SET>
  public final static int TERMINATECONNECTION = 3; // TERMINATECONNECTION TIME NODEID DESTNODEID
  public final static int STARTCONNECTION = 4; // STARTCONNECTION TIME NODEID DESTNODEID
  public final static int UPDATE = 5; // UPDATE TIME NODEID OBJECT VALUE
  public final static int MOVEIN = 6; // UPDATE TIME NODEID OBJECT VALUE
  public final static int MOVEOUT = 7; // UPDATE TIME NODEID OBJECT VALUE
  public final static int SLEEP = 8; // SLEEP TIME SLEEP_TIME
  public final static int SETTRUSTEDNODE = 9; // SET TRUSTED SERVER ID
  public final static int SETLIVENESSFILTER = 10; // WHICH FILTER WE USE
  public final static int FORK = 11;
  public final static int GARBAGECOLLECT = 12;
  public final static int OPTIONALSYNC = 13;
  public final static int READ = 14;
  public final static int DROP = 15;
  
  static int omission_faulty_node = -1;
  
  private AcceptVV vvOnLastGC;
  AcceptVV lastRequestedOmitVV;
  HashSet<PreciseInv> acceptedFaultyWrites;
  HashSet<Integer> faultyNodeIDSet;
  
  HashMap<Integer, Integer> parentOfForkedNodes;
  
  private final static int numUpdatesPrePopulated = 0;
  //private final static int numUpdatesPrePopulated = 80000;
  
  public String subscriptionSet;
  public Hashtable<Integer, String> subscriptionSetMap;

  public TraceExecutor(int count, int port, String file){
    try{
      FileReader f1 = new FileReader(file);
      BufferedReader br1 = new BufferedReader(f1);
      subscriptionSetMap = new Hashtable<Integer, String>();
      subscriptionSet = getSubscriptionSet(br1);
      try{
        br1.close();
        f1.close();
      }catch(IOException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
      FileReader f = new FileReader(file);
      br = new BufferedReader(f);


    }catch(FileNotFoundException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      System.out.println("File not found:"+ file);
      System.exit(0);
    }
    this.totalCount = count;
    this.makePractiConfig(0, totalCount);
    this.port = port;
    compressFactor = totalCount;
    //if(useTrustedNode)
    //  compressFactor--;
    initAnalysis();
    System.out.println("setting compress factor to " + compressFactor);
    listenerMap = new Hashtable<Integer, Socket>();
    inputStreamMap = new Hashtable<Integer, ObjectInputStream>();
    outputStreamMap = new Hashtable<Integer, ObjectOutputStream>();
    acceptVVMap = new Hashtable<Integer, AcceptVV>();
    if(!SangminConfig.useSimulator){
      try{
        ss = new ServerSocket(port);
      } catch (Exception e){
        e.printStackTrace();
        assert false;
      }
      parentOfForkedNodes = new HashMap<Integer,Integer>();
    }     
    start();
  }

  public TraceExecutor(int count, String file){
    this(count, defaultPort, file);
  }

  public void initAnalysis(){
    if(!analyze){
      return;
    }
    for(int i = 0; i < totalCount; i++){
      syncCount.put(i, 0);
      updateCount.put(i, 0);
    }
  }

  public void finishAnalysis(){
    if(!analyze){
      return;
    }
    System.out.println("TraceAnalysis for traceFile ");
    for(int i = 0; i < totalCount; i++){
      if(syncCount.containsKey(i) && syncCount.get(i) > 0){
        System.out.println("Node " + i + " synced " + syncCount.get(i) + " times");
      }
      if(updateCount.containsKey(i) && updateCount.get(i) > 0){
        System.out.println("Node " + i + " updated " + updateCount.get(i) + " times");
      }
//      if(nodeMap.get(i).getCurrentVV().size()>0){
//    	  System.out.println("Node " + i + " CVV : " + nodeMap.get(i).getCurrentVV());
//    	  System.out.println(nodeMap.get(i).getStore());
//      }
    }

    int inconsistency = 0;
    int maxInconsistency = 0;
    int nCorrectnodes = 0;
    for(int i=0; i < totalCount; i++){
      Node n = nodeMap.get(i);
      if( n.isOmissionFaulty() || !n.canWrite() || faultyNodeIDSet.contains(i)
          || n.getBranchID().getIDint() > syncCount.size() || n.getStore().size() <= 0){
        continue;
      }

      int t = OracleNotifier.calculateInconsistecy(n.getStore());
      //System.out.println("node " + n.getBranchID().getIDint() + ":" + t);
      if(t>maxInconsistency){
        maxInconsistency = t;
      }
      inconsistency += t;
      nCorrectnodes++;
    }
    System.out.println(commandCounter + " Avr Inconsistency  : " + inconsistency/nCorrectnodes + 
        " from " + nCorrectnodes + " correct nodes, Max Inconsistency : " + maxInconsistency);


//    System.out.println("Oracle store\n" + OracleNotifier.getStoreString());
  }

  public  void run(){
    waitForInitialization();
    if(useTrustedNode){
      setTrustedNode();
      System.out.println("Node " + trustedNode + " set as trusted Node");
    }
    if(this.initializeState){
      this.init();
      System.out.println("Initialization over");
      this.setSS();
      System.out.println("Subscription set" + ss);
    }
    if(SangminConfig.useSimulator){
      processSimulatorCommandFile();
    }else{
      processCommandFile();
    }
    System.out.println("command file processed");
    this.cleanup();
    finishAnalysis();
    System.out.println("Done running experiment");

  }

  public void waitForInitialization(){
    int count = 0;
    if(!execute){
      return;
    }

    if(SangminConfig.useSimulator){
      code.simulator.checkpoint.unit.SimulatorCheckpointUnit.makePractiConfig(0, totalCount);
      for(int i = 0; i < totalCount; i++){
        BranchID bid = NodeFactory.createNodeId(i);
        Node n = NodeFactory.createIrisNode(bid);//new Node(bid);
        
        if(i == omission_faulty_node){
          System.out.println("Setting node " + i + "to commit omission");
          n.setOmissionFault();
        }
        
        nodeMap.put(i, n);
        vvOnLastGC = new AcceptVV();
        lastRequestedOmitVV = new AcceptVV();
        acceptedFaultyWrites = new HashSet<PreciseInv>();
        faultyNodeIDSet = new HashSet<Integer>();
      }
    }else{
      try{

        while(count < totalCount){
          try{
            System.out.println("Waiting...received " + count + " connections so far");
            Socket incoming = ss.accept();
            ObjectInputStream ois = new ObjectInputStream(incoming.getInputStream());
            Integer key = ois.readInt();
            assert key != null;
            listenerMap.put(key, incoming);
            inputStreamMap.put(key, ois);
            ObjectOutputStream oos = new ObjectOutputStream(incoming.getOutputStream());
            outputStreamMap.put(key, oos);
            AcceptVV initAcceptVV = (AcceptVV)ois.readObject();
            acceptVVMap.put(key, initAcceptVV);
            System.out.println("Initialization received from node " + key);
            oos.writeInt(TraceExecutor.compressFactor);
            System.out.println("Compression factor " + compressFactor + " sent to node " + key);
            count++;

          } catch (Exception e){
            e.printStackTrace();
            System.out.println("Exception occured so aborting" + e);
            assert false;
            break;
          }
        }
      }
      finally{
        try{
          ss.close();
        }
        catch(IOException z){
          System.out.println("IOException occured so aborting" + z);
          assert false;
        }
      }
    }
  }

  public void init(){
    if(SangminConfig.useSimulator){
      return;
    }
    String startCmd = STARTNODE + " ";
    for(Integer nId: outputStreamMap.keySet()){
      sendCommand(nId, startCmd + nId);
      waitForACK(nId);
    }
  }

  public void setTrustedNode(){
    if(SangminConfig.useSimulator){
      return;
    }
    trustedNode = totalCount-1;

    // first set interest set to ALL
    //    String setSSCmd = SETINTERESTSET + " ";
    //String nodeSS = (partialInterestSet?subscriptionSet:"/*");
    //sendCommand(trustedNode, setSSCmd + trustedNode + " " + nodeSS);
    //waitForACK(trustedNode);

    // now tell everyone that there is a trusted node
    String startCmd = SETTRUSTEDNODE + " ";
    for(Integer nId: outputStreamMap.keySet()){
      sendCommand(nId, startCmd + nId + " " + trustedNode);
      waitForACK(nId);
    }
  }

  public void setSS(){
    if(SangminConfig.useSimulator){
      return;
    }
    String setSSCmd = SETINTERESTSET + " ";
    String nodeSS = (partialInterestSet?subscriptionSet:"/*");
    String ssSuffix = (useLivenessFilter?":/cert/*":"");
    ssSuffix = "";
    //    String nodeSS = "/*"; //this.subscriptionSet;
    for(Integer nId: outputStreamMap.keySet()){
      if(this.partialInterestSet){
        nodeSS = this.subscriptionSetMap.get(nId) + ssSuffix;
        if(nodeSS == null){
          nodeSS = this.subscriptionSet+ssSuffix;
        }
      }
      //System.out.println("Sending command to set interest set " +setSSCmd + nId + " " + nodeSS);
      sendCommand(nId, setSSCmd + nId + " " + nodeSS+ssSuffix);
      waitForACK(nId);
    }

    if(useTrustedNode){
      // first set interest set to ALL
      nodeSS = "/*"; //this.subscriptionSet;
      sendCommand(trustedNode, setSSCmd + trustedNode + " " + nodeSS);
      waitForACK(trustedNode);
    }
  }

  public void cleanup(){
    if(SangminConfig.useSimulator){
      return;
    }
    String command = KILLNODE + " ";
    for(Integer nId: outputStreamMap.keySet()){
      System.out.println("Killing " + nId);
      sendCommand(nId, command + nId);
      waitForACK(nId);
    }
    try{
      this.ss.close();
    }catch(IOException e){
      e.printStackTrace();
    }
    System.out.println("Cleanup complete");
  }
  
//  private boolean triggerGC(){
//    if(GCPeriod<=0){
//      return false;
//    }
//         
//    if(vvOnLastGC.size() <= 0 )
//      return true;
//    
//    int numGCed = 0;
//    
//
//      Node n = nodeMap.get(1);
//      long nodeid = n.getBranchID().getIDint();
//
//      if(n.getCurrentVV().includes(vvOnLastGC)){
//        System.out.println("Node " + nodeid + " GCed at " + vvOnLastGC);
//        n.garbageCollect(n.getNextLargestVV(vvOnLastGC));
//        numGCed++;
//      }
//
//    if(numGCed > 0){
//      return true;
//    } else {
//      return false;
//    }
//
//  }

  
  private AcceptVV triggerGC(int nodeId){
    Node n = nodeMap.get(nodeId);
    
    if(omitVV.size() <= 0){
      omitVV = ((IrisNode)n).getCurrentHashedVV();
      return omitVV;
    } else {
      System.out.println("Node " + nodeId + " triggers GC at " + omitVV);
      n.garbageCollect(omitVV); //n.getNextLargestVV(omitVV));
      omitVV = new AcceptVV();
      return n.getCurrentVV();
      
    }
    
//    
//
//    if(vvOnLastGC.size() <= 0 )
//      return n.getCurrentVV();
//
//    //System.out.println("Node " + nodeId + " GCed at " + vvOnLastGC);
//    //System.out.println("Node " + nodeId + " GCed at " + n.getCurrentVV());
//    //n.garbageCollect(n.getNextLargestVV(vvOnLastGC));
//    //n.garbageCollect(n.getCurrentVV());
//    //return n.getCurrentVV();//isGCed = true;
//    if(n.getOmitVV().includes(lastRequestedOmitVV)){
//      System.out.println("Node " + nodeId + " triggers GC at " + vvOnLastGC);
//      n.garbageCollect(n.getNextLargestVV(vvOnLastGC));
//      lastRequestedOmitVV = vvOnLastGC;      
//    }
//    
//    return n.getCurrentVV();
//    /*
//    if(n.getCurrentVV().includes(vvOnLastGC)){
//      System.out.println("Node " + nodeId + " GCed at " + vvOnLastGC);
//      n.garbageCollect(n.getNextLargestVV(vvOnLastGC));
//      return n.getCurrentVV();//isGCed = true;
//    } else {
//      return vvOnLastGC;
//    }*/

  }
  
  AcceptVV omitVV;
  
  private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9941;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new BranchID(NODE_1_ID++),
                              NODE_1_IP,
                            port++,
                            port++,
                            port++,
                            port++,
                            port++,
                            "test" + File.separatorChar + "local-" + 
                            NODE_1_ID + ".db",
                            "/*",
                            -1L,
                            NODE_1_IP,
                            port++,
                            port++,
                            -1,
                            Config.CACHE_SIZE_BYTES_DEFAULT,
                            Config.MAX_LOG_DISK_SIZE_BYTES,
                            Config.MAX_LOG_MEM_SIZE_BYTES);
    }
        
  }
  
  public void processSimulatorCommandFile(){
    try{
      //System.out.println("GC Period : " + GCPeriod);
      String line;
      CounterVV maxVV = new CounterVV();
      boolean runOptionalCmd = false;
      long logicalClock = 0;
      vvOnLastGC = maxVV.cloneAcceptVV();
      omitVV = new AcceptVV();
      int numNodes = 0;
      int[] nodeIdArr = null;
      while((line = br.readLine())!=null){
        // skipping comments
        if(line.startsWith("#")){
          System.out.println(line);
          
          
          if(line.startsWith("# Number of nodes :")){
            numNodes = Integer.parseInt(line.split(":")[1].trim());
            nodeIdArr = new int[numNodes];
            assert totalCount == numNodes: numNodes + " totalCount " + totalCount;
          }
          if(line.startsWith("# Node IDes :") && nodeIdArr != null){
            String[] s = line.split(":")[1].trim().split("\\s+");
            
            assert s.length == numNodes : "s length : " + s.length + ", numNodes: "+numNodes;
            
            for(int i=0; i < numNodes; i++){
              nodeIdArr[i] = Integer.parseInt(s[i]);
            }
            System.out.println("Populating "+ numUpdatesPrePopulated + "updates at" + numNodes +" nodes");
            for(int i=0; i < numNodes; i++){
              ObjId objid = new ObjId("/"+i);
              for(int j=0; j < numUpdatesPrePopulated/numNodes; j++){
                nodeMap.get(i).write(objid, new IrisDataObject(""+j));
              }
            }
          }

          continue;

        }
//        if(logicalClock > 0 && GCPeriod > 0 && logicalClock % GCPeriod == 0){
//          if(triggerGC()){
//            vvOnLastGC = maxVV.cloneAcceptVV();
//          }
//        }
        commandCounter++;
        System.out.println("TraceExecutor executing " + commandCounter + " command out of " +  numCommands + " " + ((commandCounter*100)/numCommands) + "% done");
        System.out.println("TraceExecutor executing " + line);

        if(commandCounter%500 == 0){
          System.out.println("----------------------------------------- " +"Round " + (commandCounter/500+1) + "----------------------------------------- ");
          for(Node n: this.nodeMap.values()){
            IrisNode in = (IrisNode)n;
            in.testRead();
            System.out.println(in.getBranchID() + " " + in.getGCProtocol().getPhaseTest());
             
          }
          try{
            Thread.sleep(IrisNode.timeout*2);
          }catch(InterruptedException e){
            e.printStackTrace();
          }
        }
        
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter(" ");
        if ( scanner.hasNext() ){
          String s = scanner.next();
          long time = -1;
          if(s.startsWith("T")){
            time = Long.parseLong(s.substring(1));
            s = scanner.next();
          }
          int commandType = Integer.parseInt(s);
          if(commandType == SLEEP)
          {
            continue;
          }
          int srcNode = Integer.parseInt(scanner.next());
          analyzeTrace(srcNode, line);

          srcNode = nodeMapping(srcNode);

          switch(commandType){
          case TraceExecutor.STARTNODE:
            break;
          case TraceExecutor.KILLNODE:
            break;
          case TraceExecutor.SETINTERESTSET:
            break;
          case TraceExecutor.TERMINATECONNECTION:
            break;
          case TraceExecutor.GARBAGECOLLECT:
            vvOnLastGC = triggerGC(srcNode);
            break;
          case TraceExecutor.STARTCONNECTION:
            int destNode;
            Node sNode;
            Node dNode;
            try{
              destNode = TraceExecutor.nodeMapping(Integer.parseInt(scanner.next()));
              sNode = nodeMap.get(srcNode);
              dNode = nodeMap.get(destNode);
              
//            if(sNode.getCurrentVV().includes(dNode.getCurrentVV())){
//              runOptionalCmd = false;
//              break;
//            }
            
//            AcceptVV vv = 
              SyncStatus ss =  ((IrisNode)sNode).exponentialBackoffSync(dNode);
              //System.out.println(sNode.getBranchID() + " " + srcNode +" CVV after sync: " + sNode.getCurrentVV());
              if(faultyNodeIDSet.contains(destNode)){
                // if sender is faulty
                HashMap<BranchID, TreeSet<PreciseInv>> map = ((IrisNode)sNode).getAcceptedForkedWrites(dNode.getBranchID().getBaseId());
                for(BranchID bid : map.keySet()){
                  acceptedFaultyWrites.addAll(map.get(bid));
                }
              }
              System.out.println("Number of bad writes propagated (uniq) : " + acceptedFaultyWrites.size());

              if(!sNode.getCurrentVV().includes(dNode.getCurrentVV())){
                System.out.println("Fall back to optional sync");
                runOptionalCmd = true;
              } else {
                runOptionalCmd = false;
              }
            }catch(NumberFormatException e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              assert false;
            }catch(Exception e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              assert false;
            }
            
//            maxVV.advanceTimestamps(vv);
//            if(!vv.includes(maxVV)){
//              //System.out.println("Node " + srcNode + " inconsistent ");
//            }else{
//              //System.out.println("Node " + srcNode + " consistent ");
//            }
//            //logicalClock++;
            break;
          case TraceExecutor.OPTIONALSYNC:            
            try{
              destNode = TraceExecutor.nodeMapping(Integer.parseInt(scanner.next()));
              if(!false) break;
              sNode = nodeMap.get(srcNode);
              dNode = nodeMap.get(destNode);
              
              //vv = 
                sNode.sync(dNode);
              
              if(!sNode.getCurrentVV().includes(dNode.getCurrentVV())){
                runOptionalCmd = true;
              } else {
                runOptionalCmd = false;
                System.out.println("Optional sync succeeded");
              }
              
//            maxVV.advanceTimestamps(vv);
//            if(!vv.includes(maxVV)){
//              //System.out.println("Node " + srcNode + " inconsistent ");
//            }else{
//              //System.out.println("Node " + srcNode + " consistent ");
//            }
//            //logicalClock++;
            }catch(NumberFormatException e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              assert false;
            }catch(Exception e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              assert false;
            }
            
            break;
          case TraceExecutor.UPDATE:
            String obj = scanner.next();
            if(!obj.startsWith("/")){
              obj = "/" + obj;
            }
            
            obj = "/"+ srcNode + "/" + commandCounter;
            
            assert(obj != null);
            ObjId objId = new ObjId(obj);
            Node n = nodeMap.get(srcNode);
            String data = scanner.next();
            assert(data != null);
            byte val[] = new byte[1];
            val[0] = Byte.parseByte(data);
            if(n.canWrite()){
              n.write(objId, new IrisDataObject(val[0]));
            }else{
              //System.out.println("can't write at forked branch " + nodeMap.get(srcNode));
            }
            logicalClock++;
            runOptionalCmd = false;
            break;
          case TraceExecutor.SETTRUSTEDNODE:
            break;
          case TraceExecutor.SETLIVENESSFILTER:
            break;
          case TraceExecutor.FORK:
            try{
              int numBranches = Integer.parseInt(scanner.next());
              Node parent = nodeMap.get(srcNode);
              LinkedList<Node> newNodes = parent.fork(numBranches);
              for(int i=0; i < numBranches; i++){
                int childID = Integer.parseInt(scanner.next());
                /*
                if( nodeMap.containsKey(childID) ){
                  assert false;
                  System.out.println("Creating a branch with a exsiting ID : " + childID);
                  System.exit(-1);
                }*/
                nodeMap.put(childID, newNodes.get(i));
                this.totalCount++;
                this.syncCount.put(childID, 0);
                this.updateCount.put(childID, 0);
                System.out.println(newNodes.get(i).getBranchID() + " "+ childID + " CVV after sync: " + newNodes.get(i).getCurrentVV());
                faultyNodeIDSet.add(childID);
              }
            }catch(NumberFormatException e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              System.exit(0);
            }catch(Exception e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              System.exit(0);
            }
            
            break;
          default:
            assert false:line + " " + commandType;  

          }
        }
        else {
          assert false;
        }          
        System.out.println("TraceExecutor finished executing " + line);
        Thread.yield();

        
      }
      SubscriptionSet ignoreSet = SubscriptionSet.makeSubscriptionSet(IrisNode.globalCertificatesString+"*");
      
      StoreInterface expectedStore = nodeMap.get(0).getStore();
      for(Integer i: nodeMap.keySet()){
        int mismatches = code.simulator.checkpoint.unit.SimulatorMechanismCheckpointUnit.compareStore(expectedStore, nodeMap.get(i).getStore(), ignoreSet, false);
        if(mismatches != 0){
          System.out.println("stores of node 0 and node " + i + " " + nodeMap.get(i).getBranchID() + " DON'T MATCH " + mismatches);
        }else{
          System.out.println("stores of node 0 and node " + i + " " + nodeMap.get(i).getBranchID() + " MATCH");
        }
      }
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }

  }


  public void processCommandFile(){
    try{
      String line;
      boolean wasUpdating = false;
      int updatingNode = -1;
      while((line = br.readLine())!=null){
        // skipping comments
        if(line.startsWith("#")){
          System.out.println(line);
          
          if(line.startsWith("# Number of nodes : ")){
            int numInitNodes = Integer.parseInt(line.split(":")[1].trim());
            for(int i=0; i< numInitNodes; i++){
              String cmd = TraceExecutor.STARTNODE + " " + i;
              sendCommand(i, cmd);
              waitForACK(i);
            }
          }
          
          continue;

        }

        commandCounter++;
        System.out.println("TraceExecutor executing " + commandCounter + " command out of " +  numCommands + " " + ((commandCounter*100)/numCommands) + " done");
        System.out.println("TraceExecutor executing " + line);

        if(commandCounter%500 == 0){
          System.out.println("----------------------------------------- " +"Round " + (commandCounter/500+1) + "----------------------------------------- ");
//          for(Node n: this.nodeMap.values()){
//            IrisNode in = (IrisNode)n;
//             System.out.println(in.getBranchID() + " " + in.getGCProtocol().getPhaseTest());
//          }
          try{
            Thread.sleep(IrisNode.timeout*2);
          }catch(InterruptedException e){
            e.printStackTrace();
          }
        }
        
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter(" ");
        if ( scanner.hasNext() ){
          int commandType = Integer.parseInt(scanner.next());
          if(commandType == OPTIONALSYNC){
            continue;
          }
          
          if(commandType == SLEEP)
          {
            int sleepTime = Integer.parseInt(scanner.next());
            try {
              Thread.sleep(sleepTime*1000);
            } catch (InterruptedException e) {
              // TODO Auto-generated catch block
              e.printStackTrace();
            }
            continue;
          }
          //long time = Long.parseLong(scanner.next());
          String s = scanner.next();
          if(s.startsWith("T")){
            s = scanner.next();
          }
          int srcNode = Integer.parseInt(s);
          srcNode = nodeMapping(srcNode);

          if(useTrustedNode && execute){
            // trusted node related code
            // check if we were updating at nodeId updatindNode? If yes, and if the current command is not at updatingNode and the last node was updating, 
            // sync with the trusted node
            // also update the updatingNode and wasUpdating 
            if(updatingNode != srcNode && wasUpdating && updatingNode != trustedNode){
              // insert command for the trusted node to sync with the updating node
              String syncCommand = STARTCONNECTION + " " + trustedNode + " " + updatingNode;
              sendCommand(trustedNode, syncCommand);
              System.out.println("node " + updatingNode + " ("  + nodeMapping(updatingNode) + " ) " + " was updating, its CVV " + acceptVVMap.get(nodeMapping(updatingNode)));
              sendCommand(trustedNode, acceptVVMap.get(nodeMapping(updatingNode)));
              System.out.println("TraceExecutor waiting for ACK from trusted node sync");

              waitForACK(trustedNode);
              // now reset the updatingNode and wasUpdating
              wasUpdating = false;
              updatingNode= srcNode;
            }

            // now reset the updating node
            if(commandType == UPDATE){
              wasUpdating = true;
              updatingNode = srcNode;
            }
            // trusted node related code over
          }
          
          if(commandType == FORK){
            System.out.println("FORKING");
            int numBranches = Integer.parseInt(scanner.next());
            int originNodeID = srcNode;
            while(parentOfForkedNodes.containsKey(originNodeID)){
              originNodeID = parentOfForkedNodes.get(originNodeID);
            }
            for(int i=0; i < numBranches; i ++){
              int childID = Integer.parseInt(scanner.next());
              parentOfForkedNodes.put(childID, srcNode);
              
              String cmd = STARTNODE +" "+ originNodeID;
              
              sendCommand(childID, cmd);
              waitForACK(childID);
              cmd = STARTCONNECTION + " " + childID + " " + srcNode;
              sendCommand(childID, cmd);              
              sendCommand(childID, acceptVVMap.get(srcNode));                            
              waitForACK(childID);
            }
            System.out.println("TraceExecutor finished executing " + line);
            continue;
          }
          

          
          sendCommand(srcNode, line);
          

          
          int destNode = -1;
          
          if(commandType == DROP){
            destNode = Integer.parseInt(scanner.next());
            destNode = nodeMapping(destNode);
            NodeId destId = new NodeId(destNode);
            //AcceptStamp as;
            long ts = 0;
            try{
              ts = acceptVVMap.get(destNode).getStampByServer(destId);
            }catch(NoSuchEntryException e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              System.exit(-1);
            }
            AcceptStamp as = new AcceptStamp(ts-1L,destId);
          }
          
          if(commandType == STARTCONNECTION && execute){

            sendCommand(srcNode, acceptVVMap.get(destNode));
          }
          System.out.println("TraceExecutor waiting for ACK");

          waitForACK(srcNode);
          assert  listenerMap.size() == totalCount: totalCount + " " + listenerMap.size();
          assert  inputStreamMap.size() == totalCount: totalCount + " " + inputStreamMap.size();
          assert  outputStreamMap.size() == totalCount: totalCount + " " + outputStreamMap.size();
          assert  acceptVVMap.size() == totalCount: totalCount + " " + acceptVVMap.size();

          if(commandType == STARTCONNECTION){
            //assert acceptVVMap.get(srcNode).includes(acceptVVMap.get(destNode));
          }
          System.out.println("TraceExecutor finished executing " + line);

        }
        else {
          assert false;
        }
        //(no need for finally here, since String is source)
        scanner.close();
      }
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

  public String getSubscriptionSet(BufferedReader br){
    Set<String> subscriptionSet = new TreeSet<String>();
    Hashtable<Integer, Set<String>> subscriptionSetSet = new Hashtable<Integer, Set<String>>();
    try{
      String line;
      while((line = br.readLine())!=null){
        if(line.startsWith("#")){
          continue;
        }
        numCommands++;
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter(" ");
        if ( scanner.hasNext() ){
          String s = scanner.next();
          if(s.startsWith("T")){
            s = scanner.next();
          }
          int commandType = Integer.parseInt(s);
          //long time = Long.parseLong(scanner.next());
          //scanner.next();
          //scanner.next();
          int srcNode = Integer.parseInt(scanner.next());
          srcNode = nodeMapping(srcNode);
          if(commandType == UPDATE || commandType == MOVEIN){
            String ss = "/"+getObjId(scanner);
            subscriptionSet.add(ss);
            if(subscriptionSetSet.containsKey(srcNode)){
              subscriptionSetSet.get(srcNode).add(ss);
            }else{
              Set<String> tmpSS = new TreeSet<String>();
              tmpSS.add(ss);
              subscriptionSetSet.put(srcNode, tmpSS);
            }
          }

        }
        else {
          assert false;
        }
        //(no need for finally here, since String is source)
        scanner.close();
      }
    }catch(IOException e){
      // TODO Auto-generated catch block
      assert false;
      e.printStackTrace();
    }

    for(int i: subscriptionSetSet.keySet()){
      subscriptionSetMap.put(i, processSet(subscriptionSetSet.get(i)));
    }
    String subSet = processSet(subscriptionSet);
    System.out.println("subscription set: " + subSet);
    return subSet;

  }

  public String processSet(Set<String> subscriptionSet){
    StringWriter ss = new StringWriter();
    boolean first = true;
    for(String s: subscriptionSet){
      if(!first){
        ss.write(":"+s);
      }else{
        ss.write(s);
        first = false;
      }
    }

    return ss.toString();
  }
  public String getObjId(Scanner scanner){
    String obj = scanner.next();
    if(obj.startsWith("/")){
      return obj;
    }else{
      return "/"+obj;
    }
  }


  public void waitForACK(int srcNode){
    if(!execute || SangminConfig.useSimulator){
      return;
    }
    String readValue = "";
    try{
      while((readValue = (String)inputStreamMap.get(srcNode).readObject()) == null || 
          !readValue.equals("ACK"+srcNode)){
        System.out.println("desired ACK not found: obtained" + readValue);
      }
      System.out.println("TraceExecutor waiting for AcceptVV");

      AcceptVV initAcceptVV = (AcceptVV)inputStreamMap.get(srcNode).readObject();
      acceptVVMap.put(srcNode, initAcceptVV);
    }catch(IOException e){
      e.printStackTrace();
      assert false;
      // TODO Auto-generated catch block      
    }catch(ClassNotFoundException e){

      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
  }


  public void sendCommand(int nodeId, Object command){
    analyzeTrace(nodeId, command);
    if(!execute){
      return;
    }
    try{
      assert outputStreamMap.containsKey(nodeId):nodeId +" not present" + command;
      outputStreamMap.get(nodeId).writeObject(command);
      outputStreamMap.get(nodeId).flush();
      outputStreamMap.get(nodeId).reset();
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }


  public void analyzeTrace(int nodeId, Object command){
    if(!analyze){
      return;
    }
    if(!(command instanceof String)){
      return;
    }else{
      Scanner scanner = new Scanner((String)command);
      scanner.useDelimiter(" ");
      
      String s = scanner.next();
      if(s.startsWith("T")){
        s= scanner.next();
      }
      int commandType = Integer.parseInt(s);
      
      if(commandType == STARTCONNECTION){
        syncCount.put(nodeId, syncCount.get(nodeId) + 1);
      }else if(commandType == UPDATE){
        updateCount.put(nodeId, updateCount.get(nodeId) + 1);
      }
    }
  }

  static int compressFactor = 10;

  public static int nodeMapping(int nodeId){
    if(SangminConfig.useSimulator){
      return nodeId;
    }else{
      return nodeId % compressFactor;
    }
  }

  public static void main(String[] args){

    assert args.length >=3;
    if(args.length == 4){
      omission_faulty_node = Integer.parseInt(args[3]);
    }
    TraceExecutor te = new TraceExecutor(Integer.parseInt(args[1]), Integer.parseInt(args[2]), args[0]);

  }
}
