package code.security.application.MapShare.trace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;


public class TraceGenerator3{
  
  static long SESSIONTIME = 20L; // 30 minutes
  static int numWritesPerSyn = 10;
  static int numObjs = 100;
  
  static void debug(String s){
    //System.out.println(s);
  }
  
  long ctime;
  OutputStreamWriter out;
  BufferedReader in;
  HashMap<Integer,AP> APes; // ap id to AP object mapping
  Integer[] nodeIDArr;
  Random r;
  
  class AP{
    int id;
    TreeSet<Node> connectedNodes;
    
    public AP(int apId){
      id = apId;
      connectedNodes = new TreeSet<Node>();
    }
    
    class Node implements Comparable<Node>{
      int id;
      long connectedTime;
      public Node(int nodeId, long connectiontime){
        id = nodeId;
        connectedTime = connectiontime;
      }
      
      public boolean equals(Object o){
        if(!(o instanceof Node)){
          return false;
        }
        return this.id == ((Node)o).id;
      }

      public int compareTo(Node o){
        return this.id<o.id?-1:
          this.id>o.id?1:0;
      }
    }
    
    public String toString(){
      String dmg = "Nodes connected ("+id+"): ";
      for(Node n : connectedNodes){
        dmg += n.id + " ";
      }
      return dmg;
    }
    
    String addNode(int nodeId, long time){
      // sync to all nodes connected to this AP
      debug("Adding node " + nodeId + " to AP " + id);
      String cmd = "";
      Node n = new Node(nodeId,time);
      connectedNodes.add(n);
      /*
      boolean alreadyConnected = false;
      
      for(Node n : connectedNodes){
        if(n.id == nodeId){
          n.connectedTime = ctime;
          alreadyConnected = true;
        } else {
          cmd += getRandomWrites();
          //cmd += TraceExecutor.STARTCONNECTION + " " + nodeId + " " + n.id +"\n";
          cmd += TraceExecutor.STARTCONNECTION + " " + n.id + " " + nodeId +"\n";          
        }
      }
      if(!alreadyConnected){        
        connectedNodes.add(new Node(nodeId, ctime));
      }
      */
      debug(this.toString());
      
      return cmd;
      
    }
    
    private String syncAll(){
      String ret = "";
      for(Node receiver : connectedNodes){
        for(Node sender : connectedNodes){
          if(!receiver.equals(sender)){
            ret += "T"+ctime + " " + TraceExecutor.STARTCONNECTION + " "
                  + receiver.id + " " + sender.id +"\n";
          }
        }
      }
      return ret;
    }
    
    String proceedTo(long time){
      
      String ret = syncAll();
      
      // disconnect node that has been connected for SESSIONTIME
      LinkedList<Node> nodesToRemove = new LinkedList<Node>();
      
      for(Node n : connectedNodes){
        //if(n.connectedTime + SESSIONTIME < ctime){
        if(time - n.connectedTime > SESSIONTIME){
          nodesToRemove.add(n);
          debug("Removing node " + n.id + " from AP " + id);
        }
      }
      
      connectedNodes.removeAll(nodesToRemove);           
      return ret;
    }
    
  }
  
  public TraceGenerator3(String inputFile, OutputStream os) throws IOException{
    in = new BufferedReader(new FileReader(inputFile));
    out = new OutputStreamWriter(os);
    ctime = 0;
    APes = new HashMap<Integer,AP>();
    r = new Random();
    nodeIDArr = new Integer[3];
    readNodes(inputFile);
    
  }
  
  String getRandomWrites(){
    String cmd = "";
//    for(int i=0; i < numWritesPerSyn; i++){
//      int nodeIdx = r.nextInt(nodeIDArr.length);
//      int objIdx = r.nextInt(numObjs);
//      cmd += TraceExecutor.UPDATE + " " + nodeIDArr[nodeIdx] + " /obj" + objIdx + " " + r.nextInt(100)+"\n";
//    }
    for(int i=0; i < 4; i++){
      int nodeIdx = r.nextInt(nodeIDArr.length);
      int objIdx = r.nextInt(numObjs);
      cmd += "T"+ctime + " " + TraceExecutor.UPDATE + " " + nodeIDArr[nodeIdx] + " /obj" + objIdx + " " + r.nextInt(100)+"\n";
    }
    return cmd;
  }
  
  private void readNodes(String inputFile) throws IOException{
    BufferedReader nodeReader = new BufferedReader(new FileReader(inputFile));
    
    HashSet<Integer> nodeSet = new HashSet<Integer>();
    
    String line;
    while ( (line = nodeReader.readLine()) != null){
      if ( ! (line.charAt(0) >= '0' && line.charAt(0) <= '9') )
        continue;
      nodeSet.add(Integer.parseInt(line.split(",")[0]));
    }
    
    nodeIDArr = nodeSet.toArray(nodeIDArr);
    System.out.println("# Number of nodes : " + nodeIDArr.length);
    System.out.print("# Node IDes : ");
    for(Integer node : nodeIDArr){
      System.out.print(" " +node);
    }
    System.out.print("\n");
  }
  
  private static long getTime(String date, String time){
    
    String[] dateStrings = date.split("-");
    long monthInSec = (Long.parseLong(dateStrings[0])-1L) * 31L * 24L * 60L * 60L;
    long dayInSec = (Long.parseLong(dateStrings[1])-1L) * 24L * 60L * 60L;
    String[] timeStrings = time.split(":");
    long hourInSec = Long.parseLong(timeStrings[0]) * 60L * 60L;
    long minuteInSec = Long.parseLong(timeStrings[1]) * 60L;
    long secondInSec = Long.parseLong(timeStrings[2]);
    
    return monthInSec + dayInSec + hourInSec + minuteInSec + secondInSec;

  }
  
  private String proceedTime(long time){
    debug("Proceeding global time to " + time);
    ctime = time;
    String cmd = getRandomWrites();    
   
    for(AP ap : APes.values()){
      debug("before " + ap);
      cmd += ap.proceedTo(time);
      debug("after " + ap);
    }
    return cmd;
  }
  
  
  public void generate() throws IOException{
    
    String line;
    long prevTime = -1;
    while((line = in.readLine()) != null){
      if ( ! (line.charAt(0) >= '0' && line.charAt(0) <= '9') )
        continue;
      
      String[] tokens = line.split(",");
      String cmd = "";
      
      int nodeId = Integer.parseInt(tokens[0]);
      long time = getTime(tokens[1], tokens[2]);
      int apID = Integer.parseInt(tokens[3]);
      
      //System.out.println("prev time " + prevTime + " time " + time);
      if(prevTime >= 0){
        long t;
        for(t = prevTime+20L; t < time; t += 20L){
          cmd += proceedTime(t);
          prevTime = t;
        }
        
      }else {
        prevTime = time-1;
      }
      
      
      //proceedTime(time);
      AP ap;
      if(APes.containsKey(apID)){
        ap = APes.get(apID);
      } else {
        ap = new AP(apID);
        APes.put(apID, ap);
      }
      ap.addNode(nodeId, time);
      
      out.write(cmd);
      out.flush();
      
    }            
    
  }
            
  
  public static void main(String[] args) throws IOException{
    
    //File input = new File(args[0]);
    
    TraceGenerator3 tg3 = new TraceGenerator3(args[0], System.out);
    
    tg3.generate();
    
  }
}
