package code.security.application.MapShare.trace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Random;
import java.util.Scanner;
import java.util.HashSet;
import java.net.*;
import java.io.*;

import code.branchDetecting.BranchID;
import code.security.holesync.filter.*;
import code.AcceptStamp;
import code.AcceptVV;
import code.LatencyWatcher;
import code.ObjId;
import code.SubscriptionSet;
import code.Config;
import code.NodeId;
import code.VV;
import code.VVIterator;
import code.security.SangminConfig;
import code.security.SecureCore;
import code.security.application.MapShare.*;
import code.signedVV.RCore;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.NodeFactory;
import code.simulator.SimBranchID;

public class TraceListener extends Thread{
  
  public final static long deathTime = 60000; // 1 min
  
  public final static boolean randomWrite = false;
  public final static boolean repeatedRandomWrites = true;

  public final static int writeCount = 1;
  public int numWrites = writeCount;
  String lastWrittenObj = "";
  Random r = new Random();

  static String defaultConfigPath = "./trace.config";
  int myNodeId;
  Socket server;
  ObjectOutputStream outputStream;
  ObjectInputStream inputStream;
  MapManager mapManager;
  String configPath;
  int serverPort;
  String serverHost;
  public AcceptVV reqVV;
  public AcceptVV curVV;
  
  public final static boolean useIrisNode = true;
  IrisNode irisNode;
  private AcceptVV lastRequestedOmitVV;
  private AcceptVV vvOnLastGC;
    
  private boolean subscribeInvalSucceeded = false;
  
  String IS;

  public int trustedNode = -1; 
  boolean connected;


  HashSet<Integer> destSet;

  public TraceListener(int serverPort, String serverHost, int myNodeId){
    this(serverPort, serverHost, myNodeId, defaultConfigPath);
    
  }
  
  public TraceListener(int serverPort, String serverHost, int myNodeId, String configPath){
    this.myNodeId = myNodeId;
    this.configPath = configPath;
    this.serverPort = serverPort;
    this.serverHost = serverHost;
    Config.readConfig(configPath); 
    curVV = AcceptVV.makeVVAllNegatives();

    destSet = new HashSet<Integer>();

    connected = false;
    if(useIrisNode){
      lastRequestedOmitVV = new AcceptVV();
      vvOnLastGC = new AcceptVV();        
    }

  }
  
  public void run(){
    try{
      System.out.println("going to contact server at  " + serverPort + " host" + serverHost);
      
      server = new Socket(serverHost, serverPort);
      outputStream = new ObjectOutputStream(server.getOutputStream());
      outputStream.writeInt(myNodeId);
      outputStream.flush();
      inputStream = new ObjectInputStream(server.getInputStream());
      outputStream.writeObject(AcceptVV.makeVVAllNegatives());
      int compressionFactor = inputStream.readInt();
      TraceExecutor.compressFactor = compressionFactor;
      System.out.println("received compression factor " + compressionFactor);
    }catch(UnknownHostException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
      
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
      
    }
    
    
    String line;
    try{
      while((line = (String)inputStream.readObject()) != null){
        System.out.println("Processing : " + line);
        processCommand(line, inputStream);
      }
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(ClassNotFoundException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
  public void processCommand(String line, ObjectInputStream inputStream){
    Scanner scanner = new Scanner(line);
    scanner.useDelimiter(" ");
    if ( scanner.hasNext() ){
      int commandType = Integer.parseInt(scanner.next());
      System.out.println("commandType : " + commandType);
     // long time = Long.parseLong(scanner.next());
      long time = 0;
      int srcNode = Integer.parseInt(scanner.next());
      switch(commandType){
      case TraceExecutor.STARTNODE:
        processSTARTNODE(time, srcNode);
        break;
      case TraceExecutor.KILLNODE:
        processKILLNODE(time, srcNode);
        break;
      case TraceExecutor.SETINTERESTSET:
        processSETINTERESTSET(time, srcNode, scanner);
        break;
      case TraceExecutor.TERMINATECONNECTION:
        //processTERMINATECONNECTION(time, srcNode, scanner);
        break;
      case TraceExecutor.GARBAGECOLLECT:
        processGARBAGECOLLECT(time, srcNode);
        break;
      case TraceExecutor.STARTCONNECTION:
        try{
            reqVV = (AcceptVV)inputStream.readObject();
            processSTARTCONNECTION(time, srcNode, scanner, reqVV);
          }catch(IOException e){
            // TODO Auto-generated catch block
            e.printStackTrace();
            assert false;
          }catch(ClassNotFoundException e){
            // TODO Auto-generated catch block
            e.printStackTrace();
            assert false;
          }
        break;
      case TraceExecutor.UPDATE:
        processUPDATE(time, srcNode, scanner);
        break;
      case TraceExecutor.SETTRUSTEDNODE:
        trustedNode = Integer.parseInt(scanner.next());
        processSETTRUSTEDNODE(srcNode, trustedNode);
        break;
      case TraceExecutor.SETLIVENESSFILTER:
        processSETLIVENESSFILTER(Integer.parseInt(scanner.next()));
        break;
      default:
        assert false:line + " " + commandType;  

      }
    }
    else {
      assert false;
    }
    //(no need for finally here, since String is source)
    scanner.close();
    sendMessage("ACK"+myNodeId);
    sendMessage(curVV);
    System.out.println(this.myNodeId + "Sent ACK");
  }
  
  public void sendMessage(Object msg){
    try{
      outputStream.writeObject(msg);
      outputStream.flush();
      outputStream.reset();
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
  
  public void processSETTRUSTEDNODE(int srcNode, int trustedNode){
    System.out.println("trusted node set at " + srcNode + " to " + trustedNode);
//    code.security.TraceSplitManager.trustedNode = new NodeId(trustedNode);
    MapManager.trustedNode = new NodeId(trustedNode);
  }  
  
  public void processSTARTNODE(long time, int srcNode){

    if(useIrisNode){
      assert irisNode == null;
      irisNode = (IrisNode)NodeFactory.createIrisNode(NodeFactory.createNodeId(srcNode), NodeFactory.createNodeId(myNodeId));
      return;
    }

    
    int realSrcNode = TraceExecutor.nodeMapping(srcNode);
    if(realSrcNode == srcNode){
      System.out.println("STARTNODE command received at " + srcNode);
      assert this.myNodeId == srcNode;
      String userName = "user"+srcNode;      
      //MapManager.trustedNode = new NodeId(myNodeId); 
      mapManager = new MapManager(userName, srcNode, "", configPath, new TraceMapController(this));
//            StupidAssertionThread sat = new StupidAssertionThread(mapManager.getUraNode().getCore(), this);
      
    }else{
      assert false: "realSrcNode: " + realSrcNode + " srcNode " + srcNode;
    }
  }
    
  
  public void processKILLNODE(long time, int srcNode){
    if(useIrisNode){
//      if(irisNode != null){
//        System.out.println("CVV : " + irisNode.getCurrentVV());
//        
//        Iterator<NodeLog> iter = irisNode.getLogForSanityCheck().values().iterator();
//        long numWrites = 0;
//        while(iter.hasNext()){
//          NodeLog nl = iter.next();
//          numWrites += nl.size();
//        }
//        System.out.println("Num writes in log : " + numWrites);
//      }
      irisNode.close();
      java.util.TimerTask task = new java.util.TimerTask() {
        
        public void run() {
                System.out.println("PRACTI node going to die");
                try{
                  server.close();
                }catch(IOException e){
                  e.printStackTrace();
                }
                System.exit(0);
        }
     };
     new java.util.Timer().schedule(task, deathTime);
     return;
    }
    int realSrcNode = TraceExecutor.nodeMapping(srcNode);
    if(realSrcNode == srcNode){
      System.out.println("KILLNODE command received at " + srcNode);
      
      System.out.println(LatencyWatcher.getSummary());
      
      if(mapManager.getUraNode().getCore() instanceof RCore){
        RCore rCore = (RCore)mapManager.getUraNode().getCore();
        rCore.printStats();
      }else if(mapManager.getUraNode().getCore() instanceof SecureCore){
        SecureCore sCore = (SecureCore)mapManager.getUraNode().getCore();
        sCore.printStats(new SubscriptionSetFilter(this.mapManager.getSs()));
      }
      
      
      java.util.TimerTask task = new java.util.TimerTask() {
        
        public void run() {
                System.out.println("PRACTI node going to die");
                System.exit(0);
        }
     };
     new java.util.Timer().schedule(task, deathTime);
    }
  }
 
  public synchronized void updateCVV(){
    //System.out.println("UpdateCVV called at node " + myNodeId);
    if(mapManager != null){
      this.curVV = (AcceptVV)mapManager.getUraNode().getCurrentVV();
     //System.out.println("CVV at " + myNodeId + " updated to " + curVV);  
    }
    //new Throwable().printStackTrace();
    this.notifyAll();
  }
  
  public void processSETINTERESTSET(long time, int srcNode, Scanner scanner){
    System.out.println("SETINTERESTSET command received at " + srcNode);
    IS = scanner.next();
    if(randomWrite){
      SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet(IS+":/special:/certificate/*");
      mapManager.setSs(ss);
    } else {
      SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet(IS+":/certificate/*");
      mapManager.setSs(ss);
    }
  }
  private AcceptVV triggerGC(int nodeId){

    //Node n = irisNode;
    
    if(lastRequestedOmitVV.size() <= 0 ){
    	lastRequestedOmitVV = irisNode.getCurrentHashedVV();//irisNode.getCurrentVV();
      return lastRequestedOmitVV;
    } else {
      System.out.println("Node " + nodeId + " triggers GC at " + lastRequestedOmitVV);
      irisNode.garbageCollect(lastRequestedOmitVV);//irisNode.getNextLargestVV(lastRequestedOmitVV));
      lastRequestedOmitVV = new AcceptVV();
      return irisNode.getCurrentVV();
    }

    //System.out.println("Node " + nodeId + " GCed at " + vvOnLastGC);
    //System.out.println("Node " + nodeId + " GCed at " + n.getCurrentVV());
    //n.garbageCollect(n.getNextLargestVV(vvOnLastGC));
    //n.garbageCollect(n.getCurrentVV());
    //return n.getCurrentVV();//isGCed = true;
//    if(irisNode.getOmitVV().includes(lastRequestedOmitVV)){
//      System.out.println("Node " + nodeId + " triggers GC at " + vvOnLastGC);
//      irisNode.garbageCollect(irisNode.getNextLargestVV(vvOnLastGC));
//      lastRequestedOmitVV = vvOnLastGC;      
//    }
//    
//    return irisNode.getCurrentVV();
    /*
    if(n.getCurrentVV().includes(vvOnLastGC)){
      System.out.println("Node " + nodeId + " GCed at " + vvOnLastGC);
      n.garbageCollect(n.getNextLargestVV(vvOnLastGC));
      return n.getCurrentVV();//isGCed = true;
    } else {
      return vvOnLastGC;
    }*/

  }
  public void processGARBAGECOLLECT(long time, int srcNode){
    System.out.println("GARBAGECOLLECT command received at " + srcNode);
    vvOnLastGC = triggerGC(srcNode);
  }
  

  
  public void processTERMINATECONNECTION(long time, int srcNode, Scanner scanner){
    System.out.println("TERMINATECONNECTION command received at " + srcNode);
    int destNode = TraceExecutor.nodeMapping(Integer.parseInt(scanner.next()));
    NodeId nId = new NodeId(destNode);
    if(!destSet.contains(new Integer(destNode))){
      System.out.println("No connection is exist for " + destNode);
      return;
    }
    if(destNode != TraceExecutor.nodeMapping(srcNode)){
      mapManager.removeConnection(nId);
    }
    destSet.remove(new Integer(destNode));
    //this.waitForCallback();
    this.waitForConnectTermination();
  }
 
  public void processSTARTCONNECTION(long time, int srcNode, Scanner scanner, AcceptVV finalAcceptVV){
    //System.out.println("STARTCONNECTION command received at " + srcNode + " curVV " + curVV + " need to wait until it becomes " + finalAcceptVV);
    /* This is wrong
    VVIterator vvi = finalAcceptVV.getIterator();
    long numInv = 0;
    while(vvi.hasMoreElements()){
      Object token = vvi.getNext();      
      long ts1 = curVV.getStampByIteratorToken(token);
      long ts2 = finalAcceptVV.getStampByIteratorToken(token);
      if(ts2 - ts1 > 0){
        numInv += ts2 - ts1;
      }
    }
    System.out.println("CheckPoint Size: " + numInv);
    */
    
    int destNode = TraceExecutor.nodeMapping(Integer.parseInt(scanner.next()));
    
    if(useIrisNode){
      BranchID bid = NodeFactory.createNodeId(destNode);
      
      //irisNode.sync2(bid, irisNode.getCurrentVV());
      try{
        irisNode.exponentialBackoffSync(bid, irisNode.getCurrentVV());
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
      curVV = irisNode.getCurrentVV();
      //System.out.println(irisNode.getBranchID() + " " + myNodeId +" CVV after sync: " + irisNode.getCurrentVV());
      return;
    }
    
    if(destSet.contains(new Integer(destNode))){
        System.out.println("Already have connection to " + destNode);
        return;
    }else{
        destSet.add(new Integer(destNode));
    }
    NodeId nId = new NodeId(destNode);
    if(destNode != TraceExecutor.nodeMapping(srcNode)){
      //this.reqVV = finalAcceptVV;
      curVV = (AcceptVV)mapManager.getUraNode().getCurrentVV();
      connected = true;
      setSubscribeInvalSucceeded();
      this.reqVV = mapManager.addConnection(nId/*, (this.myNodeId == trustedNode)*/);
      AcceptVV lpvv = (AcceptVV)mapManager.getUraNode().getCore().getLpVV(mapManager.ss);
      this.waitForCallback();
      AcceptVV newlpvv = (AcceptVV)mapManager.getUraNode().getCore().getLpVV(mapManager.ss);
      System.out.println("previous lpvv " + lpvv + " currnet lpvv " + newlpvv);
      if(lpvv.includes(newlpvv)){
        System.out.println("curVV "  + curVV + " other node cvv"  + finalAcceptVV);
      }
    } else {
      return;
    }

    // Do termination 

    mapManager.removeConnection(nId);
    
    destSet.remove(new Integer(destNode));
    //this.waitForCallback();
    this.waitForConnectTermination();
  }
  public void processREAD(long time, int srcNode, Scanner scanner){
    System.out.println("PROCESSREAD command received at " + srcNode);
    String obj = scanner.next();
    if(!obj.startsWith("/")){
      obj = "/" + obj;
    }
    ObjId oid=new ObjId(obj);
    Object data = irisNode.read(oid);
    System.out.println("at node " + irisNode + " Object " + oid + " has value " + data);
  }
  
  public void processDROP(long time, int srcNode, Scanner scanner, AcceptStamp dropAS){
    if(!irisNode.getLogTest().dropWrite(dropAS)){
      System.err.println("DROP FAILED");
    }
    curVV = irisNode.getCurrentVV();
  }
  
  public void processUPDATE(long time, int srcNode, Scanner scanner){
    System.out.println("PROCESSUPDATE command received at " + srcNode);    
    String obj = scanner.next();
    String data = scanner.next();
    if(!obj.startsWith("/")){
      obj = "/" + obj;
    }
    assert(obj != null);
    ObjId objId = new ObjId(obj);
    
    if(useIrisNode){      
      if(irisNode.canWrite()){
        irisNode.write(objId, new IrisDataObject(data));
      }
      curVV = irisNode.getCurrentVV();
      return;
    }
    
    if(randomWrite){
      String[] objs = IS.split(":");
      obj = objs[r.nextInt(objs.length)];

      int maxRetry = objs.length * 3;
      VV cvv = mapManager.getUraNode().getCurrentVV();      
      AcceptVV lpvv = mapManager.getUraNode().getCore().getLpVV(SubscriptionSet.makeSubscriptionSet(obj));
      lpvv = lpvv.dropNegatives();
      int retry = 0;
      while (cvv.isAnyPartGreaterThan(lpvv)){
        if(retry > maxRetry){
          obj = "/special";
          System.out.println("Max retrial reached.. Use special obj");
        } else {
          obj = objs[r.nextInt(objs.length)];
        }
        objId = new ObjId(obj);
        lpvv = mapManager.getUraNode().getCore().getLpVV(SubscriptionSet.makeSubscriptionSet(obj));
        //System.out.println("OBJ:" + objId + ", cvv: "+cvv+", lpvv: "+lpvv);
        retry++;

      }
    }else if(repeatedRandomWrites){
      Random r = new Random();
      String[] objs = IS.split(":");
      if(numWrites == writeCount){
        obj = objs[r.nextInt(objs.length)];
        lastWrittenObj = obj;
        numWrites=1;
        System.out.println("writing " + obj);
      }else{
        obj = lastWrittenObj;
        System.out.println("writing " + obj);
        numWrites++;
      }

    }
    
    
    assert(data != null);
    byte val[] = new byte[1];
    val[0] = Byte.parseByte(data);
    try{
	for(int j = 0; j < writeCount; j++){
	    mapManager.getLocalInterface().write(objId, 0, val.length, val, false);
	}
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    System.out.println("PROCESSUPDATE command finished at " + srcNode);
    curVV = (AcceptVV)mapManager.getUraNode().getCurrentVV();
  }
  public void processSETLIVENESSFILTER(int filterType){
    mapManager.livenessFilterType = filterType;
  }

  synchronized public void waitForConnectTermination(){
    System.out.println("waitForConnectionTermination called");
    while(connected){
      try{
        this.wait(5000);
      }catch(InterruptedException e){
        e.printStackTrace();
      }
    }
   
  }

  synchronized public void connectionTerminated(){
      connected = false;
      notifyAll();
  }
  
  synchronized public void informSubscribeInvalSucceeded(){
    this.subscribeInvalSucceeded = true;
    notifyAll();
  }
  
  synchronized public void setSubscribeInvalSucceeded(){
    this.subscribeInvalSucceeded = false;
  }
  
  
  
  synchronized public void waitForCallback() {
    System.out.println("waitForCallback called");
    long start = System.currentTimeMillis();
    while(!this.subscribeInvalSucceeded && !mapManager.cpfailure){
      //while(!curVV.includes(reqVV) && !mapManager.cpfailure){
      try{
        this.wait(5000);
      }catch(InterruptedException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
      System.out.println("wait for callback woke up: curVV " +curVV + " reqVV " + reqVV + " " );
      //System.out.println("realCVV:"+ mapManager.getUraNode().getCurrentVV()); //caution: can cause deadlock
    }
    mapManager.cpfailure = false;
    long end = System.currentTimeMillis();
    System.out.println("waitForCallback returned");
    System.out.println("Sync time: " + (end-start));

    
  }
  
  /**
   * @param args: nodeId, server port, serverHost, config file
   */
  public static void main(String[] args){
    if(args[0].equals("-createConfig")){
      // path, number of nodes,  baseport, baseip, instances per host,
      if(args.length == 4){
        makeDummyConfig(args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
      }else if(args.length == 5){
        makeDummyConfig(args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]), args[4], 1);
      }else{
        assert args.length == 6;
        makeDummyConfig(args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]), args[4], Integer.parseInt(args[5]));
      }
    }else if(args[0].equals("-createHostsConfig")){
      // path, number of nodes,  baseport, hostsFile
      BufferedReader br = null;
        try{
          FileReader f = new FileReader(args[4]);
          br =  new BufferedReader(f);
        }catch(FileNotFoundException e){
          // TODO Auto-generated catch block
          e.printStackTrace();
          assert false;
        }
       makeDummyConfig(args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]), br);
      
    }else{
      assert args.length >= 3;
      int nodeId = Integer.parseInt(args[0]);
      int serverPort = Integer.parseInt(args[1]);
      String serverHost = args[2];
      TraceListener tl;
      if(args.length <= 3){
        tl = new TraceListener(serverPort, serverHost, nodeId);
        tl.start();
      }else{
        tl = new TraceListener(serverPort, serverHost, nodeId, args[3]);
        tl.start();
     }
    }

  }
  
  protected static void  makeDummyConfig(String path, int numNodes, int basePort){
    String ip="localhost";
    String []ipArray = new String[numNodes];
    for(int i = 0; i < numNodes; i++){
      ipArray[i] = "localhost";
    }
    makeDummyConfig(path, numNodes, basePort, ipArray);
  }
  
  protected static void  makeDummyConfig(String path, int numNodes, int basePort, String baseName, int numInstances){
    String ip=baseName;
    String []ipArray = new String[numNodes];
    for(int i = 0; i < numNodes; i++){
      ipArray[i] = baseName+((i/numInstances)+1);
    }
    makeDummyConfig(path, numNodes, basePort, ipArray);
  }
  
  protected static void  makeDummyConfig(String path, int numNodes, int basePort, BufferedReader br){
    String[] ipArray = new String[numNodes];
    int counter = 0;
    String line;
    try{
      while((line = br.readLine())!=null){
        ipArray[counter++] = line;
        if(counter == numNodes){
          break;
        }
      }
      makeDummyConfig(path, numNodes, basePort, ipArray);
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
  }
  
  protected static void  makeDummyConfig(String path, int numNodes, int basePort, String []ip){

    Config.createEmptyConfig();
    int DUMMY_NODE_ID = 0;
    NodeId id;
    int ii;
    for(ii = 0; ii < numNodes; ii++){
      basePort += 20;
      id = new NodeId(DUMMY_NODE_ID + ii);
      Config.addOneNodeConfig(id, ip[ii], basePort++, basePort++, basePort++, basePort++, basePort++,
                            "/tmp" + File.separatorChar + "tmp.trace"+ii+".db",
                            "/*",
                            -1L,
                            ip[ii],
                            basePort++,
                            basePort++,
                            -1, 
                            Config.CACHE_SIZE_BYTES_DEFAULT,
                            Config.MAX_LOG_DISK_SIZE_BYTES,
                            Config.MAX_LOG_MEM_SIZE_BYTES);

    }


    Config.writeToFile(path);
  }


}
