create table personconnectivity( person_oid1 int(11), person_oid2 int(11), starttime timestamp, endtime timestamp, primary key(person_oid1, person_oid2, starttime, endtime));

insert into personconnectivity (person_oid1, person_oid2, starttime, endtime) select d1.person_oid, d2.person_oid, d1.starttime, d1.endtime from devicespan d1, devicespan d2 where d1.device_oid=d2.oid;

alter table personconnectivity add primary key(person_oid1, person_oid2, starttime, endtime);

reate table callinfo (call_oid int(11), person_oid int(11), time timestamp, incoming boolean, celltower_oid int(11)); 

alter table callinfo add primary key(call_oid, person_oid, time);

create table map(calltype enum('Incoming','Missed Call','Outgoing'), incoming boolean);

insert into map values('Incoming', 1);
insert into map values('Missed Call', 1);
insert into map values('Outgoing', 0);

insert into callinfo select call1.oid, call1.person_oid, call1.starttime, m.incoming, tower.celltower_oid from callspan call1, cellspan tower, map m where call1.starttime >= tower.starttime and call1.starttime <= tower.endtime and tower.person_oid = call1.person_oid and m.calltype = call1.direction;

create table logtable(commandtype enum('STARTNODE', 'KILLNODE', 'SETINTERESTSET', 'TERMINATECONNECTION', 'STARTCONNECTION', 'UPDATE'), time timestamp, person_oid int(11), other varchar(256));

insert into logtable (select 6, time, person_oid,CONCAT(celltower_oid, ' ', incoming) from callinfo);    

create table commandmap(com enum('STARTNODE','KILLNODE','SETINTERESTSET','TERMINATECONNECTION','STARTCONNECTION','UPDATE'), value int(1));

select CONCAT(value, ' ', time, ' ', person_oid, ' ', other) from logtable, commandmap where com = commandtype order by time;

echo "select CONCAT(value, ' ', person_oid, ' ', other) from logtable, commandmap where com = commandtype order by time;"|mysql5 -u root trace 