package code.security.holesync;

import code.NodeId;
import code.Immutable;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.SecureCheckpoint;
import code.security.SecurePreciseInv;
import code.security.ahs.AHSEntry;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class Hole implements Immutable, Comparable, Externalizable{

  final private NodeId nodeId;
  final private Range range;

  public Hole(){
    nodeId = null;
    range = null;
  }
  
  public Hole(NodeId n, Range r){
    nodeId = n;
    range = r;
  }
  
  public int hashCode(){
    return nodeId.hashCode() + range.hashCode();
  }
  
  public boolean equals(Object o){
    if(!(o instanceof Hole)){
      return false;
    }else{
      Hole other = (Hole)o;
      return nodeId.equals(other.nodeId) && range.equals(other.range);
    }
  }

  public int compareTo(Object o){
    Hole h;
    if(!(o instanceof Hole)){
      throw new ClassCastException("Invalid object type "  + o.getClass());
    }else{
      h = (Hole)o;
    }
    if (h.range.getEnd() > range.getEnd()){
      return -1;
    }else if(h.range.getEnd() < range.getEnd()){
      return 1;
    }else{
      if(!h.getNodeId().equals(nodeId)){
        return h.nodeId.compareTo(nodeId);
      }else{
        return new Long(h.range.getStart()).compareTo(range.getStart());
      }
    }
  }
  
  public NodeId getNodeId(){
    return nodeId;
  }

  public Range getRange(){
    return range;
  }

    public String toString(){
	return "Hole("+nodeId+", " + range + ")";
    }
  
  public void writeExternal(ObjectOutput out) throws IOException{
    if(SangminConfig.forkjoin){
      out.writeObject(nodeId);
    } else {
      out.writeLong(nodeId.getIDint());
    }
    out.writeLong(range.getStart());
    out.writeLong(range.getEnd());
    
  }

  public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException{
    try{

      NodeId n;
      if(SangminConfig.forkjoin){
        n = (BranchID)in.readObject();
      } else {
        n = new NodeId(in.readLong());
      }
      
      Range r = new Range(in.readLong(), in.readLong());

      Field[] f = new Field[2];

      try{

        f[0] = Hole.class.getDeclaredField("nodeId");
        f[1] = Hole.class.getDeclaredField("range");


      }catch(NoSuchFieldException ne){
        System.err.println(ne.toString());
        ne.printStackTrace();
        System.exit(-1);

      }

      try{
        AccessibleObject.setAccessible(f, true);
      } catch (SecurityException se){
        System.err.println(se.toString());
        se.printStackTrace();
        System.exit(-1);
      }
      try{
        f[0].set(this, n);
        f[1].set(this, r);


      }catch(IllegalArgumentException ie){
        System.err.println(ie.toString());
        ie.printStackTrace();
        System.exit(-1);
      }catch(IllegalAccessException iae){
        System.err.println(iae.toString());
        iae.printStackTrace();
        System.exit(-1);
      }

      try{
        AccessibleObject.setAccessible(f, false);
      } catch (SecurityException se){
        System.err.println(se.toString());
        se.printStackTrace();
        System.exit(-1);
      }

    }catch(IOException e){
      System.out.println(e);
      e.printStackTrace();
      throw e;
    }

  }
}
