package code.security.holesync;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Externalizable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

import code.AcceptVV;
import code.GeneralInv;
import code.HierInvalTarget;
import code.InvalTarget;
import code.LatencyWatcher;
import code.NodeId;
import code.SubscriptionSet;
import code.security.SecureCheckpoint;
import code.security.SecurePreciseInv;
import code.security.ahs.AHS;
import code.security.ahs.AHSEntry;
import code.security.ahs.NodeAHSTuple;

/**
 * contains the updates needed to make a hole precise
 * @author princem
 *
 */
public class HoleFiller implements Externalizable{

  private LinkedList invals;

  public HoleFiller(){
    invals = new LinkedList();
  }

  public void add(Object o){
    invals.addLast(o);
  }

  public final LinkedList getInvals(){
    return invals;
  }

  public int getSize(){
    return invals.size();
  }

    public String toString(){
	return "HoleFiller("+invals+")";
    }

  public void writeExternal(ObjectOutput out) throws IOException{

    int size = this.invals.size();
    out.writeInt(size);

    for(Object o : this.invals){
      if( o instanceof SecurePreciseInv ){
        SecurePreciseInv spi = (SecurePreciseInv)o;

        out.writeBoolean(true); // true -> SecurePreciseInv
        spi.writeExternal(out);
        //out.writeObject(spi);
      }else{
        assert(o instanceof AHSEntry);
        //simply apply the hashMap and return false if it fails
        out.writeBoolean(false); // true -> SecurePreciseInv

        ((AHSEntry)o).writeExternal(out);

      } // end of else (end of sending NodeAHSTuple)

    } // end of orderedUpdateList


  }

  public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException{
    try{

      int orderedListSize = in.readInt();
      LinkedList list = new LinkedList();
      for(int i=0; i<orderedListSize; i++){
        boolean isPreciseInv = in.readBoolean();
        if(isPreciseInv){
          SecurePreciseInv spi = null;
          try{
            //spi = (SecurePreciseInv)in.readObject();
            spi = new SecurePreciseInv();
            spi.readExternal(in);
          }catch(IOException e){
            System.out.println(e.toString());
            throw e;
          }

          list.addLast(spi);
        }else{
          AHSEntry _ahsEntry = new AHSEntry();
          _ahsEntry.readExternal(in);
          list.addLast(_ahsEntry);               
        }            

      }

      Field[] f = new Field[1];

      try{

        f[0] = HoleFiller.class.getDeclaredField("invals");

      }catch(NoSuchFieldException ne){
        System.err.println(ne.toString());
        ne.printStackTrace();
        System.exit(-1);

      }

      try{
        AccessibleObject.setAccessible(f, true);
      } catch (SecurityException se){
        System.err.println(se.toString());
        se.printStackTrace();
        System.exit(-1);
      }
      try{
        f[0].set(this, list);

      }catch(IllegalArgumentException ie){
        System.err.println(ie.toString());
        ie.printStackTrace();
        System.exit(-1);
      }catch(IllegalAccessException iae){
        System.err.println(iae.toString());
        iae.printStackTrace();
        System.exit(-1);
      }

      try{
        AccessibleObject.setAccessible(f, false);
      } catch (SecurityException se){
        System.err.println(se.toString());
        se.printStackTrace();
        System.exit(-1);
      }

    }catch(IOException e){
      System.out.println(e);
      e.printStackTrace();
      throw e;
    }

  }
  
  public Range specialReadExternal(ObjectInput in) throws IOException, ClassNotFoundException{
    long min = Long.MAX_VALUE, max = Long.MIN_VALUE;
    try{

      int orderedListSize = in.readInt();
      LinkedList list = new LinkedList();
      for(int i=0; i<orderedListSize; i++){
        boolean isPreciseInv = in.readBoolean();
        if(isPreciseInv){
          SecurePreciseInv spi = null;
          try{
            spi = new SecurePreciseInv();
            spi.readExternal(in);
            min = (min > spi.getEnd())?spi.getEnd():min;
            max = (max < spi.getEnd())?spi.getEnd():max;
          }catch(IOException e){
            System.out.println(e.toString());
            throw e;
          }

          list.addLast(spi);
        }else{
          AHSEntry _ahsEntry = new AHSEntry();
          _ahsEntry.readExternal(in);
          min = (min > _ahsEntry.getStartTS())?_ahsEntry.getStartTS():min;
          max = (max < _ahsEntry.getEndTS())?_ahsEntry.getEndTS():max;
          list.addLast(_ahsEntry);               
        }            

      }

      Field[] f = new Field[1];

      try{

        f[0] = HoleFiller.class.getDeclaredField("invals");

      }catch(NoSuchFieldException ne){
        System.err.println(ne.toString());
        ne.printStackTrace();
        System.exit(-1);

      }

      try{
        AccessibleObject.setAccessible(f, true);
      } catch (SecurityException se){
        System.err.println(se.toString());
        se.printStackTrace();
        System.exit(-1);
      }
      try{
        f[0].set(this, list);

      }catch(IllegalArgumentException ie){
        System.err.println(ie.toString());
        ie.printStackTrace();
        System.exit(-1);
      }catch(IllegalAccessException iae){
        System.err.println(iae.toString());
        iae.printStackTrace();
        System.exit(-1);
      }

      try{
        AccessibleObject.setAccessible(f, false);
      } catch (SecurityException se){
        System.err.println(se.toString());
        se.printStackTrace();
        System.exit(-1);
      }

    }catch(IOException e){
      System.out.println(e);
      e.printStackTrace();
      throw e;
    }

    return new Range(min, max);
  }
}
