package code.security.holesync;

import code.Immutable;

import java.io.Serializable;

public class Range implements Comparable, Immutable, Serializable{
  private long start;
  private long end;
  
  public Range(long start, long end){
    this.start = start;
    this.end = end;
  }
  
  public boolean contains(long r){
    return r>= start && r <= end;
  }
  
  public boolean contains(Range r){
    return contains(r.start) && contains(r.end);
  }
  
  public long getStart(){
    return start;
  }
  
  public long getEnd(){
    return end;
  }
  
  public boolean equals(Object o){
    if(!(o instanceof Range)){
      return false;
    }else{
      Range other = (Range)o;
      return (start == other.start) && (end == other.end); 
    }
  }
  
  public int compareTo(Object o){
    Range r;
    if(!(o instanceof Range)){
      throw new ClassCastException("Invalid object type "  + o.getClass());
    }else{
      r = (Range)o;
    }
    if (start < r.start){
      return -1;
    }else if(start == r.start && end == r.end){
      return 0;
    }else{
      return 1;
    }
  }
  
  public int hashCode(){
    return new Long(start).hashCode() + (int)1.1*(new Long(end).hashCode()) + "Range".hashCode();
  }
  
  public String toString(){
    return "[" + start + ", " + end + "]"; 
  }
}
