package code.security.holesync.filter;

import code.ImpreciseInv;
import code.NodeId;
import code.PreciseInv;
import code.security.ahs.AHSEntry;

import java.util.Collection;
import java.util.LinkedList;

public class AndFilter implements Filter{

  final Collection<Filter> filters;
  
  public AndFilter(Collection<Filter> filters){
    this.filters = filters;
  }
  
  public LinkedList<Attribute> getAttribute(){
    LinkedList<Attribute> attrs = new LinkedList<Attribute>();
    for(Filter f: filters){
      attrs.addAll(f.getAttribute());
    }
    return attrs;
  }

  public boolean isPresent(PreciseInv pi){
    boolean res = true;
    for(Filter f: filters){
      res = (res && f.isPresent(pi));
    }
    return res;
  }

  public boolean isPresent(ImpreciseInv ii){
    boolean res = true;
    for(Filter f: filters){
      res = (res && f.isPresent(ii));
    }
    return res;
  }
  
  public boolean isPresent(NodeId nodeId, AHSEntry ahsEntry){
    boolean res = true;
    for(Filter f: filters){
      res = (res && f.isPresent(nodeId, ahsEntry));
    }
    return res;
  }

}
