package code.security.holesync.filter;

import code.PreciseInv;
import code.ImpreciseInv;
import java.util.LinkedList;
import java.io.Serializable;
import code.security.ahs.AHSEntry;
import code.NodeId;
import code.Immutable;

public interface Filter extends Immutable, Serializable{

  /**
   * Attribute is used to appropriately summarize a collection of updates
   * @author princem
   *
   */
  public enum Attribute{SubscriptionSet, LivenessFilter};

  LinkedList<Attribute> getAttribute();
  
  /**
   * returns whether this inval contains any update present (or accepted) by the filter?
   * @param pi
   * @return
   */
  boolean isPresent(PreciseInv pi);
  
  boolean isPresent(ImpreciseInv ii);
  
  boolean isPresent(NodeId nodeId, AHSEntry ahsEntry);

}
