package code.security.holesync.filter;

import java.util.LinkedList;

import code.ImpreciseInv;
import code.PreciseInv;
import code.SubscriptionSet;
import code.NodeId;

import code.security.ahs.AHSEntry;

public class SubscriptionSetFilter implements Filter{

  private SubscriptionSet ss;
  
  public SubscriptionSetFilter(SubscriptionSet ss){
    this.ss = ss;
  }
  
  public LinkedList<Attribute> getAttribute(){
    LinkedList<Attribute> attr = new LinkedList<Attribute>();
    attr.add(Attribute.SubscriptionSet);
    return attr;
  }

  public boolean isPresent(PreciseInv pi){
    // TODO Auto-generated method stub
    return pi.getInvalTarget().intersects(ss);
  }

  public boolean isPresent(ImpreciseInv ii){
    // TODO Auto-generated method stub
    return ii.getInvalTarget().intersects(ss);
  }
  
  public boolean isPresent(NodeId nodeId, AHSEntry ahsEntry){
    // TODO Auto-generated method stub
    return ahsEntry.getInvalTarget().intersects(ss);
  }

  public boolean equals(Object o){
    if(!(o instanceof SubscriptionSetFilter)){
      return false;
    }else{
      SubscriptionSetFilter ssf = (SubscriptionSetFilter)o;
      return ss.equals(ssf.ss);
    }
  }
  
  public int hashCode(){
    return ss.hashCode() + "SubscriptionSetFilter".hashCode();
  }
  
  public String toString(){
    return "SSFilter: " + ss.toString();
  }
}
