package code.security.holesync.unit;

import java.security.PrivateKey;
import java.security.PublicKey;

import code.*;
import code.security.*;
import code.security.ahs.AHS;
import code.security.ahs.AHSEntry;
import code.security.ahs.AHSMap;
import code.security.ahs.DVVMap;
import code.security.ahs.DependencyVV;
import code.security.ahs.ImpreciseTreeNode;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;
import code.security.ahs.UnmatchingTreeNodeException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import java.util.Vector;

public class RootListUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  AHSMap ahsMap = null;
  AHSMap copyAHSMap = null;
  RootList rootList = null;
  
  PrivateKey privKey;
  PublicKey pubKey;
  NodeId nodeId;
  
  byte[] buffer;
  byte[] buffer2;
  
  Vector invals = new Vector();


  public void testAsAHS(){
    
    try{
      applyImprecise();
    }catch (Exception e){
      e.printStackTrace();
      fail("got exception");
    }
    
    AHS ahs;
    AHSEntry ahsEntry;
    ahs = rootList.asAHS(10);
    
    ahsEntry = ahs.elementAt(ahs.size()-1);
    if( ahsEntry.getEndTS() != 9 ){
      fail("asAHS");
    }
    
    ahs = rootList.asAHS(8);
    ahsEntry = ahs.elementAt(ahs.size()-1);
    if( ahsEntry.getEndTS() != 8 ){
      System.out.println("ahs size:"+ahs.size());
      System.out.println("start :"+ahsEntry.getStartTS());
      System.out.println("end :"+ahsEntry.getEndTS());
      fail("asAHS");
    }
    
    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);
    // Now we make imprecise iTn precise by applying precise
    // tree node from 10 to 19
    for(int i = 10; i<20; i++){
      
      SecurePreciseInv spi =
        (SecurePreciseInv)invals.get(i);
      try{
        rootList.applySecurePreciseInv(spi, ahsMap);
      } catch (Exception e){
        e.printStackTrace();
        fail("exception" + e);
      }
    }
    
    ahs = rootList.asAHS(10);
    ahsEntry = ahs.elementAt(ahs.size()-1);
    if( ahsEntry.getEndTS() != 10 ){
      fail("asAHS");
    }

  }

  private void applyImprecise() throws Exception {
    InvalTarget invTarget = new ObjInvalTarget(new ObjId("/rand4"), 5, 10);
    
    AHS ahs = copyAHSMap.getRootList(nodeId).createAHS(8, 11);
    assert ahs.size() == 1;
    ahsMap.applyAHS(nodeId, ahs, null);
    
  }
  
  public void testApplyImprecise(){
    // by setUp(), we already have 0-9 precise treenodes
    
    AHSMap newAHSMap = new AHSMap();
    for(int i = 0; i < 10; i++)
    {
      try{
        newAHSMap.applySecurePreciseInv((SecurePreciseInv)invals.get(i));
      }catch(UnmatchingTreeNodeException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }
    // apply three imprecise tree nodes 8-11, 12-13 and 0-31
    InvalTarget invTarget = new ObjInvalTarget(new ObjId("/rand4"), 5, 10);
    try{      

      AHSEntry ahsEntry = copyAHSMap.getRootList(nodeId).createAHS(8, 11).elementAt(0);
      ImpreciseTreeNode itn = new ImpreciseTreeNode(ahsEntry, null, nodeId);        
      newAHSMap.getRootList(nodeId).applyTreeNode(itn);

      AHSEntry ahsEntry2 = copyAHSMap.getRootList(nodeId).createAHS(12, 13).elementAt(0);

      ImpreciseTreeNode itn2 = new ImpreciseTreeNode(ahsEntry2, null, nodeId);
      newAHSMap.getRootList(nodeId).applyTreeNode(itn2);

      AHSEntry ahsEntry3 = copyAHSMap.getRootList(nodeId).createAHS(0, 31).elementAt(0);

      ImpreciseTreeNode itn3 = new ImpreciseTreeNode(ahsEntry3, null, nodeId);
      newAHSMap.getRootList(nodeId).applyTreeNode(itn3);

    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }
    
    TreeNode t = newAHSMap.getRootList(nodeId).getTreeNodeTS(11);
    TreeNode t1 = t.getNext();
    if(t1.getStartTS() != 12 || t1.getEndTS() != 13){
      fail("second imprecise inv is missing");
    }
    
    t = newAHSMap.getRootList(nodeId).getTreeNodeAfter(7);
    if(t.getStartTS() != 8 || t.getEndTS() !=11){
      fail("..");
    }
    
    
    // Now make imprecise tree node that spans 8-11 precise 
    // (currently 0 .. 9 are precise)
    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);
    
    try{
      for(int i=10; i < 12; i++){
        DependencyVV dvv = new DependencyVV();
        dvv.put(nodeId, i-1);

        SecurePreciseInv spi =
          (SecurePreciseInv)invals.get(i);

        newAHSMap.getRootList(nodeId).applySecurePreciseInv(spi, newAHSMap);
      }    
    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }
    
    for(int i=7; i<11; i++){
      t = newAHSMap.getRootList(nodeId).getTreeNodeAfter(i);
      if(t instanceof ImpreciseTreeNode || t.getStartTS() != i+1 || t.getEndTS() != i+1){
        fail("....");
      }
    }
    
    t = newAHSMap.getRootList(nodeId).getTreeNodeTS(11);
    t = t.getNext();
    if(t.getStartTS() != 12 || t.getEndTS() != 13){
      fail("....");
    }
        
    try{
      // Apply imprecise Inval(0-15)
      DVVMap dvvMap = new DVVMap();
      AHSEntry ahsEntry4 = copyAHSMap.getRootList(nodeId).createAHS(0, 15).elementAt(0);
      ImpreciseTreeNode itn4 = new ImpreciseTreeNode(ahsEntry4, null, nodeId);
      newAHSMap.getRootList(nodeId).applyTreeNode(itn4);
      // Apply imprecise Inval(16-31)
      AHSEntry ahsEntry5 = copyAHSMap.getRootList(nodeId).createAHS(16, 31).elementAt(0);
      ImpreciseTreeNode itn5 = new ImpreciseTreeNode(ahsEntry5, null, nodeId);
      newAHSMap.getRootList(nodeId).applyTreeNode(itn5);
    }catch(Exception e){
      e.printStackTrace();
      fail("Got Exception");
    }
    
    // rootList should contain only one precise TreeNode now
    if(newAHSMap.getRootList(nodeId).size() != 1){
      fail("...");
    }    
    t = newAHSMap.getRootList(nodeId).getDummyNode();
    t = t.getNext();
    if(t.getEndTS() != 15){
      fail("");
    }
    
    t = t.getNext();
    if(t.getStartTS() != 16 || t.getEndTS() != 31){
      fail("");
    }

       
  }
  
  public void testMakeItPrecise(){
	  /* 
	     * TBD: Insert other fixture code here
	     * e.g., this.objectUnderTest = new ClassToBeTested(...);
	     */
	    AHSMap ahsMap = new AHSMap();
	    RootList rootList = ahsMap.getRootList(nodeId);
	    
	    for(int i=0; i < 10; i++){
	      SecurePreciseInv spi =
	        (SecurePreciseInv)invals.get(i);
	    
	      try {
			ahsMap.applySecurePreciseInv(spi);
		} catch (UnmatchingTreeNodeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	    }    
	    
	    try{      

	      AHSEntry ahsEntry = copyAHSMap.getRootList(nodeId).createAHS(10, 10).elementAt(0);

	      ImpreciseTreeNode itn = new ImpreciseTreeNode(ahsEntry, null, nodeId);        
	      rootList.applyTreeNode(itn);

	      SecurePreciseInv spi =
		        (SecurePreciseInv)invals.get(10);
	      
	      try {
				rootList.applySecurePreciseInv(spi, ahsMap);
			} catch (UnmatchingTreeNodeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	      

	    }catch(Exception e){
	      e.printStackTrace();
	      fail("Got exception");
	    }
	    
  }
  
  public void testApplyAHSSecureImpreciseInv(){
    
    try{
      applyImprecise();
    }catch(Exception e){
      e.printStackTrace();
      fail("got exception");
    }
    
    if( !(rootList.size() == 2)){
      fail("Size");
    }
    
    if(!(rootList.NodeAt(1) instanceof ImpreciseTreeNode)){
      fail("no imprecise tree node in rootList");
    }
    
    ImpreciseTreeNode iTN = (ImpreciseTreeNode)rootList.NodeAt(1);
    
    if(iTN.getPrecisedRootList().getStartTS() !=8 || iTN.getPrecisedRootList().getEndTS() !=9){
      System.out.println("start:"+iTN.getStartTS());
      System.out.println("end:"+iTN.getEndTS());
      fail("precisedTreeNode is not correct");
    }           
    
    TreeNode t = rootList.getTreeNodeAfter(7);
    
    if(!(t instanceof ImpreciseTreeNode)){
      System.out.println("getLevel():"+t.getLevel());
      
      System.out.println("start:"+t.getStartTS());
      System.out.println("end:"+t.getEndTS());
      fail("7");
    }
    
  }
  
  
  
//
//  public void testApplySecurePreciseInvAHSMap(){
//    fail("Not yet implemented");
//  }
//
//  public void testCreateAHS(){
//    
//  }

  public void testGetLastTreeNodePriorTo(){
    
    if(rootList.getLastTreeNodePriorTo(5).getEndTS() != 4){
      fail("5");
    }
    
    if(rootList.getLastTreeNodePriorTo(11).getEndTS() != 9){
      fail("11");
    }
    
  }

  public void testGetTreeNodeAfter(){
    
    TreeNode t = rootList.getTreeNodeAfter(7);
    
    if( t.getLevel() != 0 || t.getStartTS() != 8 || t.getEndTS() != 8){
      System.out.println("getLevel():"+t.getLevel());
      
      System.out.println("start:"+t.getStartTS());
      System.out.println("end:"+t.getEndTS());
      fail("7 precise 1");
    }
    
    try{
      applyImprecise();
    }catch(Exception e){
      e.printStackTrace();
      fail("exception");
    }
    
    t = rootList.getTreeNodeAfter(7);
    
    if(!(t instanceof ImpreciseTreeNode)){
      System.out.println("getLevel():"+t.getLevel());
      
      System.out.println("start:"+t.getStartTS());
      System.out.println("end:"+t.getEndTS());
      fail("7");
    }
    
    // iTn is impreciseTreeNode that covers from 8 to 11
    // and its subtree has precise nodes from 8 to 9
    ImpreciseTreeNode iTn = (ImpreciseTreeNode)t;
    
    
    
    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);
    // Now we make imprecise iTn precise by applying precise
    // tree node from 10 to 19
    for(int i = 10; i<20; i++){
      
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);
      
      SecurePreciseInv spi =
        (SecurePreciseInv)invals.get(i);
      
      try{
        rootList.applySecurePreciseInv(spi, ahsMap);
      } catch (Exception e){
        fail("exception");
      }
    }
    
    t = rootList.getTreeNodeAfter(7);
    // t should be precise tree node and a leaf
    if( t.getLevel() != 0 || t.getStartTS() != 8 || t.getEndTS() != 8){
      System.out.println("getLevel():"+t.getLevel());
      
      System.out.println("start:"+t.getStartTS());
      System.out.println("end:"+t.getEndTS());
      fail("7 precise 2");
    }
    
    TreeNode tt = iTn.getNext();
    // iTn.getNext() should return a leaf whose ts is 12 
    if(tt == null || tt.getStartTS() != 12){
      System.out.println("getLevel():"+tt.getLevel());
      
      System.out.println("start:"+tt.getStartTS());
      System.out.println("end:"+tt.getEndTS());
      fail("getNext is not well adjusted after imprecise treenode becomes precise");
    }
    
    t = rootList.getLastTreeNodePriorTo(12);
    // t should be a leaf that has ts=11
    if( t.getLevel() != 0 || t.getStartTS() != 11 || t.getEndTS() != 11){
      System.out.println("getLevel():"+t.getLevel());
      
      System.out.println("start:"+t.getStartTS());
      System.out.println("end:"+t.getEndTS());
      fail("11 precise 2");
    }
    
    RootList r = rootList.clone();
    
    t = r.getLastTreeNodePriorTo(12);
    // t should be a leaf that has ts=11
    if( t.getLevel() != 0 || t.getStartTS() != 11 || t.getEndTS() != 11){
      System.out.println("getLevel():"+t.getLevel());
      
      System.out.println("start:"+t.getStartTS());
      System.out.println("end:"+t.getEndTS());
      fail("11 precise 2 on cloned on");
    }
 
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    ahsMap = new AHSMap();
    copyAHSMap = new AHSMap();
    nodeId = new NodeId(10);
    rootList = ahsMap.getRootList(nodeId);
    
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));
    
    buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);
    
    
    
    for(int i=0; i < 10; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);
            
      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand1"), 5, 10) ,
          new AcceptStamp(i, nodeId),
          new AcceptStamp(i, nodeId),
          false, dvv, sh, dh, privKey);
    
      invals.add(spi);
      ahsMap.applySecurePreciseInv(spi);
      copyAHSMap.applySecurePreciseInv(spi);
    }    
    
 // Now we make imprecise iTn precise by applying precise
    // tree node from 10 to 19
    for(int i = 10; i<40; i++){
      
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);
      
      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand1"), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);
      
      try{
        copyAHSMap.applySecurePreciseInv(spi);
        invals.add(spi);
      } catch (Exception e){
        e.printStackTrace();
        fail("exception" + e);
      }
    }
    
    
  }
  
//  
//  /*
//   * Fixtures are run before and after each test case
//   * to set up environment in which tests must run.
//   */
//  protected void setUp() throws Exception{
//    super.setUp();
//    nodeId = new NodeId(10);
//        
//    Config.readKeys();
//    privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
//    pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));
//
//    
//  }
  
  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(RootListUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "RootListUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
