package code.security.liveness;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.LinkedList;

import code.security.*;
import code.*;
import code.security.ahs.*;


/**
 * This class implements the trusted liveness server policy of accepting all updates 
 * @author princem
 *
 */
public class BlockingLivenessFilter implements LivenessFilter{
  NodeId trustedServer;
  SplitManager splitManager;
  CertificateAuthority ca;
  public boolean initialized = false;
//  public BlockingLivenessFilter(NodeId trusted, SplitManager splitManager){
//    this.trustedServer = trusted;
//    largestVV = new CounterVV();
//    this.splitManager = splitManager;
//    ca = new NoopCertificateAuthority();
//
//  }
  
  public BlockingLivenessFilter(CertificateAuthority ca){
    this.trustedServer = null;
    this.ca = ca;
  }
  
  public BlockingLivenessFilter(){
    
  }
  
//  public LinkedList<Attribute> getAttribute(){
//    LinkedList<Attribute> attr = new LinkedList<Attribute>();
//    attr.add(Attribute.LivenessFilter);
//    return attr;
//  }
  
  public void initialize(SecurityFilter sf){
    this.splitManager = sf.splitManager;
    ca.initialize(sf);
    initialized = true;
  }

  public boolean shouldAccept(SecureInv si){
    return true;
  }
  
  public LivenessFilter clone(){
    BlockingLivenessFilter blf = new BlockingLivenessFilter();
    return blf;
   }

  public boolean ensureVerifiability(VV splitVV, AHSMap ahsMap, NodeId sender){
    assert initialized;
    // in this policy we, ensure that our AHS is always linear; therefore even for ensureVerfiability, we ensure that the 
    // AHS is split at the splitVV instead of 
    VVIterator vvi = splitVV.getIterator();
    boolean verifiable = true;
    while(vvi.hasMoreElements() && verifiable){
      NodeId n = vvi.getNext();
      long ts = splitVV.getStampByIteratorToken(n);
      TreeNode tn = ahsMap.getTreeNodeTS(n, ts);
      if(tn == null || tn.getEndTS() != ts){
        verifiable = false;
      }
    }
    if(!verifiable){
      return splitManager.tryAndSplit(splitVV, sender, false);
    }else{
      return true;
    }
    //return false;
  }
  
  public boolean ensureCompatibility(VV splitVV, AHSMap ahsMap, NodeId sender){
    assert initialized;
    return splitManager.tryAndSplit(splitVV, sender, false);
    //return false;
  }
  
  public CertificateAuthority getCA(){
    assert initialized;
    return ca;
  }
  
  public boolean isPresent(PreciseInv pi){
    return true;
  }
  
  public boolean isPresent(ImpreciseInv ii){
    return true;
  }
  
  public boolean isPresent(NodeId nodeId, AHSEntry ahsEntry){
    return true;
  }
  
  public void union(LivenessFilter lf){
    
  }
  
  public void writeExternal(ObjectOutput out) throws IOException{
    
  }
  
  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{
    
    
    Field[] f = new Field[4];
    
    try{

      f[0] = BlockingLivenessFilter.class.getDeclaredField("ca");
      f[1] = BlockingLivenessFilter.class.getDeclaredField("initialized");
      f[2] = BlockingLivenessFilter.class.getDeclaredField("splitManager");
      f[3] = BlockingLivenessFilter.class.getDeclaredField("trustedServer");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);

    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, null);
      f[1].setBoolean(this, false);
      f[2].set(this, null);
      f[3].set(this, null);
      
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
    assert(in.available() == 0);
  }
}
