package code.security.liveness;

import code.*;
import code.security.*;


public interface CertificateAuthority {

	
	/**
	 * notify the certificate authority that a new update has been received 
	 * @param currentVV
	 */
	public void notifyUpdateProcessed(SecurePreciseInv pi);
	
	/**
	 * see if the currentVV > lastCertifiedVV and create a certificate if it is indeed the case
	 */
	public void createNewCertificate();
	
	public AcceptVV lastCertifiedVV();
	
	void processLivenessCertificate(LivenessCertificate lc);
	
	void initialize(SecurityFilter sf);
	
}
