package code.security.liveness;

import java.io.*;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;

import code.*;
import code.security.*;
import code.security.ahs.DependencyVV;
import code.serialization.SerializationHelper;

public class LivenessCertificate extends SecurePreciseInv implements GeneralInv, SecureInv, Externalizable, Immutable{
  final AcceptVV certifiedVV;

  

  /**
   * empty Constructor for serialization
   */
   public LivenessCertificate(){
     super();
     certifiedVV = null;
   }


   public LivenessCertificate(final ObjInvalTarget obj,
       final AcceptStamp acceptStamp_,
      final AcceptStamp rtAcceptStamp_,
      final DependencyVV dvv_,
      final SummaryHash sh_,
      final AcceptVV certifiedVV_,
      PrivateKey privKey){
     super(obj, acceptStamp_, rtAcceptStamp_, dvv_, sh_, privKey);
     this.certifiedVV = certifiedVV_;
     signature = sign(privKey);
   }
   
   public SerializationHelper obj2BytesExcludingSignature(){

     //return new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
     
     try{
       SerializationHelper serHelper = super.obj2BytesExcludingSignature(); //new SerializationHelper();
       
       serHelper.writeVV(new DependencyVV(certifiedVV));

       return serHelper;
     }catch(Exception e){
       System.out.println(e.toString());
       e.printStackTrace();
       System.exit(1);
     }

     return null;
   }
   
   public void writeExternal(ObjectOutput out) throws IOException{
     super.writeExternal(out);
     
     certifiedVV.writeExternal(out);
     
     
   }
   

   public String toString(){
     return "liveness certificate: " + certifiedVV + " super " + super.toString(); 
   }
   
   public void readExternal(ObjectInput in) 
   throws IOException, ClassNotFoundException{

     readExternalHelper(in);
     AcceptVV tmpVV = new AcceptVV();
     tmpVV.readExternal(in);
     
     Field[] f = new Field[1];
     try{

       f[0] = LivenessCertificate.class.getDeclaredField("certifiedVV");
     }catch(NoSuchFieldException ne){
       System.err.println(ne.toString());
       ne.printStackTrace();
       System.exit(-1);

     }
     try{
       AccessibleObject.setAccessible(f, true);
     } catch (SecurityException se){
       System.err.println(se.toString());
       se.printStackTrace();
       System.exit(-1);
     }
     try{
       f[0].set(this, tmpVV);
     }catch(IllegalArgumentException ie){
       System.err.println(ie.toString());
       ie.printStackTrace();
       System.exit(-1);
     }catch(IllegalAccessException iae){
       System.err.println(iae.toString());
       iae.printStackTrace();
       System.exit(-1);
     }

     try{
       AccessibleObject.setAccessible(f, false);
     } catch (SecurityException se){
       System.err.println(se.toString());
       se.printStackTrace();
       System.exit(-1);
     }
    
     assert(this.verify((PublicKey)Config.publicKeys.get(new Long(this.getCreator().getIDint())))) : "readExternal" + this;

   }


  public AcceptVV getCertifiedVV(){
    return certifiedVV;
  }
   
}
