package code.security.liveness;

import code.security.*;
import code.security.ahs.*;
import code.*;

import java.io.*;
import code.security.holesync.filter.Filter;

public interface LivenessFilter extends Externalizable{
  /**
   * returns whether this inval contains any update present (or accepted) by the filter?
   * @param pi
   * @return
   */
  boolean isPresent(PreciseInv pi);
  
  boolean isPresent(ImpreciseInv ii);
  
  boolean isPresent(NodeId nodeId, AHSEntry ahsEntry);
  
  /**
   * This function returns the application policy decision indicating whether the secure invalidate be accepted or not
   * @param si
   * @return
   */
  boolean shouldAccept(SecureInv si);
  
  /**
   * ensure that the splitVV is verifiable based on the ahsMap
   * @param splitVV
   * @param ahsMap
   * @return
   */
  boolean ensureVerifiability(VV splitVV, AHSMap ahsMap, NodeId sender);
  
  /**
   * ensure that the startTS-endTS treeNode is split at splitTS is compatible with the existing content
   * @param splitVV
   * @param ahsMap
   * @return
   */
  boolean ensureCompatibility(VV splitVV, AHSMap ahsMap, NodeId sender);
  
  CertificateAuthority getCA();
  
  void initialize(SecurityFilter sf);
  
  void union(LivenessFilter lf);
  
  public LivenessFilter clone();
}
