package code.security.unit;

import  code.Config;
import code.AcceptStamp;
import code.GeneralInv;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.InvalTarget;
import code.ObjId;
import code.NodeId;
import code.SummaryHash;
import code.security.DataHash;
import code.security.DummyPreciseInv;
import code.security.SecureCore;
import code.security.SecurePreciseInv;
import code.security.DummyPreciseInv;
import code.RMIClient;
import code.SingleWriterInval;

import java.io.File;
import code.AcceptVV;
import code.PreciseInv;
import code.ObjInvalTarget;
import code.ImmutableBytes;
import code.security.SecureInMemLogIterator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.security.SecurityFilter;
import code.security.ahs.AHS;
import code.security.ahs.AHSEntry;
import code.security.ahs.AHSMap;
import code.security.ahs.DependencyVV;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;
import code.security.ahs.UnmatchingTreeNodeException;
import code.SubscriptionSet;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.*;

import code.security.SecureRMIClient;
import code.security.holesync.FilterKnowledge;
import code.security.holesync.Range;
import code.security.holesync.filter.*;

public class NewGetLastUpdateUnit extends TestCase{
	public static final String TEST_ALL_TEST_TYPE = "UNIT";
	  
  int totalNodes = 100;
  SecureCore[] SecureCores;
  SecurityFilter[] filters;
  PrivateKey privKey;
  PublicKey pubKey;
  NodeId nodeId;
  
  private static final boolean dbg = true; 
  //create SecureCore as URANode constructor did
  boolean filterOn = true;
  boolean cleanDb = true;  // start from empty
  SecureRMIClient myRMIClient = new SecureRMIClient();
  
  int[] primes;
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
         
    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4
    
    privKey = (PrivateKey)Config.privateKeys.get(new Long(0));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(0));

    SecureCores = new SecureCore[totalNodes];
    filters = new SecurityFilter[totalNodes];
    primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23};
    
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
   
  }

    private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
                              NODE_1_IP,
                            port++,
                            port++,
                            port++,
                            port++,
                            port++,
                            "test" + File.separatorChar + "local-" + 
                            NODE_1_ID + ".db",
                            "/*",
                            -1L,
                            NODE_1_IP,
                            port++,
                            port++,
                            -1,
                            Config.CACHE_SIZE_BYTES_DEFAULT,
                            Config.MAX_LOG_DISK_SIZE_BYTES,
                            Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi
        
  }
   
  
  public void testGetLastUpdate() throws Exception{
    int i = 0;
    getLastUpdate10(i++);
    getLastUpdate0_0(i++);
    getLastUpdate5_1(i++);
    getLastUpdate5_2(i++);
    getLastUpdate10_2(new int[]{i++, i++});
    getLastUpdate10_3(new int[]{i++, i++});
    dotestApplyImprecise(i++);
    
    //    for(int x = 10; x < 30; x+= 20){
//      for(int y: primefactors(x)){
//        int[] nodeId = new int[]{i++, i++};
//        getLastUpdate10_4(nodeId, x, y);
//      }
//    }
  }
  

  
//TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
  public void getLastUpdate0_0(int nodeId)
  throws Exception{
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(ss);
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    
    
    
    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, AcceptVV.makeVVAllNegatives());
    assert lastUpdateList.isEmpty();
    
  }

  
  //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
  public void getLastUpdate10(int nodeId)
  throws Exception{
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    
    
    
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);
    }
    
    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS, new NodeId(0));
    as[1] = new AcceptStamp(endTS, new NodeId(1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    
    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
    }
    SecureCores[nodeId].close();
    
  }
  
  //TEST2: do 10 consecutive writes to 5 different objects and checks if the lastUpdateList is correct or not
  public void getLastUpdate5_1(int nodeId)
  throws Exception{
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
   

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    
    
    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
    
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i%5));
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);
    }
    
    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS, new NodeId(nodeId));
    as[1] = new AcceptStamp(endTS, new NodeId(nodeId+1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    
    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    int lastUsefulTS = 5;
    for(int i = lastUsefulTS; i < writeNum; i ++ ){
//      if(i>=5){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i%5);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
//      }else{
//        pi1 = new DummyPreciseInv(new AcceptStamp(i, new NodeId((long)nodeId)));
//
//        PreciseInv inv = lastUpdateList.get(i);
//        assert inv instanceof DummyPreciseInv;
//        assert ((DummyPreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
//        assert ((DummyPreciseInv)inv).getObjId().equals(pi1.getObjId());
//      }
    }
    SecureCores[nodeId].close();

    
  }
  
  //TEST2: do 10 consecutive writes to 5 different objects and checks if the lastUpdateList is correct or not
  public void getLastUpdate5_2(int nodeId)
  throws Exception{
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
   
    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    
    
    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
    
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i/2));
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);
    }
    
    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[3];
    as[0] = new AcceptStamp(endTS, new NodeId(nodeId));
    as[1] = new AcceptStamp(endTS, new NodeId(nodeId+1));
    as[2] = new AcceptStamp(endTS, new NodeId(nodeId+2));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    
    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum; i ++ ){
      if(i%2 == 1){
        oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i/2));
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(i, new NodeId((long)nodeId)));
  
        PreciseInv inv = lastUpdateList.get(i);
        assert inv instanceof SecurePreciseInv;
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      }
    }
    
    SecureCores[nodeId].close();

  }
  
 
  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
  // and checks if the lastUpdateList is correct or not
  // sync after 10 writes
  // sync after 5 writes
  // sync after every write
  public void getLastUpdate10_2(int[] nodeId)
  throws Exception{
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);

      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }
    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    
    
    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
    
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    int numNodes = 2;
    for(int i = 0; i < writeNum * numNodes; i ++ ){
      int nId = nodeId[i/writeNum];
      int writeCount = i % writeNum;
      oid = new ObjId("/"+nId + "/" + stage + "/" + writeCount);
      SecureCores[nId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);
    }
    
    this.syncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);
    
    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    
    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[1]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum * numNodes; i ++ ){
      int nId = nodeId[i%numNodes];
      int writeCount = i / numNodes;
      oid = new ObjId("/"+ nId + "/" + stage + "/" + writeCount);
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(i/2, new NodeId((long)nId)));
  
        PreciseInv inv = lastUpdateList.get(i);
        assert inv instanceof SecurePreciseInv;
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      
    }
    
    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    
  }
  
  
  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
  // and checks if the lastUpdateList is correct or not
  // sync after 10 writes
  // sync after 5 writes
  // sync after every write
  public void getLastUpdate10_3(int[] nodeId)
  throws Exception{
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);

      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }
    //
    //populate 1 write to node 0
    //
    int[] otherNodeId = new int[]{nodeId[1], nodeId[0]};
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    
    
    //DESC: everyone does writenum distinct writes and syncs every syncnum
    // at the end, the lastUpdate list should have all the writes
    
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 4;
    int syncNum = writeNum;
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/"+nId + "/" + stage + "/" + writeCount);
        SecureCores[nId].write(oid, offset, len, 
                            SecureCore.DEFAULT_PRIORITY, 
                            body, 
                            false, 
                            Long.MAX_VALUE);
      }
      if((writeCount+1) % syncNum == 0){
        this.syncNodes(SecureCores[nodeId[1]], SecureCores[otherNodeId[1]]);
      }
    }
    
    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    
    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[0]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    Iterator<PreciseInv> preciseIter = lastUpdateList.iterator();
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/"+ nId + "/" + stage + "/" + writeCount);
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(writeCount, new NodeId((long)nId)));
  
        assert preciseIter.hasNext();
        PreciseInv inv = preciseIter.next();
        assert inv instanceof SecurePreciseInv:lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " not instanceof SecurePreciseInv";
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp()):lastUpdateList + "check failed at " + 
        writeCount + " for inv " + inv + " pi " + pi1;
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId()):lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " pi " + pi1;
      }
    }
    
    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    
  }
  
  public void dotestApplyImprecise(int nId){
    // by setUp(), we already have 0-9 precise treenodes
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nId));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nId));
    
    Filter f = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    SubscriptionSet ss =SubscriptionSet.makeSubscriptionSet("/*");
    LinkedList<Filter> fl = new LinkedList<Filter>();
    fl.add(f);
    NodeId nodeId = new NodeId(nId);


    SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, nodeId, false, 
        new code.security.liveness.TrustedServerTraceLivenessFilter(null), fl);
    SecureCores[nId].testSkipRecoverLocalState();
    filters[nId] = SecureCores[nId].getSecurityFilter();
    
    
    AHSMap ahsMap = filters[nId].getAhsMap();
    ahsMap.addFilter(f);
    AHSMap copyAHSMap = new AHSMap();
    copyAHSMap.addFilter(f);

    LinkedList<SecurePreciseInv> invals = new LinkedList<SecurePreciseInv>();
    
    byte[] buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    byte[] buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);
    for(int i=0; i < 40; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand/"+(i/8) +"/" + (i%8)), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals.add(spi);
      try{
        copyAHSMap.applySecurePreciseInv(spi);
      }catch(UnmatchingTreeNodeException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }    
    
    for(int i = 0; i < 10; i++)
    {
      try{
        ahsMap.applySecurePreciseInv((SecurePreciseInv)invals.get(i));
        FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
        assert fk.getCVV().includes(((SecurePreciseInv)invals.get(i)).getAcceptStamp()): fk;
        assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
      }catch(UnmatchingTreeNodeException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }
    // apply three imprecise tree nodes 8-11, 12-13 and 0-31
    AHSEntry ahsEntry = null, ahsEntry2 = null , ahsEntry3 = null, ahsEntry4 = null; 
    try{      

      ahsEntry = copyAHSMap.getRootList(nodeId).createAHS(10, 11).elementAt(0);
      ahsMap.applyAHS(nodeId, new AHS(ahsEntry), null);
      FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry.getRange()): fk;
      
      ahsEntry2 = copyAHSMap.getRootList(nodeId).createAHS(12, 13).elementAt(0);
      
      ahsMap.applyAHS(nodeId, new AHS(ahsEntry2), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry2.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry2.getRange()): fk;
      
      ahsEntry3 = copyAHSMap.getRootList(nodeId).createAHS(14, 15).elementAt(0);

      ahsMap.applyAHS(nodeId, new AHS(ahsEntry3), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry3.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry3.getRange()): fk;
      
      ahsEntry4 = copyAHSMap.getRootList(nodeId).createAHS(16, 31).elementAt(0);

      ahsMap.applyAHS(nodeId, new AHS(ahsEntry4), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry4.getEndTS(), nodeId)): fk;
      assert fk.getHoles().containsKey(nodeId) && fk.getHoles().get(nodeId).contains(ahsEntry4.getRange()): fk;
      
      ahsMap.applySecurePreciseInv((SecurePreciseInv)invals.get(32));
      assert fk.getCVV().includes(((SecurePreciseInv)invals.get(32)).getAcceptStamp()): fk;
      
    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }

    // first ensure that if you are interested in everything, no imprecise invals are summarized
    LinkedList<PreciseInv> lastUpdateList = filters[nId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, filters[nId].getCurrentVV());
    System.out.println(lastUpdateList);
    
    assert lastUpdateList.contains(new DummyPreciseInv(new AcceptStamp(ahsEntry.getEndTS(), nodeId)));
    assert lastUpdateList.contains(new DummyPreciseInv(new AcceptStamp(ahsEntry2.getEndTS(), nodeId)));
    assert lastUpdateList.contains(new DummyPreciseInv(new AcceptStamp(ahsEntry3.getEndTS(), nodeId)));
    // then ensure that if you are not interested in some updates, then invals ARE summarized
   
    lastUpdateList = filters[nId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), SubscriptionSet.makeSubscriptionSet("/rand/0/*"), filters[nId].getCurrentVV());
    System.out.println(lastUpdateList);

    assert !lastUpdateList.contains(invals.get(8));
    assert !lastUpdateList.contains(invals.get(9));
    assert !lastUpdateList.contains(new DummyPreciseInv(new AcceptStamp(ahsEntry.getEndTS(), nodeId)));
    assert !lastUpdateList.contains(new DummyPreciseInv(new AcceptStamp(ahsEntry2.getEndTS(), nodeId)));
    assert !lastUpdateList.contains(new DummyPreciseInv(new AcceptStamp(ahsEntry3.getEndTS(), nodeId)));

  }
  private boolean verifyAndApplyToNode(SecureCore SecureCore, GeneralInv gi, NodeId src){
    SecurityFilter filter = SecureCore.getSecurityFilter();
    boolean ret = filter.verifyAndApply(gi, src);
    SecureCore.applyInval(gi, null);
    return ret;
  }
  
  private void assertSameLog(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    SecurityFilter dstFilter = destSecureCore.getSecurityFilter();
    SecureInMemLogIterator dstIter = dstFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert dstIter.hasNext();
      assert srcIter.next().equals(dstIter.next());
    }
    assert !dstIter.hasNext();
  }
  private void syncNodes(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert this.verifyAndApplyToNode(destSecureCore, srcIter.next(), srcSecureCore.getMyNodeId());
    }
    //reset source
    srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    
  }
  private void applyToNode(SecureCore destSecureCore, 
                             SecureCore srcSecureCore,
                             ImpreciseInv ii){
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    ImpreciseInv sii = srcFilter.createImpreciseInv(ii);
    assert destFilter.verifyAndApply(sii, srcSecureCore.getMyNodeId());
    destSecureCore.applyInval(sii, null); 
  }
  private void verifyIter(SecureInMemLogIterator iter, 
                                 long stamp,
                                 long nodeId){
    //assert iter.hasNext();
    GeneralInv gi = iter.next();
    assert gi != null;
    assert gi instanceof PreciseInv;
    PreciseInv pi = ((PreciseInv)(gi));
    assert pi.getAcceptStamp().equals(new AcceptStamp(stamp, new NodeId(nodeId))):
      pi.toString() + "expected:" + stamp +"@"+nodeId;
  }
 
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(NewGetLastUpdateUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "NewGetLastUpdateUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }
  
}

