package code.security.unit;

import  code.Config;
import code.AcceptStamp;
import code.GeneralInv;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.ObjId;
import code.NodeId;
import code.SummaryHash;
import code.security.DataHash;
import code.security.DummyPreciseInv;
import code.security.SecureCheckpoint;
import code.security.SecureCore;
import code.security.SecurePreciseInv;
import code.RMIClient;
import code.SingleWriterInval;

import java.io.File;
import code.AcceptVV;
import code.PreciseInv;
import code.ObjInvalTarget;
import code.ImmutableBytes;
import code.security.SecureInMemLogIterator;
import code.security.holesync.*;
import code.security.ahs.AHSMap;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.security.SecurityFilter;
import code.security.ahs.AHSEntry;
import code.security.ahs.DependencyVV;
import code.security.ahs.NodeAHSTuple;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;
import code.security.ahs.UnmatchingTreeNodeException;
import code.SubscriptionSet;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.*;

import code.security.ahs.AHS;
import code.security.SecureRMIClient;
import code.security.holesync.filter.*;
import code.security.liveness.*;

public class NewSecureCheckpointUnit extends TestCase{
  //public static final String TEST_ALL_TEST_TYPE = "UNIT";

  int totalNodes = 20;

  private static final boolean dbg = true; 
  //create SecureCore as URANode constructor did
  boolean filterOn = true;
  boolean cleanDb = true;  // start from empty

  SecureCore refSecureCore;
  AHSMap copyAHSMap;
  NodeId refNodeId;
  PrivateKey privKey;
  PublicKey pubKey;
  
  LinkedList<SecurePreciseInv> invals;
  
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();


    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4

    privKey = (PrivateKey)Config.privateKeys.get(new Long(0));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(0));

    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    refNodeId = new NodeId(0);
    refSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, refNodeId, false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    refSecureCore.testSkipRecoverLocalState();
    copyAHSMap = refSecureCore.securityFilter.getAhsMap();
    copyAHSMap.addFilter(ssf);

    invals = new LinkedList<SecurePreciseInv>();
    
    ObjId oid ;
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;



    //
    // populate 10 write to node 0
    //
    int writeNum = 33;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/rand/"+(i/8) +"/" + (i%8));
      refSecureCore.write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
      
      invals.add((SecurePreciseInv)refSecureCore.securityFilter.getAhsMap().getRootList(refNodeId).getTreeNodeTS(i).getInv());
    }
    
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();

  }

  private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";

    for(int i = 0; i < total; i++){

      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
          NODE_1_IP,
          port++,
          port++,
          port++,
          port++,
          port++,
          "test" + File.separatorChar + "local-" + 
          NODE_1_ID + ".db",
          "/*",
          -1L,
          NODE_1_IP,
          port++,
          port++,
          -1,
          Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES,
          Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi
    
   
    
  }


  public void testCheckpoint() throws Exception{
    int i = 1;
    checkpoint0(i++);
    i++;
    checkpoint10(i++);
    i++;// for dest
    checkpoint5_1(i++);
    i++;// for dest

    checkpoint5_2(i++);
    i++;// for dest

    checkpoint10_2(new int[]{i++, i++});
    i++;// for dest

    checkpoint10_3(new int[]{i++, i++});
    i++;// for dest
    
    dotestApplyImprecise(i++, i++);

//  for(int x = 10; x < 30; x+= 20){
//  for(int y: primefactors(x)){
//  int[] nodeId = new int[]{i++, i++};
//  checkpoint10_4(nodeId, x, y);
//  }
//  }
  }
  
//TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
  public void checkpoint0(int nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, AcceptVV.makeVVAllNegatives());

    Filter ff = new SubscriptionSetFilter(ss);
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives(), true, AcceptVV.makeVVAllNegatives()/*, false*/, 
        new BlockingLivenessFilter(), ff, new FilterKnowledge(ff));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    assertSameLog(SecureCores[nodeId], destSecureCore);

    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;

    SecureCores[nodeId].close();
    destSecureCore.close();

  }

  
  //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
  public void checkpoint10(int nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    assert SecureCores[nodeId].getCurrentVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()):SecureCores[nodeId].getCurrentVV() ;
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;



    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId));
    as[1] = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);

    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
    }


    
    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives(), true, endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    assertSameLog(SecureCores[nodeId], destSecureCore);

    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;

    SecureCores[nodeId].close();
    destSecureCore.close();

  }


  //TEST2: do 10 consecutive writes to 5 different objects and checks if the lastUpdateList is correct or not
  public void checkpoint5_1(int nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();


    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i%5));
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId));
    as[1] = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(nodeId+1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    int lastUsefulTS = 5;
    for(int i = lastUsefulTS; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i%5);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));

    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    LinkedList modifiedOrderedUpdateList = getLastUpdateList(sc, destSecurityFilter);
    
    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert modifiedOrderedUpdateList.contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    SecureCores[nodeId].close();
    destSecureCore.close();


  }


  //TEST2: do 10 consecutive writes to 5 different objects and checks if the lastUpdateList is correct or not
  public void checkpoint5_2(int nodeId)
  throws Exception{

    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i/2));
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId));
    as[1] = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(nodeId+1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum; i ++ ){
      if(i%2 == 1){
        oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i/2));
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(i, new NodeId((long)nodeId)));

        PreciseInv inv = lastUpdateList.get(i);
        assert inv instanceof SecurePreciseInv;
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      }
    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));

    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());
    LinkedList modifiedOrderedUpdateList = getLastUpdateList(sc, destSecurityFilter);
    
    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert modifiedOrderedUpdateList.contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    SecureCores[nodeId].close();
    destSecureCore.close();


  }


  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
  // and checks if the lastUpdateList is correct or not
  // sync after 10 writes
  // sync after 5 writes
  // sync after every write
  public void checkpoint10_2(int[] nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    int numNodes = 2;
    for(int i = 0; i < writeNum * numNodes; i ++ ){
      int nId = nodeId[i/writeNum];
      int writeCount = i % writeNum;
      oid = new ObjId("/"+nId + "/" + stage + "/" + writeCount);
      SecureCores[nId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    this.syncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS-1, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[1]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum * numNodes; i ++ ){
      int nId = nodeId[i%numNodes];
      int writeCount = i / numNodes;
      oid = new ObjId("/"+ nId + "/" + stage + "/" + writeCount);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i/2, new NodeId((long)nId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());

    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId[1]].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId[1]].getMyNodeId(), destSecureCore.getCurrentVV());

    LinkedList modifiedOrderedUpdateList = getLastUpdateList(sc, destSecurityFilter);
    
    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert modifiedOrderedUpdateList.contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId[1]].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId[1]].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    destSecureCore.close();

  }


  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
  // and checks if the lastUpdateList is correct or not
  // sync after 10 writes
  // sync after 5 writes
  // sync after every write
  public void checkpoint10_3(int[] nodeId)
  throws Exception{

    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    int[] otherNodeId = new int[]{nodeId[1], nodeId[0]};
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //DESC: everyone does writenum distinct writes and syncs every syncnum
    // at the end, the lastUpdate list should have all the writes

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 4;
    int syncNum = writeNum;
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/"+nId + "/" + stage + "/" + writeCount);
        SecureCores[nId].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      }
      if((writeCount+1) % syncNum == 0){
        this.syncNodes(SecureCores[nodeId[1]], SecureCores[otherNodeId[1]]);
      }
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS-1, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[0]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    Iterator<PreciseInv> preciseIter = lastUpdateList.iterator();
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/"+ nId + "/" + stage + "/" + writeCount);
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(writeCount, new NodeId((long)nId)));

        assert preciseIter.hasNext();
        PreciseInv inv = preciseIter.next();
        assert inv instanceof SecurePreciseInv:lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " not instanceof SecurePreciseInv";
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp()):lastUpdateList + "check failed at " + 
        writeCount + " for inv " + inv + " pi " + pi1;
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId()):lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " pi " + pi1;
      }
    }

    
    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId[0]].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId[0]].getMyNodeId(), destSecureCore.getCurrentVV());

    LinkedList modifiedOrderedUpdateList = getLastUpdateList(sc, destSecurityFilter);
    
    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert modifiedOrderedUpdateList.contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId[1]].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId[1]].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    destSecureCore.close();


  }
  
  public LinkedList getLastUpdateList(SecureCheckpoint chkPt, SecurityFilter securityFilter){
    LinkedList modifiedOrderedUpdateList = new LinkedList();
    for(Object o: chkPt.getOrderedUpdateList()){
      if(o instanceof NodeAHSTuple){
        NodeAHSTuple nat = (NodeAHSTuple)o;
        AHS ahs = new AHS();
        for(AHSEntry ae: nat.getAHS().getSortedListOfEntries()){
          ahs.add(securityFilter.getAHSEntryWithSH(ae));
        }
        modifiedOrderedUpdateList.add(new NodeAHSTuple(nat.getNodeId(), ahs));
      }else{
        modifiedOrderedUpdateList.add(securityFilter.getSecurePreciseInvWithSH((SecurePreciseInv)o));
      }
    }
    return modifiedOrderedUpdateList;
  }
  
  public void dotestApplyImprecise(int nId, int otherNId){
    // by setUp(), we already have 0-9 precise treenodes
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nId));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nId));
    
    Filter f = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    SubscriptionSet ss =SubscriptionSet.makeSubscriptionSet("/*");
    LinkedList<Filter> fl = new LinkedList<Filter>();
    fl.add(f);
    NodeId nodeId = new NodeId(nId);


    SecureCore secureCore = new SecureCore(new SecureRMIClient(), filterOn, cleanDb, nodeId, false, 
        new code.security.liveness.TrustedServerTraceLivenessFilter(null), fl);
    secureCore.testSkipRecoverLocalState();
    SecurityFilter securityFilter = secureCore.getSecurityFilter();
    
    SecureCore destSecureCore = new SecureCore(new SecureRMIClient(), filterOn, cleanDb, new NodeId(otherNId), false, 
        new code.security.liveness.TrustedServerTraceLivenessFilter(null), fl);
    destSecureCore.testSkipRecoverLocalState();
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();
    
    AHSMap ahsMap = securityFilter.getAhsMap();
    ahsMap.addFilter(f);

    for(int i = 0; i < 10; i++)
    {
      try{
        ahsMap.applySecurePreciseInv((SecurePreciseInv)invals.get(i));
        FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
        assert fk.getCVV().includes(((SecurePreciseInv)invals.get(i)).getAcceptStamp()): fk;
        assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
      }catch(UnmatchingTreeNodeException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }
    // apply three imprecise tree nodes 8-11, 12-13 and 0-31
    AHSEntry ahsEntry = null, ahsEntry2 = null , ahsEntry3 = null, ahsEntry4 = null; 
    try{      

      ahsEntry = copyAHSMap.getRootList(refNodeId).createAHS(10, 11).elementAt(0);
      ahsMap.applyAHS(refNodeId, new AHS(ahsEntry), null);
      FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry.getEndTS(), refNodeId)): fk;
      assert fk.getHoles().containsKey(refNodeId) && fk.getHoles().get(refNodeId).contains(ahsEntry.getRange()): fk;
      
      ahsEntry2 = copyAHSMap.getRootList(refNodeId).createAHS(12, 13).elementAt(0);
      
      ahsMap.applyAHS(refNodeId, new AHS(ahsEntry2), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry2.getEndTS(), refNodeId)): fk;
      assert fk.getHoles().containsKey(refNodeId) && fk.getHoles().get(refNodeId).contains(ahsEntry2.getRange()): fk;
      
      ahsEntry3 = copyAHSMap.getRootList(refNodeId).createAHS(14, 15).elementAt(0);

      ahsMap.applyAHS(refNodeId, new AHS(ahsEntry3), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry3.getEndTS(), refNodeId)): fk;
      assert fk.getHoles().containsKey(refNodeId) && fk.getHoles().get(refNodeId).contains(ahsEntry3.getRange()): fk;
      
      ahsEntry4 = copyAHSMap.getRootList(refNodeId).createAHS(16, 31).elementAt(0);

      ahsMap.applyAHS(refNodeId, new AHS(ahsEntry4), null);
      assert fk.getCVV().includes(new AcceptStamp(ahsEntry4.getEndTS(), refNodeId)): fk;
      assert fk.getHoles().containsKey(refNodeId) && fk.getHoles().get(refNodeId).contains(ahsEntry4.getRange()): fk;
      
      ahsMap.applySecurePreciseInv((SecurePreciseInv)invals.get(32));
      assert fk.getCVV().includes(((SecurePreciseInv)invals.get(32)).getAcceptStamp()): fk;
      
    }catch(Exception e){
      e.printStackTrace();
      fail("Got exception");
    }

    // first ensure that if you are interested in everything, no imprecise invals are summarized
    LinkedList<PreciseInv> lastUpdateList = securityFilter.getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, securityFilter.getCurrentVV());
    
    SecureCheckpoint chkPt = securityFilter.getSecureCheckpoint(AcceptVV.makeVVAllNegatives(), false, securityFilter.getCurrentVV(), 
        securityFilter.getLivenessFilter(), f, new FilterKnowledge(f));
    

    System.out.println(lastUpdateList);
    System.out.println(chkPt);
    
    assert destSecureCore.securityFilter.verifyCheckpoint(chkPt, new LinkedList<GeneralInv>(), secureCore.getMyNodeId(), 
        destSecureCore.getCurrentVV());
    
    assertSameRootList(secureCore.securityFilter.getAhsMap().getRootList(refNodeId), destSecureCore.securityFilter.getAhsMap().getRootList(refNodeId));
    
    // test whether the holes are generated and applied correctly

    //generate a checkpoint based on the refSecureCore and ensure that only holes are present

    // then ensure that if you are not interested in some updates, then invals ARE summarized
   
    FilterKnowledge fk = destSecureCore.securityFilter.getAhsMap().getKnowledge().getFilterKnowledge(f);
    AcceptVV startVV = fk.getLPVV();
    assert startVV.includes(invals.get(10).getAcceptStamp());
    assert !startVV.includes(invals.get(11).getAcceptStamp());
    chkPt = refSecureCore.securityFilter.getSecureCheckpoint(AcceptVV.incrementAll(destSecureCore.securityFilter.getCurrentVV()), false, refSecureCore.securityFilter.getCurrentVV(), 
        securityFilter.getLivenessFilter(), f, fk);
    
    assert !chkPt.getHoleFiller().isEmpty();
    for(NodeId n: fk.getHoles().keySet()){
      for(Range r: fk.getHoles().get(n)){
        assert chkPt.getHoleFiller().containsKey(new Hole(n, r));
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        int count = 0;
        for(Object o: chkPt.getHoleFiller().get(new Hole(n, r)).getInvals()){
          assert o instanceof SecurePreciseInv: o;
          count++;
          SecurePreciseInv spi = (SecurePreciseInv)o;
          min = (min > spi.getEnd())?spi.getEnd():min;
          max = (max < spi.getEnd())?spi.getEnd():max;
        }
        assert count > 1: count;
        assert min == r.getStart() && max == r.getEnd(): " min " + min + " max " + max + " range " + r;
      }
    }
    assert chkPt.getOrderedUpdateList().isEmpty(): chkPt.getOrderedUpdateList();

    
    assert destSecureCore.securityFilter.verifyCheckpoint(chkPt, new LinkedList<GeneralInv>(), secureCore.getMyNodeId(), 
        destSecureCore.securityFilter.getCurrentVV());
    
    assertSameRootList(refSecureCore.securityFilter.getAhsMap().getRootList(refNodeId), 
        destSecureCore.securityFilter.getAhsMap().getRootList(refNodeId));
   
    // next scenario when the receiver receives a checkpoint from someone who is not interested in everything
    f = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/rand/0/*:/rand/3/*"));
    fl.clear();
    fl.add(f);
    destSecureCore = new SecureCore(new SecureRMIClient(), filterOn, cleanDb, new NodeId(otherNId), false, 
        new code.security.liveness.TrustedServerTraceLivenessFilter(null), fl);
    destSecureCore.testSkipRecoverLocalState();
    destSecurityFilter = destSecureCore.getSecurityFilter();
    
    chkPt = securityFilter.getSecureCheckpoint(AcceptVV.makeVVAllNegatives(), false, securityFilter.getCurrentVV(), 
        securityFilter.getLivenessFilter(), f, new FilterKnowledge(f));
    
    System.out.println(chkPt);
    assert destSecureCore.securityFilter.verifyCheckpoint(chkPt, new LinkedList<GeneralInv>(), secureCore.getMyNodeId(), 
        destSecureCore.securityFilter.getCurrentVV());
   
    LinkedList modifiedOrderedUpdateList = getLastUpdateList(chkPt, destSecureCore.securityFilter);
    
    assert chkPt.getHoleFiller().isEmpty();
    assert modifiedOrderedUpdateList.contains(invals.get(7));
    assert !modifiedOrderedUpdateList.contains(invals.get(8));
    assert !modifiedOrderedUpdateList.contains(new NodeAHSTuple(refNodeId, new AHS(ahsEntry)));
    assert !modifiedOrderedUpdateList.contains(new NodeAHSTuple(refNodeId, new AHS(ahsEntry2)));
    assert !modifiedOrderedUpdateList.contains(new NodeAHSTuple(refNodeId, new AHS(ahsEntry3)));
    assert modifiedOrderedUpdateList.contains(new NodeAHSTuple(refNodeId, new AHS(ahsEntry4)));
    assert (!code.security.NewCheckpointFilter.reqLastPrecise || modifiedOrderedUpdateList.contains(invals.get(32)));
    
    assert modifiedOrderedUpdateList.contains(new NodeAHSTuple(refNodeId, copyAHSMap.getRootList(refNodeId).createAHS(8, 15)));
    
    fk = destSecureCore.securityFilter.getAhsMap().getKnowledge().getFilterKnowledge(f);
    startVV = fk.getLPVV();
    assert startVV.includes(invals.get(16).getAcceptStamp()): startVV;
    assert !startVV.includes(invals.get(17).getAcceptStamp()): startVV;
    chkPt = refSecureCore.securityFilter.getSecureCheckpoint(AcceptVV.incrementAll(destSecureCore.securityFilter.getCurrentVV()), false, refSecureCore.securityFilter.getCurrentVV(), 
        securityFilter.getLivenessFilter(), f, fk);
    
    assert !chkPt.getHoleFiller().isEmpty();
    assert chkPt.getHoleFiller().containsKey(new Hole(refNodeId, new Range(16, 31)));
    for(NodeId n: fk.getHoles().keySet()){
      for(Range r: fk.getHoles().get(n)){
        assert chkPt.getHoleFiller().containsKey(new Hole(n, r));
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        int count = 0;
        for(Object o: chkPt.getHoleFiller().get(new Hole(n, r)).getInvals()){
          if(o instanceof SecurePreciseInv){
          count++;
          SecurePreciseInv spi = (SecurePreciseInv)o;
          min = (min > spi.getEnd())?spi.getEnd():min;
          max = (max < spi.getEnd())?spi.getEnd():max;
          }else{
            AHSEntry aEntry = (AHSEntry)o;
            min = (min > aEntry.getStartTS())?aEntry.getStartTS():min;
            max = (max < aEntry.getEndTS())?aEntry.getEndTS():max;
          }
        }
        assert count > 1: count;
        assert min == r.getStart() && max == r.getEnd(): " min " + min + " max " + max + " range " + r;
      }
    }
   assert chkPt.getOrderedUpdateList().isEmpty(): chkPt.getOrderedUpdateList();

    
    assert destSecureCore.securityFilter.verifyCheckpoint(chkPt, new LinkedList<GeneralInv>(), secureCore.getMyNodeId(), 
        destSecureCore.securityFilter.getCurrentVV());
    
    assertSameRootList(refSecureCore.securityFilter.getAhsMap().getRootList(refNodeId), 
        destSecureCore.securityFilter.getAhsMap().getRootList(refNodeId), 7);
   
  }
 
  
  
  

  private boolean verifyAndApplyToNode(SecureCore SecureCore, GeneralInv gi, NodeId src){
    SecurityFilter filter = SecureCore.getSecurityFilter();
    boolean ret = filter.verifyAndApply(gi, src);
    SecureCore.applyInval(gi, null);
    return ret;
  }

  private void assertSameLog(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    SecurityFilter dstFilter = destSecureCore.getSecurityFilter();
    SecureInMemLogIterator dstIter = dstFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert dstIter.hasNext();
      assert srcIter.next().equals(dstIter.next());
    }
    assert !dstIter.hasNext();
  }
  
  private void assertSameRootList(RootList src, RootList dest){
    assertSameRootList(src, dest, -1);
  }

  private void assertSameRootList(RootList src, RootList dest, int count){
    TreeNode srcTreeNode = src.getDummyNode();
    TreeNode destTreeNode = dest.getDummyNode();
    assert srcTreeNode.equals(destTreeNode);
    int ctr = 0;
    while(srcTreeNode.getNext() != null && ctr != count){
      ctr++;
      assert destTreeNode.getNext() != null;
      assert srcTreeNode.equals(destTreeNode):" srcTreeNode " + srcTreeNode + " destTreeNode " + destTreeNode;
      srcTreeNode = srcTreeNode.getNext();
      destTreeNode = destTreeNode.getNext();
    }
    if(ctr != count){
      assert destTreeNode.getNext() == null;
    }
  }

  private void syncNodes(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert this.verifyAndApplyToNode(destSecureCore, srcIter.next(), srcSecureCore.getMyNodeId());
    }
    //reset source
    srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());

  }
  private void applyToNode(SecureCore destSecureCore, 
      SecureCore srcSecureCore,
      ImpreciseInv ii){
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    ImpreciseInv sii = srcFilter.createImpreciseInv(ii);
    assert destFilter.verifyAndApply(sii, srcSecureCore.getMyNodeId());
    destSecureCore.applyInval(sii, null); 
  }
  private void verifyIter(SecureInMemLogIterator iter, 
      long stamp,
      long nodeId){
    //assert iter.hasNext();
    GeneralInv gi = iter.next();
    assert gi != null;
    assert gi instanceof PreciseInv;
    PreciseInv pi = ((PreciseInv)(gi));
    assert pi.getAcceptStamp().equals(new AcceptStamp(stamp, new NodeId(nodeId))):
      pi.toString() + "expected:" + stamp +"@"+nodeId;
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(NewSecureCheckpointUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecureCheckpointUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

