package code.security.unit;

import  code.Config;
import code.AcceptStamp;
import code.GeneralInv;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.ObjId;
import code.NodeId;
import code.security.DummyPreciseInv;
import code.security.SecureCheckpoint;
import code.security.SecureCore;
import code.security.SecurePreciseInv;
import code.RMIClient;
import code.SingleWriterInval;

import java.io.File;
import code.AcceptVV;
import code.PreciseInv;
import code.ObjInvalTarget;
import code.ImmutableBytes;
import code.security.SecureInMemLogIterator;
import code.security.holesync.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.security.SecurityFilter;
import code.security.ahs.NodeAHSTuple;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;
import code.SubscriptionSet;
import java.util.*;

import code.security.ahs.AHS;
import code.security.SecureRMIClient;
import code.security.holesync.filter.*;
import code.security.liveness.*;

public class SecureCheckpointUnit extends TestCase{
  //public static final String TEST_ALL_TEST_TYPE = "UNIT";

  int totalNodes = 20;

  private static final boolean dbg = true; 
  //create SecureCore as URANode constructor did
  boolean filterOn = true;
  boolean cleanDb = true;  // start from empty

  int[] primes;
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();


    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4

    primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23};

  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();

  }

  private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";

    for(int i = 0; i < total; i++){

      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
          NODE_1_IP,
          port++,
          port++,
          port++,
          port++,
          port++,
          "test" + File.separatorChar + "local-" + 
          NODE_1_ID + ".db",
          "/*",
          -1L,
          NODE_1_IP,
          port++,
          port++,
          -1,
          Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES,
          Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi

  }


  public void testCheckpoint() throws Exception{
    int i = 0;
    checkpoint0(i++);
    i++;
    checkpoint10(i++);
    i++;// for dest
    checkpoint5_1(i++);
    i++;// for dest

    checkpoint5_2(i++);
    i++;// for dest

    checkpoint10_2(new int[]{i++, i++});
    i++;// for dest

    checkpoint10_3(new int[]{i++, i++});
    i++;// for dest
    checkpoint10_4(new int[]{i++, i++}, 4, 2);
    i++;// for dest

//  for(int x = 10; x < 30; x+= 20){
//  for(int y: primefactors(x)){
//  int[] nodeId = new int[]{i++, i++};
//  checkpoint10_4(nodeId, x, y);
//  }
//  }
  }

  private Set<Integer> primefactors(int num){
    Set<Integer> factor = new TreeSet<Integer>();
    for(int x = 0; x < primes.length; x++){
      if(num %primes[x] == 0 && num > primes[x]){
        factor.add(primes[x]);
      }
    }
    return factor;
  }
  
//TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
  public void checkpoint0(int nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, AcceptVV.makeVVAllNegatives());

    Filter ff = new SubscriptionSetFilter(ss);
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives(), true, AcceptVV.makeVVAllNegatives()/*, false*/, 
        new BlockingLivenessFilter(), ff, new FilterKnowledge(ff));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    assertSameLog(SecureCores[nodeId], destSecureCore);

    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;

    SecureCores[nodeId].close();
    destSecureCore.close();

  }

  
  //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not
  public void checkpoint10(int nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    assert SecureCores[nodeId].getCurrentVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()):SecureCores[nodeId].getCurrentVV() ;
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;



    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId));
    as[1] = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);

    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
    }


    
    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives(), true, endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    assertSameLog(SecureCores[nodeId], destSecureCore);

    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;

    SecureCores[nodeId].close();
    destSecureCore.close();

  }


  //TEST2: do 10 consecutive writes to 5 different objects and checks if the lastUpdateList is correct or not
  public void checkpoint5_1(int nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();


    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i%5));
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId));
    as[1] = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(nodeId+1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    int lastUsefulTS = 5;
    for(int i = lastUsefulTS; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i%5);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i, new NodeId((long)nodeId)));

      PreciseInv inv = lastUpdateList.get(i%5);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));

    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert sc.getOrderedUpdateList().contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    SecureCores[nodeId].close();
    destSecureCore.close();


  }


  //TEST2: do 10 consecutive writes to 5 different objects and checks if the lastUpdateList is correct or not
  public void checkpoint5_2(int nodeId)
  throws Exception{

    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCores[nodeId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecureCores[nodeId].testSkipRecoverLocalState();
    filters[nodeId] = SecureCores[nodeId].getSecurityFilter();
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i/2));
      SecureCores[nodeId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId));
    as[1] = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(nodeId+1));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum; i ++ ){
      if(i%2 == 1){
        oid = new ObjId("/"+ nodeId + "/" + stage + "/" + (i/2));
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(i, new NodeId((long)nodeId)));

        PreciseInv inv = lastUpdateList.get(i/2);
        assert inv instanceof SecurePreciseInv;
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      }
    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));

    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId].getMyNodeId(), destSecureCore.getCurrentVV());

    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert sc.getOrderedUpdateList().contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    SecureCores[nodeId].close();
    destSecureCore.close();


  }


  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
  // and checks if the lastUpdateList is correct or not
  // sync after 10 writes
  // sync after 5 writes
  // sync after every write
  public void checkpoint10_2(int[] nodeId)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 10;
    int numNodes = 2;
    for(int i = 0; i < writeNum * numNodes; i ++ ){
      int nId = nodeId[i/writeNum];
      int writeCount = i % writeNum;
      oid = new ObjId("/"+nId + "/" + stage + "/" + writeCount);
      SecureCores[nId].write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
    }

    this.syncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS-1, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[1]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    for(int i = 0; i < writeNum * numNodes; i ++ ){
      int nId = nodeId[i%numNodes];
      int writeCount = i / numNodes;
      oid = new ObjId("/"+ nId + "/" + stage + "/" + writeCount);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
          offset, 
          len),
          new AcceptStamp(i/2, new NodeId((long)nId)));

      PreciseInv inv = lastUpdateList.get(i);
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());

    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId[1]].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId[1]].getMyNodeId(), destSecureCore.getCurrentVV());

    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert sc.getOrderedUpdateList().contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId[1]].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId[1]].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    destSecureCore.close();

  }


  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
  // and checks if the lastUpdateList is correct or not
  // sync after 10 writes
  // sync after 5 writes
  // sync after every write
  public void checkpoint10_3(int[] nodeId)
  throws Exception{

    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    int[] otherNodeId = new int[]{nodeId[1], nodeId[0]};
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //DESC: everyone does writenum distinct writes and syncs every syncnum
    // at the end, the lastUpdate list should have all the writes

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    int writeNum = 4;
    int syncNum = writeNum;
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/"+nId + "/" + stage + "/" + writeCount);
        SecureCores[nId].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      }
      if((writeCount+1) % syncNum == 0){
        this.syncNodes(SecureCores[nodeId[1]], SecureCores[otherNodeId[1]]);
      }
    }

    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS-1, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[0]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    Iterator<PreciseInv> preciseIter = lastUpdateList.iterator();
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/"+ nId + "/" + stage + "/" + writeCount);
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
            offset, 
            len),
            new AcceptStamp(writeCount, new NodeId((long)nId)));

        assert preciseIter.hasNext();
        PreciseInv inv = preciseIter.next();
        assert inv instanceof SecurePreciseInv:lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " not instanceof SecurePreciseInv";
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp()):lastUpdateList + "check failed at " + 
        writeCount + " for inv " + inv + " pi " + pi1;
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId()):lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " pi " + pi1;
      }
    }

    
    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId[0]].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId[0]].getMyNodeId(), destSecureCore.getCurrentVV());

    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert sc.getOrderedUpdateList().contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId[1]].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId[1]].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    destSecureCore.close();


  }

  public void checkpoint10_4(int[] nodeId, int writeNum, int syncNum)
  throws Exception{
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureRMIClient myRMIClient = new SecureRMIClient();   

    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){

      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[nId].testSkipRecoverLocalState();
      filters[nId] = SecureCores[nId].getSecurityFilter();
    }

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);
    SecureCore destSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

    //
    //populate 1 write to node 0
    //
    int[] otherNodeId = new int[]{nodeId[1], nodeId[0]};
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;


    //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int stage = 0;
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        oid = new ObjId("/COMMON/" + stage + "/" + writeCount);
        SecureCores[nId].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);

      }
      if((writeCount+1) % syncNum == 0){
        for(int nId = 0; nId < nodeId.length; nId++){
          System.out.println("Syncing up nodes at writeCount " + writeCount);
          this.syncNodes(SecureCores[nodeId[nId]], SecureCores[otherNodeId[nId]]);
        }
      }

    }

    assertSameLog(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);
    long endTS = writeNum;
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(endTS-1, new NodeId(nodeId[0]));
    as[1] = new AcceptStamp(endTS-1, new NodeId(nodeId[1]));
    AcceptVV endVV = new AcceptVV(as);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

    LinkedList<PreciseInv> lastUpdateList = filters[nodeId[0]].getLastUpdateList(AcceptVV.makeVVAllNegatives(), ss, endVV);
    Iterator<PreciseInv> preciseIter = lastUpdateList.iterator();
    for(int writeCount = 0; writeCount < writeNum; writeCount++){
      for(int nId = nodeId[0]; nId <= nodeId[1]; nId++ ){
        if(nId == nodeId[1]){
          oid = new ObjId("/COMMON/" + stage + "/" + writeCount);
          pi1 = new PreciseInv(new ObjInvalTarget(oid, 
              offset, 
              len),
              new AcceptStamp(writeCount, new NodeId((long)nId)));

          assert preciseIter.hasNext();
          PreciseInv inv = preciseIter.next();
          assert inv instanceof SecurePreciseInv:lastUpdateList + "check failed at " + writeCount + " for inv " + inv + " not instanceof SecurePreciseInv";
          assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
          assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
        }else if((writeCount+1) % syncNum == 0 && ((writeCount + 1) < writeNum)){
          pi1 = new PreciseInv(new ObjInvalTarget(oid, 
              offset, 
              len),
              new AcceptStamp(writeCount, new NodeId((long)nId)));

          assert preciseIter.hasNext();
          PreciseInv inv = preciseIter.next();
          assert inv instanceof DummyPreciseInv;
          assert ((DummyPreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());

        }
      }
    }

    Filter sf = new SubscriptionSetFilter(ss);
    
    SecureCheckpoint sc = filters[nodeId[0]].getSecureCheckpoint(AcceptVV.makeVVAllNegatives().project(endVV), true, 
        endVV/*, false*/, new BlockingLivenessFilter(), sf, new FilterKnowledge(sf));
    assert destSecurityFilter.verifyCheckpoint(sc, new LinkedList<GeneralInv>(), SecureCores[nodeId[0]].getMyNodeId(), destSecureCore.getCurrentVV());

    for(PreciseInv pi: lastUpdateList){
      if(pi instanceof SecurePreciseInv){
        assert sc.getOrderedUpdateList().contains(pi):"Checkpoint " + sc + " doesn't contain " + pi;
      }
    }

    // compare AHS for the CVV of each node
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV endVV1 = new AcceptVV(SecureCores[nodeId[1]].getCurrentVV());
    Vector<NodeAHSTuple> srcAHS = filters[nodeId[1]].getAhsMap().generateAHS(startVV, endVV1);
    Vector<NodeAHSTuple> destAHS = destSecurityFilter.getAhsMap().generateAHS(startVV, endVV1);
    assert srcAHS.equals(destAHS):"srcAHS:" + srcAHS +  "; destAHS:" + destAHS;



    // cleanup
    for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
      SecureCores[nId].close();
    }
    destSecureCore.close();

  }



  private boolean verifyAndApplyToNode(SecureCore SecureCore, GeneralInv gi, NodeId src){
    SecurityFilter filter = SecureCore.getSecurityFilter();
    boolean ret = filter.verifyAndApply(gi, src);
    SecureCore.applyInval(gi, null);
    return ret;
  }

  private void assertSameLog(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    SecurityFilter dstFilter = destSecureCore.getSecurityFilter();
    SecureInMemLogIterator dstIter = dstFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert dstIter.hasNext();
      assert srcIter.next().equals(dstIter.next());
    }
    assert !dstIter.hasNext();
  }

  private void syncNodes(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      assert this.verifyAndApplyToNode(destSecureCore, srcIter.next(), srcSecureCore.getMyNodeId());
    }
    //reset source
    srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());

  }
  private void applyToNode(SecureCore destSecureCore, 
      SecureCore srcSecureCore,
      ImpreciseInv ii){
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    ImpreciseInv sii = srcFilter.createImpreciseInv(ii);
    assert destFilter.verifyAndApply(sii, srcSecureCore.getMyNodeId());
    destSecureCore.applyInval(sii, null); 
  }
  private void verifyIter(SecureInMemLogIterator iter, 
      long stamp,
      long nodeId){
    //assert iter.hasNext();
    GeneralInv gi = iter.next();
    assert gi != null;
    assert gi instanceof PreciseInv;
    PreciseInv pi = ((PreciseInv)(gi));
    assert pi.getAcceptStamp().equals(new AcceptStamp(stamp, new NodeId(nodeId))):
      pi.toString() + "expected:" + stamp +"@"+nodeId;
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SecureCheckpointUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecureCheckpointUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

