package code.security.unit;

import	code.Config;
import code.AcceptStamp;
import code.GeneralInv;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.ObjId;
import code.NodeId;
import code.SubscriptionSet;
import code.security.SecureCheckpoint;
import code.security.SecureCore;
import code.security.SecurePreciseInv;
import code.security.SecureRMIClient;
import code.SingleWriterInval;

import java.io.File;
import java.util.LinkedList;
import java.util.Vector;

import code.AcceptVV;
import code.PreciseInv;
import code.ObjInvalTarget;
import code.ImmutableBytes;
import code.security.SecureInMemLogIterator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.security.SecurityFilter;
import code.security.ahs.NodeAHSTuple;
import code.security.ahs.AHSMap;
import code.security.ahs.TreeNode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;

public class SecureFetchUnit extends TestCase{
	public static final String TEST_ALL_TEST_TYPE = "UNIT";
	int totalNodes = 10;

	  private static final boolean dbg = true; 
	  //create SecureCore as URANode constructor did
	  boolean filterOn = true;
	  boolean cleanDb = true;  // start from empty


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4

  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

    private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
			      NODE_1_IP,
			    port++,
			    port++,
			    port++,
			    port++,
			    port++,
			    "test" + File.separatorChar + "local-" + 
			    NODE_1_ID + ".db",
			    "/*",
			    -1L,
			    NODE_1_IP,
			    port++,
			    port++,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi
        
  }
    
    public void testFetch() throws Exception{
      int i = 0;
     
   // we are applying an imprecise inv to destCore and now sending it an update which 
      // references in the middle of the imprecise inv and the sender makes the treenode more accurate 
      
      fetch2(new int[]{i++, i++});
      i++;// for dest
    
      // we are applying an imprecise inv to destCore and now sending it an update which 
      // references in the middle of the imprecise inv and the sender doesn't know all updates for the imprecise inv 
      // hence the sender sends imprecise inv for the required range 
//      fetch1(new int[]{i++, i++});
//      i++;// for dest
   

    }

    public void fetch2(int[] nodeId)
    throws Exception{
      SecureCore[] SecureCores = new SecureCore[totalNodes];
      SecurityFilter[] filters = new SecurityFilter[totalNodes];
      SecureRMIClient myRMIClient = new SecureRMIClient();   
      SecureInMemLogIterator[] iters = new SecureInMemLogIterator[totalNodes]; 
      
      
      for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){

        SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
        LinkedList<Filter> f = new LinkedList<Filter>();
        f.add(ssf);
        SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
        SecureCores[nId].testSkipRecoverLocalState();
        filters[nId] = SecureCores[nId].getSecurityFilter();
      }

      TestSecureRMIClient rmiClientNode0 = new TestSecureRMIClient(SecureCores);
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCore destSecureCore = new SecureCore(rmiClientNode0, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

      //
      //populate 1 write to node 0
      //
      ObjId oid0, oid1;
      byte[] bdy = new byte[5];
      bdy[0] = 10;
      bdy[1] = 9;
      bdy[2] = 8;
      bdy[3] = 7;
      bdy[4] = 6;
      ImmutableBytes body = new ImmutableBytes(bdy);
      long offset = 0;
      long len = bdy.length;


      //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

      //
      // populate 10 write to node 0
      //
      PreciseInv pi1 = null;
      int stage = 0;
      int numNodes = 2;
      oid0 = new ObjId("/"+0);
      SecureCores[nodeId[0]].write(oid0, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      
      this.syncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);
      
      oid0 = new ObjId("/"+0);
      SecureCores[nodeId[0]].write(oid0, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      
      oid1 = new ObjId("/"+1);
      SecureCores[nodeId[1]].write(oid1, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);

      this.syncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);
      
      oid1 = new ObjId("/"+1);
      SecureCores[nodeId[1]].write(oid1, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);

      AcceptStamp[] as1 = new AcceptStamp[1];
      AcceptStamp[] as2 = new AcceptStamp[1];
      
      as1[0] = new AcceptStamp( 0, new NodeId(nodeId[0]));
      as2[0] = new AcceptStamp( 1, new NodeId(nodeId[0]));
      ImpreciseInv ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));

      GeneralInv sii = this.applyToNode(destSecureCore, SecureCores[nodeId[0]], ii);
      iters[0] = filters[nodeId[1]].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
      GeneralInv gi;
      // we are applying an imprecise inv to destCore and now sending it an update which 
      // references in the middle of the imprecise inv and the sender makes the treenode more accurate 
      AHSMap destAHSMap = destSecurityFilter.getAhsMap();
      TreeNode splitTreeNode = destAHSMap.getTreeNodeTS(new NodeId(nodeId[0]), 0);
      assert splitTreeNode.getStartTS() == 0:splitTreeNode;
      assert splitTreeNode.getEndTS() == 1:splitTreeNode;
      
      while(iters[0].hasNext()){
        gi = iters[0].next();
        assert gi!=null;
        if(gi instanceof SecurePreciseInv && ((SecurePreciseInv)gi).getCreator().equals(new NodeId(nodeId[1]))){
          if(dbg){
            System.out.println(" applying " + gi + " to 2 and 1");
         }
           assert verifyAndApplyToNode(destSecureCore, gi, SecureCores[nodeId[0]].getMyNodeId());
        }
      }
      splitTreeNode = destAHSMap.getTreeNodeTS(new NodeId(nodeId[0]), 0);
      assert splitTreeNode.getStartTS() == 0:splitTreeNode;
      assert splitTreeNode.getEndTS() == 0:splitTreeNode;
      
      
      // cleanup
      for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
        SecureCores[nId].close();
      }
      destSecureCore.close();

    }
    
  //TEST2: do 10 consecutive writes to 20 different objects at two nodes 
    // and checks if the lastUpdateList is correct or not
    // sync after 10 writes
    // sync after 5 writes
    // sync after every write
    public void fetch1(int[] nodeId)
    throws Exception{
      SecureCore[] SecureCores = new SecureCore[totalNodes];
      SecurityFilter[] filters = new SecurityFilter[totalNodes];
      SecureRMIClient myRMIClient = new SecureRMIClient();   
      SecureInMemLogIterator[] iters = new SecureInMemLogIterator[totalNodes]; 
      
      
      for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){

        SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
        LinkedList<Filter> f = new LinkedList<Filter>();
        f.add(ssf);
        SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
        SecureCores[nId].testSkipRecoverLocalState();
        filters[nId] = SecureCores[nId].getSecurityFilter();
      }

      TestSecureRMIClient rmiClientNode0 = new TestSecureRMIClient(SecureCores);
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCore destSecureCore = new SecureCore(rmiClientNode0, filterOn, cleanDb, new NodeId(nodeId[nodeId.length-1]+1), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecurityFilter destSecurityFilter = destSecureCore.getSecurityFilter();

      //
      //populate 1 write to node 0
      //
      ObjId oid0, oid1;
      byte[] bdy = new byte[5];
      bdy[0] = 10;
      bdy[1] = 9;
      bdy[2] = 8;
      bdy[3] = 7;
      bdy[4] = 6;
      ImmutableBytes body = new ImmutableBytes(bdy);
      long offset = 0;
      long len = bdy.length;


      //TEST1: do 10 consecutive writes to different objects and checks if the lastUpdateList is correct or not

      //
      // populate 10 write to node 0
      //
      PreciseInv pi1 = null;
      int stage = 0;
      int writeNum = 1;
      int numNodes = 2;
      oid0 = new ObjId("/"+0);
      SecureCores[nodeId[0]].write(oid0, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      
      this.syncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]]);
      
      oid0 = new ObjId("/"+0);
      SecureCores[nodeId[0]].write(oid0, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      
      oid1 = new ObjId("/"+1);
      SecureCores[nodeId[1]].write(oid1, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);

      oid1 = new ObjId("/"+1);
      SecureCores[nodeId[1]].write(oid1, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);

      AcceptStamp[] as1 = new AcceptStamp[1];
      AcceptStamp[] as2 = new AcceptStamp[1];
      
      as1[0] = new AcceptStamp( 0, new NodeId(nodeId[0]));
      as2[0] = new AcceptStamp( 1, new NodeId(nodeId[0]));
      ImpreciseInv ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));

      GeneralInv sii = this.applyToNode(destSecureCore, SecureCores[nodeId[0]], ii);
      iters[0] = filters[nodeId[1]].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
      GeneralInv gi;
      AHSMap destAHSMap = destSecurityFilter.getAhsMap();
      TreeNode splitTreeNode = destAHSMap.getTreeNodeTS(new NodeId(nodeId[0]), 0);
      assert splitTreeNode.getStartTS() == 0:splitTreeNode;
      assert splitTreeNode.getEndTS() == 1:splitTreeNode;
     
      // we are applying an imprecise inv to destCore and now sending it an update which 
      // references in the middle of the imprecise inv and the sender doesn't know of all the updates covering the imprecise inv
      while(iters[0].hasNext()){
        gi = iters[0].next();
        assert gi!=null;
        if(dbg){
           System.out.println(" applying " + gi + " to 2 and 1");
        }
        if(gi instanceof SecurePreciseInv && ((SecurePreciseInv)gi).getCreator().equals(new NodeId(nodeId[1]))){
            assert verifyAndApplyToNode(destSecureCore, gi, SecureCores[nodeId[1]].getMyNodeId());
        }
      }
      splitTreeNode = destAHSMap.getTreeNodeTS(new NodeId(nodeId[0]), 0);
      assert splitTreeNode.getStartTS() == 0:splitTreeNode;
      assert splitTreeNode.getEndTS() == 0:splitTreeNode;
     
      // cleanup
      for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){
        SecureCores[nId].close();
      }
      destSecureCore.close();

    }

    
  
  private void populateWrite(SecureCore[] SecureCores, int nodeId, int writeNum, int stage)
  throws Exception{
    ObjId oid = null;
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    SecureInMemLogIterator iter = null;
    AcceptVV excludedStartVV = SecureCores[nodeId].getCurrentVV();
    long start = excludedStartVV.getMaxTimeStamp()+1;
    iter =SecureCores[nodeId].getSecurityFilter().makeSecureInMemLogIterator(excludedStartVV);
    assert !iter.hasNext();
    GeneralInv inv = null;
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
  
  
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);

      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                                              offset, 
                                              len),
                           new AcceptStamp(start+i, new NodeId((long)nodeId)));


      assert iter.hasNext();
  
      inv = iter.next();
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp()):
        inv.toString() + " expected=" + pi1;
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      assert !iter.hasNext();
    }
  }
  
  private boolean verifyAndApplyToNode(SecureCore SecureCore, GeneralInv gi, NodeId sender){
    SecurityFilter filter = SecureCore.getSecurityFilter();
    boolean ret = filter.verifyAndApply(gi, sender);
    SecureCore.applyInval(gi, null);
    return ret;
  }
  
  private void syncNodes(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    SecureInMemLogIterator destIter = destFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      GeneralInv gi = srcIter.next();
      assert this.verifyAndApplyToNode(destSecureCore, gi, srcSecureCore.getMyNodeId()):"can't apply" + gi.toString();
    }
    //reset source
//    srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
//    while(srcIter.hasNext() || destIter.hasNext()){
//      assert destIter.hasNext();
//      assert srcIter.hasNext();
//      
//      GeneralInv spiDest = destIter.next();
//      GeneralInv spiSrc = srcIter.next();
//      assert spiDest instanceof SecurePreciseInv;
//      assert spiSrc instanceof SecurePreciseInv;
////      if(dbg){
////        if(!spiDest.equals(spiSrc))System.out.println("Mismatching values from iterator: Src:" + spiSrc + " Dest: " + spiDest);
////        else System.out.println("Matching values from iterator: Src:" + spiSrc + " Dest: " + spiDest);
////      }     
////      
////      assert spiDest.equals(spiSrc): "Mismatching values from iterator: Src:" + spiSrc + " Dest: " + spiDest;
//    }
  }
  
  private GeneralInv applyToNode(SecureCore destSecureCore, 
                             SecureCore srcSecureCore,
                             GeneralInv secureInv){
    assert secureInv != null;
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    GeneralInv sii = null;
    if(secureInv instanceof ImpreciseInv){
      sii = srcFilter.createImpreciseInv((ImpreciseInv)secureInv);
    }else{
      assert secureInv instanceof SecurePreciseInv:secureInv;
      sii = secureInv;
    }
    assert destFilter.verifyAndApply(sii, srcSecureCore.getMyNodeId());
    destSecureCore.applyInval(sii, null); 
    return sii;
  }
  
  private void verifyIter(SecureInMemLogIterator iter, 
                                 long stamp,
                                 long nodeId){
    assert iter.hasNext();
    GeneralInv gi = iter.next();
    assert gi != null;
    assert gi instanceof PreciseInv;
    PreciseInv pi = ((PreciseInv)(gi));
    assert pi.getAcceptStamp().equals(new AcceptStamp(stamp, new NodeId(nodeId))):
      pi.toString() + "expected:" + stamp +"@"+nodeId;
  }
 
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SecureFetchUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecureFetchUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }
  
}

