package code.security.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Arrays;

import code.security.DataHash;
import code.security.SecureImpreciseInv;
import code.security.ahs.*;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.SummaryHash;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SecureImpreciseInvUnit extends TestCase{
  
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  PrivateKey privKey;
  PublicKey pubKey;
  
  HierInvalTarget hit1 = null;
  HierInvalTarget hit2 = null;
  ImpreciseInv ii1 = null;
  ImpreciseInv ii2 = null;
  SecureImpreciseInv sii = null;
  SecureImpreciseInv sii2 = null;
  AcceptStamp[] as1 = null;
  AcceptStamp[] as2 = null;
  AcceptStamp[] as3 = null;

  ByteArrayOutputStream baos = null;
  ByteArrayInputStream bais = null;
  ObjectOutputStream oos = null;
  ObjectInputStream ois = null;
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(1));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(1));
    
    hit1 = HierInvalTarget.makeHierInvalTarget("/a/b:/a/b/*");
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(190, new NodeId(20));
    as1[1] = new AcceptStamp(180, new NodeId(30));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(200, new NodeId(20));
    as2[1] = new AcceptStamp(190, new NodeId(30));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(100, new NodeId(20));
    as3[1] = new AcceptStamp(190, new NodeId(30));

    ii1 = new ImpreciseInv(hit1,
                           new AcceptVV(as1),
                           new AcceptVV(as2),
                           new AcceptVV(as3));
    
    Vector<IH> v = new Vector<IH>();
    byte[] ba = {1,3,5,7,4,2,6,7,3,5,7,3,5,6,2};
    Hashtable<NodeId, DVVMapEntry> dvvMapH = new Hashtable<NodeId, DVVMapEntry>();
    DVVMapEntry dvvmapentry = new DVVMapEntry(5,DataHash.getMD(ba));
    dvvMapH.put(new NodeId(200), dvvmapentry);
    DVVMap dvvmap = new DVVMap(dvvMapH);
    AHSEntry ae = new AHSEntry(3, DataHash.getMD(ba), 1, 2,hit1, dvvmap ,DataHash.getMD(ba));
    IH ih = new IH(ae);
    v.add(ih);
    //v.add(ih);
    Hashtable<NodeId,Vector<IH>> ihtuples = new Hashtable<NodeId,Vector<IH>>();
    ihtuples.put(new NodeId(12), v);
    //ihtuples.put(new NodeId(13), v);
    //ihtuples.put(new NodeId(14), v);
    
    sii = new SecureImpreciseInv(ii1,ihtuples,new NodeId(3));

  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }
  public void testSerialization(){
        
    try{
      FileOutputStream fos = new FileOutputStream( "tmpz" );
      oos = new ObjectOutputStream(fos);
      oos.writeObject(sii);
      oos.flush();
      oos.close();
      
      fos = new FileOutputStream( "tmpz-AHSEntry" );
      oos = new ObjectOutputStream(fos);
      oos.writeObject(sii.getIH(new NodeId(12)).get(0).getAHSEntry());
      oos.flush();
      oos.close();
    
      
      FileInputStream fis = new FileInputStream( "tmpz" );
      ois = new ObjectInputStream(fis);
      sii2 = (SecureImpreciseInv)(ois.readObject());
      if(sii.equals(sii2));
    }catch(Exception e){
      e.printStackTrace();
      System.out.println("" + e);
      fail("serialization test failed");
    }
    
    System.out.println("\n" + sii.toString());
    System.out.println(sii2.toString());
    
    if(!Arrays.equals(sii.obj2BytesExcludingSignature(),
        sii2.obj2BytesExcludingSignature())){
      fail("obj2BytesExcludingSignature");
    }
    if(!Arrays.equals(sii.obj2Bytes(),
        sii2.obj2Bytes())){
      fail("obj2Bytes");
    }
    
    PublicKey pubkey = (PublicKey)(Config.publicKeys.get(new Long(sii2.getCreator().getIDint())));
    if(!sii2.verify(pubkey)){
      fail("Verifying signature on restored sii failed");
    }
    
  }
  
  public void testSignature(){
        
    PublicKey pubkey = (PublicKey)(Config.publicKeys.get(new Long(sii.getCreator().getIDint())));
    if(!sii.verify(pubkey)){
      fail("signature test failed");
    }
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SecureImpreciseInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecureImpreciseInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

  
}
