package code.security.unit;

import	code.Config;
import code.AcceptStamp;
import code.GeneralInv;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.ObjId;
import code.NodeId;
import code.SubscriptionSet;
import code.security.SecureCore;
import code.security.SecurePreciseInv;
import code.security.SecureRMIClient;
import code.SingleWriterInval;

import java.io.File;
import java.util.LinkedList;

import code.AcceptVV;
import code.PreciseInv;
import code.ObjInvalTarget;
import code.ImmutableBytes;
import code.security.SecureInMemLogIterator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.security.SecurityFilter;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;

public class SecureInMemLogIteratorUnit extends TestCase{
	public static final String TEST_ALL_TEST_TYPE = "UNIT";
  private static final boolean dbg = true; 
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();

  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

    private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
			      NODE_1_IP,
			    port++,
			    port++,
			    port++,
			    port++,
			    port++,
			    "test" + File.separatorChar + "local-" + 
			    NODE_1_ID + ".db",
			    "/*",
			    -1L,
			    NODE_1_IP,
			    port++,
			    port++,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi
        
  }
    
    public void testImprecise()
    throws Exception{
    	System.out.println("Running testImprecise");

      boolean stepAssertion = true;
      GeneralInv sii =null;
      boolean apply12_2 = true;
      SecureInMemLogIterator iter1 = null, iter2 = null, iter3 = null, 
                             iter4 = null, iter5 = null, iter6 = null;
      SecureInMemLogIterator iter10, iter11, iter12;
      SecurePreciseInv pi_10_2 = null, pi_11_1 = null, pi_11_0 = null, pi_12_2 = null;
      GeneralInv gi = null;

      int totalNodes = 5;
      makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4
      SecureRMIClient myRMIClient = new SecureRMIClient();   
      
      //create SecureCore as URANode constructor did
      boolean filterOn = true;
      boolean cleanDb = true;  // start from empty
      
      SecureCore[] SecureCores = new SecureCore[totalNodes];
      SecurityFilter[] filters = new SecurityFilter[totalNodes];
      SecureInMemLogIterator[] iters = new SecureInMemLogIterator[totalNodes]; 
      for(int i = 0; i < totalNodes; i++){
        SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
        LinkedList<Filter> f = new LinkedList<Filter>();
        f.add(ssf);
        SecureCores[i] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(i), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
        assert SecureCores[i].getCurrentVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()):SecureCores[i].getCurrentVV();
        SecureCores[i].testSkipRecoverLocalState();
        assert SecureCores[i].getCurrentVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()):SecureCores[i].getCurrentVV();
        filters[i] = SecureCores[i].getSecurityFilter();
        //these set of iters are used in the entire test to iterator the log of each node, never reset the iters.
        iters[i] = filters[i].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
        //empty log
        assert !iters[i].hasNext();
        assert iters[i].next() == null;
      }

      System.out.println("cvv1" + SecureCores[2].getCurrentVV());

      //
      // populate 10 write to node 0
      //
      int nodeId = 0;
      int writeNum = 10;
      int stage = 0;
      
      this.populateWrite(SecureCores, nodeId, writeNum, stage);
      System.out.println("cvv2" + SecureCores[2].getCurrentVV());

      //
      // populate 10 write to node 1
      //
      nodeId = 1;
      writeNum = 10;
      stage = 0;
      this.populateWrite(SecureCores, nodeId, writeNum, stage);
      System.out.println("cvv3" + SecureCores[2].getCurrentVV());

     while(iters[0].hasNext()){
       gi = iters[0].next();
       assert gi!=null;
       if(dbg){
          System.out.println(" applying " + gi + " to 2 and 1");
       }
       assert verifyAndApplyToNode(SecureCores[2], gi);
       
       assert verifyAndApplyToNode(SecureCores[1], gi);
     }
     System.out.println("cvv4" + SecureCores[2].getCurrentVV());

     while(iters[1].hasNext()){
       gi = iters[1].next();
       assert gi != null;
       if(dbg){
          System.out.println(" applying " + gi + " to 2 and 0");
       }
       
       assert verifyAndApplyToNode(SecureCores[2], gi);
       
       assert verifyAndApplyToNode(SecureCores[0], gi);
     
     }
     System.out.println("cvv5" + SecureCores[2].getCurrentVV());

     //move iters[0] and iters[1] to the end of node 0 log and end of node 1 log
     while(iters[0].hasNext()){
       iters[0].next();
     }
     
     while(iters[1].hasNext()){
       iters[1].next();
     }
     
     assert iters[0].next() == null;
     assert iters[1].next() == null;
     
     //tbd, the order is decided by the default HashMap, see TreeNodePointer.nextSentableItem()
     //verify records for node 1
     nodeId = 1;
     stage = 0;
     //iters[2] point to node 2 and starts from the beginning;
     for(int i = 0; i < writeNum; i ++ ){
       this.verifyIter(iters[2], i, nodeId);
     }
     
   //verify records for node 0
     nodeId = 0; 
     stage = 0;
     for(int i = 0; i < writeNum; i ++ ){
       this.verifyIter(iters[2], i, nodeId);
    }
    assert !iters[2].hasNext();
     
    //
    // play with different dvv
    // write 10@2, with dvv = <9@0, 9@1> 
    // apply 10@2 to 0, 1  
    // write 11@0(11@1) with dvv = 10@2
    // apply 11@0, 11@1 to 2
    nodeId = 2;
    writeNum = 1;
    System.out.println("cvv6" + SecureCores[2].getCurrentVV());

    populateWrite(SecureCores, nodeId, writeNum, stage);
    

    //apply 10@2 to 0, and 1.
    assert iters[2].hasNext();
    gi = iters[2].next();
    pi_10_2 = (SecurePreciseInv)gi;
    assert gi != null;
    assert verifyAndApplyToNode(SecureCores[0], gi);
    assert verifyAndApplyToNode(SecureCores[1], gi);
    assert iters[2].next() == null;
    
    nodeId = 0;
    writeNum = 1;
    populateWrite(SecureCores, nodeId, writeNum, stage);
    
    
    nodeId = 1;
    writeNum = 1;
    populateWrite(SecureCores, nodeId, writeNum, stage);
    
    assert iters[0].hasNext();
    assert iters[1].hasNext();
    PreciseInv pi = ((PreciseInv)(iters[0].next())); 
    assert pi.getAcceptStamp().equals(new AcceptStamp(10, new NodeId(2))):pi.toString();
    
    assert ((PreciseInv)(iters[1].next())).getAcceptStamp().equals(new AcceptStamp(10, new NodeId(2)));
      
    //apply 11@0, 11@1 to 2
    assert iters[0].hasNext();
    PreciseInv pi1 = ((PreciseInv)(iters[0].next()));
    pi_11_0 = (SecurePreciseInv)pi1;
    assert pi1.getAcceptStamp().equals(new AcceptStamp(11, new NodeId(0)));
    assert !iters[0].hasNext();
    assert verifyAndApplyToNode(SecureCores[2], pi1);
    assert iters[2].hasNext();
    assert iters[2].next().equals(pi_11_0);
    
    assert iters[1].hasNext();
    PreciseInv pi2 = ((PreciseInv)(iters[1].next()));
    pi_11_1 = (SecurePreciseInv)pi2;
    assert pi2.getAcceptStamp().equals(new AcceptStamp(11, new NodeId(1)));
    assert verifyAndApplyToNode(SecureCores[2], pi2);
    assert iters[2].hasNext();
    assert iters[2].next().equals(pi_11_1);
    
    assert iters[0].next() == null;
    assert iters[1].next() == null;
    
    if(apply12_2){
      //write a new update at node 2: 12@2
      nodeId = 2;
      writeNum = 1;
      populateWrite(SecureCores, nodeId, writeNum, stage);
      
      //check 12@2.
      assert iters[2].hasNext();
      gi = iters[2].next();//12@2
      pi_12_2 = (SecurePreciseInv)gi;
      assert gi != null;
      assert ((PreciseInv)gi).getAcceptStamp().equals(new AcceptStamp(12, new NodeId(2)));
    }
   
      //---
      // initial population is done
      //---
    
      //
      // test imprecise invalidation
      //
      
      //
      // apply Imprecise invalidations to 3
      // then apply the precise invalidations to 3
      // then verify that the iter of 3 returns exactly the same as iter 2
      //
      
      GeneralInv nextInv = null;
      AcceptStamp[] as1 = new AcceptStamp[1];
      AcceptStamp[] as2 = new AcceptStamp[1];
      
      as1[0] = new AcceptStamp( 0, new NodeId(0));
      as2[0] = new AcceptStamp( 5, new NodeId(0));
      ImpreciseInv ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));

      sii = this.applyToNode(SecureCores[3], SecureCores[0], ii);
      if(stepAssertion){
        assert iters[3].hasNext();
        nextInv = iters[3].next();
        assert nextInv.equals(sii):"next() return: " + nextInv + " expected=" +sii;
      }
      
      as1[0] = new AcceptStamp( 6, new NodeId(0));
      as2[0] = new AcceptStamp( 9, new NodeId(0));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
      sii = this.applyToNode(SecureCores[3], SecureCores[0], ii);
      TreeNode t = SecureCores[3].securityFilter.getAhsMap().getTreeNodeTS(new NodeId(0), 5);
      System.out.println("##### t s:"+t.getStartTS());
      System.out.println("##### t e:"+t.getEndTS());
      System.out.println("##### tnext s:"+t.getNext().getStartTS());
      System.out.println("##### tnext e:"+t.getNext().getEndTS());
      System.out.println("##### t hashCode():"+t.hashCode());
      if(stepAssertion){
        assert iters[3].hasNext():" expected: " + sii;
        assert iters[3].next().equals(sii);
      }
      
      //bug 2 start
      as1[0] = new AcceptStamp( 0, new NodeId(1));
      as2[0] = new AcceptStamp( 5, new NodeId(1));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
    
      sii = this.applyToNode(SecureCores[3], SecureCores[1], ii);
      
      if(stepAssertion){
        assert iters[3].next().equals(sii);
      }
      //syncNodes(SecureCores[2], SecureCores[3]);    
      //bug end
      
      as1[0] = new AcceptStamp( 6, new NodeId(1));
      as2[0] = new AcceptStamp( 9, new NodeId(1));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
      sii = this.applyToNode(SecureCores[3], SecureCores[1], ii);
      if(stepAssertion){
        assert iters[3].next().equals(sii);
      }
      /*
      as1[0] = new AcceptStamp( 10, new NodeId(2));
      as2[0] = new AcceptStamp( 10, new NodeId(2));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
      this.applyToNode(SecureCores[3], SecureCores[2], ii);
      */
      sii = this.applyToNode(SecureCores[3], SecureCores[2], pi_10_2);
      if(stepAssertion){
        assert iters[3].next().equals(sii);
      }
      /*
      as1[0] = new AcceptStamp( 11, new NodeId(1));
      as2[0] = new AcceptStamp( 11, new NodeId(1));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
      this.applyToNode(SecureCores[3], SecureCores[1], ii);
      */
      sii = this.applyToNode(SecureCores[3], SecureCores[1], pi_11_1);
      if(stepAssertion){
        assert iters[3].next().equals(sii);
      }
      /*
      as1[0] = new AcceptStamp( 11, new NodeId(0));
      as2[0] = new AcceptStamp( 11, new NodeId(0));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
      this.applyToNode(SecureCores[3], SecureCores[0], ii);
      */
      
      sii = this.applyToNode(SecureCores[3], SecureCores[0], pi_11_0);
      if(stepAssertion){
        assert iters[3].next().equals(sii);
      }
      
      /*
      as1[0] = new AcceptStamp( 12, new NodeId(2));
      as2[0] = new AcceptStamp( 12, new NodeId(2));
      ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
          new AcceptVV(as1),
           new AcceptVV(as2));
      

      this.applyToNode(SecureCores[3], SecureCores[2], ii);
      */
      if(apply12_2){
        System.out.println("--------------------- apply 12@2:" + pi_12_2);
        sii = this.applyToNode(SecureCores[3], SecureCores[2], pi_12_2);
        if(stepAssertion){
          assert iters[3].next().equals(sii);
        }
      }
      
      System.out.println();
      //check if the destination has everything
      
      iter6 = filters[3].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
      assert iter6.hasNext();
      while(iter6.hasNext()){
        gi = iter6.next();
        System.out.println("******node 3: " + gi);
        //what would be the out come?
        //tbd
        // problem scenario:
        //  11@0 is missing.
      }
      assert !iter6.hasNext();
      assert iter6.next() == null;
      //apply all precise invalidation from node 2 to node 3
      syncNodes(SecureCores[2], SecureCores[3]);
      
      for(int i = 0; i < totalNodes; i++){
          SecureCores[i].close();
      }
    }

  public void dotestImpreciseWithWrite()
  throws Exception{
	System.out.println("Running testImpreciseWithWrite");
    boolean stepAssertion = true;
    GeneralInv sii =null;
    boolean apply12_2 = true;
    SecureInMemLogIterator iter1 = null, iter2 = null, iter3 = null, 
                           iter4 = null, iter5 = null, iter6 = null;
    SecureInMemLogIterator iter10, iter11, iter12;
    SecurePreciseInv pi_10_2 = null, pi_11_1 = null, pi_11_0 = null, pi_12_2 = null;
    GeneralInv gi = null;

    int totalNodes = 5;
    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4
    SecureRMIClient myRMIClient = new SecureRMIClient();   
    
    //create SecureCore as URANode constructor did
    boolean filterOn = true;
    boolean cleanDb = true;  // start from empty
    
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    SecureInMemLogIterator[] iters = new SecureInMemLogIterator[totalNodes]; 
    for(int i = 0; i < totalNodes; i++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[i] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(i), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[i].testSkipRecoverLocalState();
      filters[i] = SecureCores[i].getSecurityFilter();
      //these set of iters are used in the entire test to iterator the log of each node, never reset the iters.
      iters[i] = filters[i].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
      //empty log
      assert !iters[i].hasNext();
      assert iters[i].next() == null;
    }

    
    //
    // populate 10 write to node 0
    //
    int nodeId = 0;
    int writeNum = 10;
    int stage = 0;
    
    this.populateWrite(SecureCores, nodeId, writeNum, stage);
    
    //
    // populate 10 write to node 1
    //
    nodeId = 1;
    writeNum = 10;
    stage = 0;
    this.populateWrite(SecureCores, nodeId, writeNum, stage);
    
   while(iters[0].hasNext()){
     gi = iters[0].next();
     assert gi!=null;
     if(dbg){
	System.out.println(" applying " + gi + " to 2 and 1");
     }
     assert verifyAndApplyToNode(SecureCores[2], gi);
     
     assert verifyAndApplyToNode(SecureCores[1], gi);
   }
   
   while(iters[1].hasNext()){
     gi = iters[1].next();
     assert gi != null;
     if(dbg){
        System.out.println(" applying " + gi + " to 2 and 0");
     }
     
     assert verifyAndApplyToNode(SecureCores[2], gi);
     
     assert verifyAndApplyToNode(SecureCores[0], gi);
   
   }
   
   //move iters[0] and iters[1] to the end of node 0 log and end of node 1 log
   while(iters[0].hasNext()){
     iters[0].next();
   }
   
   while(iters[1].hasNext()){
     iters[1].next();
   }
   
   assert iters[0].next() == null;
   assert iters[1].next() == null;
   
   //tbd, the order is decided by the default HashMap, see TreeNodePointer.nextSentableItem()
   //verify records for node 1
   nodeId = 1;
   stage = 0;
   //iters[2] point to node 2 and starts from the beginning;
   for(int i = 0; i < writeNum; i ++ ){
     this.verifyIter(iters[2], i, nodeId);
   }
   
 //verify records for node 0
   nodeId = 0; 
   stage = 0;
   for(int i = 0; i < writeNum; i ++ ){
     this.verifyIter(iters[2], i, nodeId);
  }
  assert !iters[2].hasNext();
   
  //
  // play with different dvv
  // write 10@2, with dvv = <9@0, 9@1> 
  // apply 10@2 to 0, 1  
  // write 11@0(11@1) with dvv = 10@2
  // apply 11@0, 11@1 to 2
  nodeId = 2;
  writeNum = 1;
  populateWrite(SecureCores, nodeId, writeNum, stage);
  

  //apply 10@2 to 0, and 1.
  assert iters[2].hasNext();
  gi = iters[2].next();
  pi_10_2 = (SecurePreciseInv)gi;
  assert gi != null;
  assert verifyAndApplyToNode(SecureCores[0], gi);
  assert verifyAndApplyToNode(SecureCores[1], gi);
  assert iters[2].next() == null;
  
  nodeId = 0;
  writeNum = 1;
  populateWrite(SecureCores, nodeId, writeNum, stage);
  
  
  nodeId = 1;
  writeNum = 1;
  populateWrite(SecureCores, nodeId, writeNum, stage);
  
  assert iters[0].hasNext();
  assert iters[1].hasNext();
  PreciseInv pi = ((PreciseInv)(iters[0].next())); 
  assert pi.getAcceptStamp().equals(new AcceptStamp(10, new NodeId(2))):pi.toString();
  
  assert ((PreciseInv)(iters[1].next())).getAcceptStamp().equals(new AcceptStamp(10, new NodeId(2)));
    
  //apply 11@0, 11@1 to 2
  assert iters[0].hasNext();
  PreciseInv pi1 = ((PreciseInv)(iters[0].next()));
  pi_11_0 = (SecurePreciseInv)pi1;
  assert pi1.getAcceptStamp().equals(new AcceptStamp(11, new NodeId(0)));
  assert !iters[0].hasNext();
  assert verifyAndApplyToNode(SecureCores[2], pi1);
  assert iters[2].hasNext();
  assert iters[2].next().equals(pi_11_0);
  
  assert iters[1].hasNext();
  PreciseInv pi2 = ((PreciseInv)(iters[1].next()));
  pi_11_1 = (SecurePreciseInv)pi2;
  assert pi2.getAcceptStamp().equals(new AcceptStamp(11, new NodeId(1)));
  assert verifyAndApplyToNode(SecureCores[2], pi2);
  assert iters[2].hasNext();
  assert iters[2].next().equals(pi_11_1);
  
  assert iters[0].next() == null;
  assert iters[1].next() == null;
  
  if(apply12_2){
    //write a new update at node 2: 12@2
    nodeId = 2;
    writeNum = 1;
    populateWrite(SecureCores, nodeId, writeNum, stage);
    
    //check 12@2.
    assert iters[2].hasNext();
    gi = iters[2].next();//12@2
    pi_12_2 = (SecurePreciseInv)gi;
    assert gi != null;
    assert ((PreciseInv)gi).getAcceptStamp().equals(new AcceptStamp(12, new NodeId(2)));
  }
 
 /** 
 *  initial population is done 
 **/ 
  
    //
    // test imprecise invalidation
    //
    
    //
    // apply Imprecise invalidations to 3
    // then apply the precise invalidations to 3
    // then verify that the iter of 3 returns exactly the same as iter 2
    //
    
    GeneralInv nextInv = null;
    AcceptStamp[] as1 = new AcceptStamp[1];
    AcceptStamp[] as2 = new AcceptStamp[1];
    
    as1[0] = new AcceptStamp( 0, new NodeId(0));
    as2[0] = new AcceptStamp( 5, new NodeId(0));
    ImpreciseInv ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptVV(as1),
         new AcceptVV(as2));

    sii = this.applyToNode(SecureCores[3], SecureCores[0], ii);
    if(stepAssertion){
      assert iters[3].hasNext();
      nextInv = iters[3].next();
      assert nextInv.equals(sii):"next() return: " + nextInv + " expected=" +sii;
    }
   
    //populate a new write on node 3
    nodeId = 3;
    writeNum = 1;
    this.populateWrite(SecureCores, nodeId, writeNum, stage);
    if(stepAssertion){
      assert iters[3].hasNext();
      nextInv = iters[3].next();
      assert nextInv instanceof SecurePreciseInv: nextInv.toString();
      assert (((SecurePreciseInv)nextInv).getAcceptStamp()).equals(new AcceptStamp(6, new NodeId(nodeId))):"next() return: " + nextInv;
    }
    
    iter6 = filters[3].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    assert iter6.hasNext();
    while(iter6.hasNext()){
      gi = iter6.next();
      System.out.println("******node 3: " + gi);
      //what would be the out come?
      //tbd
      // problem scenario:
      //  11@0 is missing.
    }
    assert !iter6.hasNext();
    assert iter6.next() == null;
    //apply all 2 to 3
    //syncNodes(SecureCores[2], SecureCores[3]);
    System.out.println();
    for(int i = 0; i < totalNodes; i++){
        SecureCores[i].close();
    }
  }
  
  public void dotestPrecise()
  throws Exception{
		System.out.println("Running testPrecise");

    boolean apply12_2 = true;
    SecureInMemLogIterator iter1 = null, iter2 = null, iter3 = null, 
                           iter4 = null, iter5 = null, iter6 = null;
    SecureInMemLogIterator iter10, iter11, iter12;
    SecurePreciseInv pi_10_2 = null, pi_11_1 = null, pi_11_0 = null, pi_12_2 = null;
    GeneralInv gi = null;
    //case 1: 1 log, 1 iter, write one, get one, write two, get two
    int totalNodes = 5;
    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4
    SecureRMIClient myRMIClient = new SecureRMIClient();   
    
    //create SecureCore as URANode constructor did
    boolean filterOn = true;
    boolean cleanDb = true;  // start from empty
    
    
    SecureCore[] SecureCores = new SecureCore[totalNodes];
    SecurityFilter[] filters = new SecurityFilter[totalNodes];
    for(int i = 0; i < totalNodes; i++){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      SecureCores[i] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(i), false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
      SecureCores[i].testSkipRecoverLocalState();
      filters[i] = SecureCores[i].getSecurityFilter();
    }

    //
    //populate 1 write to node 0
    //
    ObjId oid = new ObjId("/foo");
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    //
    // empty log
    //
    iter1 = filters[0].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    
    //needed in the late stage, but have to setup before anything is populated due to the bug
    iter10 = filters[0].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    iter11 = filters[1].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    iter12 = filters[2].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    iter6 = filters[3].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    System.out.println("dummy AcceptVV:" + AcceptVV.makeVVAllNegatives());
    assert !iter1.hasNext();
    assert iter1.next() == null;
    
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
    int nodeId = 0;
    int stage = 0;
    int writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);

      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                           offset, 
                           len),
                           new AcceptStamp(i, new NodeId((long)nodeId)));


      assert iter1.hasNext();
    
      GeneralInv inv = iter1.next();
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      assert !iter1.hasNext();
    }
    
    iter1 = filters[0].makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    
    for(int i = 0; i < writeNum; i ++ ){
        oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
        pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                             offset, 
                             len),
                             new AcceptStamp(i, new NodeId((long)nodeId)));


        assert iter1.hasNext();
      
        GeneralInv inv = iter1.next();
        assert inv instanceof SecurePreciseInv;
        assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
        assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      }
    assert !iter1.hasNext();
       
    AcceptStamp[] as0 = new AcceptStamp[2];
    as0[0] = new AcceptStamp(-1, new NodeId(0));
    as0[1] = new AcceptStamp(-1, new NodeId(1));
  
    iter3 = filters[0].makeSecureInMemLogIterator(new AcceptVV(as0));
    assert iter3.hasNext();
    
    
    
   //
   // sanityCheck
   //
    AcceptVV startVV1 = null;
    int start2 = 2;
    //
    //a normal iter start from the middle
    //
    AcceptStamp[] as = new AcceptStamp[2];
    as[0] = new AcceptStamp(start2, new NodeId(0));
    as[1] = new AcceptStamp(start2, new NodeId(1));
    startVV1 = new AcceptVV(as);
    
    iter2 = filters[0].makeSecureInMemLogIterator(startVV1);
    
    for(int i = start2+1; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                           offset, 
                           len),
                           new AcceptStamp(i, new NodeId((long)nodeId)));


      assert iter2.hasNext(): "expected:" + pi1;
    
      GeneralInv inv = iter2.next();
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp()):inv.toString()
      + " expected: " + pi1.toString();
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
   }
    assert !iter2.hasNext();
    
    //
    // an iter start from the end;
    //
    int start3 = 9;
    as[0] = new AcceptStamp(start3, new NodeId(0));
    as[1] = new AcceptStamp(start3, new NodeId(1));
    startVV1 = new AcceptVV(as);
    iter3 = filters[0].makeSecureInMemLogIterator(startVV1);
    
    for(int i = start3+1; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                                              offset, 
                                              len),
                           new AcceptStamp(i, new NodeId((long)nodeId)));


      assert iter3.hasNext();
    
      GeneralInv inv = iter3.next();
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
   }
    assert !iter3.hasNext();
    
    //
    //an iter start from the future;
    //
    int start4 = 15;
    as[0] = new AcceptStamp(start4, new NodeId(0));
    as[1] = new AcceptStamp(start4, new NodeId(1));
    startVV1 = new AcceptVV(as);
    iter4 = filters[0].makeSecureInMemLogIterator(startVV1);
    
    assert !iter4.hasNext();
    assert iter4.next() == null;
   
    
    iter1 = null;
    iter2 = null;
    iter3 = null;
    iter4 = null;
    //
    // stage 1
    // write 10 to node 1
    // apply both node 0, and 1 to node 2
    // apply node 0 log to node 1
    // apply node 1 log to node 0
    // postcondition: node 0, 1, 2 has updates 0@0 to 9@0
    //                                         0@1 to 9@1
    // all invalidations' dvv are the writer itself
    //
    nodeId = 1;
    stage = 0;
    writeNum = 10;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);

   }
   
   
   assert iter10.hasNext();//iter on 0 start from beginning
   assert iter11.hasNext();//iter on 1 start from beginning
   
   while(iter10.hasNext()){
     gi = iter10.next();
     assert gi!=null;
     if(dbg){
        System.out.println(" applying " + gi + " to 2 and 1");
     }
     assert verifyAndApplyToNode(SecureCores[2], gi);
     
     assert verifyAndApplyToNode(SecureCores[1], gi);
   }
   
   while(iter11.hasNext()){
     gi = iter11.next();
     assert gi != null;
     if(dbg){
        System.out.println(" applying " + gi + " to 2 and 0");
     }
     
     assert verifyAndApplyToNode(SecureCores[2], gi);
     
     assert verifyAndApplyToNode(SecureCores[0], gi);
   
   }
   
   //move iter10 and iter11 to the end of node 0 log and end of node 1 log
   while(iter10.hasNext()){
     iter10.next();
   }
   
   while(iter11.hasNext()){
     iter11.next();
   }
   
   assert iter10.next() == null;
   assert iter11.next() == null;
   
   //tbd, the order is decided by the default HashMap, see TreeNodePointer.nextSentableItem()
   //verify records for node 1
   nodeId = 1;
   stage = 0;
   //iter12 point to node 2 and starts from the begining;
   for(int i = 0; i < writeNum; i ++ ){
     oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
     if(dbg){
        System.out.println("checking " + oid + " in 2");
     } 
     pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                          offset, 
                          len),
                          new AcceptStamp(i, new NodeId((long)nodeId)));


     assert iter12.hasNext();
   
     GeneralInv inv = iter12.next();
     assert inv instanceof SecurePreciseInv;
     assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp())
     :((SecurePreciseInv)inv).getAcceptStamp() + " expected: " + pi1;
     assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
  }
 //verify records for node 0
   nodeId = 0; 
   stage = 0;
   for(int i = 0; i < writeNum; i ++ ){
     oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
     
     pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                          offset, 
                          len),
                          new AcceptStamp(i, new NodeId((long)nodeId)));


     assert iter12.hasNext();
   
     GeneralInv inv = iter12.next();
     assert inv instanceof SecurePreciseInv;
     assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp());
     assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
  }
  assert !iter12.hasNext();
   
  //
  // play with different dvv
  // write 10@2, with dvv = <9@0, 9@1> 
  // apply 10@2 to 0, 1  
  // write 11@0(11@1) with dvv = 10@2
  // apply 11@0, 11@1 to 2
  nodeId = 2;
  long stamp = 10;
  oid = new ObjId("/"+ nodeId + "/" + stage + "/" + stamp);
  SecureCores[nodeId].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);

  //apply 10@2 to 0, and 1.
  assert iter12.hasNext();
  gi = iter12.next();
  pi_10_2 = (SecurePreciseInv)gi;
  assert gi != null;
  assert verifyAndApplyToNode(SecureCores[0], gi);
  assert verifyAndApplyToNode(SecureCores[1], gi);
  assert iter12.next() == null;
  
  nodeId = 0;
  stamp = 11;
  oid = new ObjId("/"+ nodeId + "/" + stage + "/" + stamp);
  SecureCores[nodeId].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
  
  nodeId = 1;
  stamp = 11;
  oid = new ObjId("/"+ nodeId + "/" + stage + "/" + stamp);
  SecureCores[nodeId].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
  
  assert iter10.hasNext();
  assert iter11.hasNext();
  PreciseInv pi = ((PreciseInv)(iter10.next())); 
  assert pi.getAcceptStamp().equals(new AcceptStamp(10, new NodeId(2))):pi.toString();
  
  assert ((PreciseInv)(iter11.next())).getAcceptStamp().equals(new AcceptStamp(10, new NodeId(2)));
    
  //apply 11@0, 11@1 to 2
  assert iter10.hasNext();
  pi1 = ((PreciseInv)(iter10.next()));
  pi_11_0 = (SecurePreciseInv)pi1;
  assert pi1.getAcceptStamp().equals(new AcceptStamp(11, new NodeId(0)));
  assert !iter10.hasNext();
  assert verifyAndApplyToNode(SecureCores[2], pi1);
  assert iter12.hasNext();
  assert iter12.next().equals(pi_11_0);
  
  assert iter11.hasNext();
  PreciseInv pi2 = ((PreciseInv)(iter11.next()));
  pi_11_1 = (SecurePreciseInv)pi2;
  assert pi2.getAcceptStamp().equals(new AcceptStamp(11, new NodeId(1)));
  assert verifyAndApplyToNode(SecureCores[2], pi2);
  assert iter12.hasNext();
  assert iter12.next().equals(pi_11_1);
  
  assert iter10.next() == null;
  assert iter11.next() == null;
  
  if(apply12_2){
    //write a new update at node 2: 12@2
    nodeId = 2;
    stamp = 12;
    oid = new ObjId("/"+ nodeId + "/" + stage + "/" + stamp);
    SecureCores[nodeId].write(oid, offset, len, 
                        SecureCore.DEFAULT_PRIORITY, 
                        body, 
                        false, 
                        Long.MAX_VALUE);
  
    //check 12@2.
    assert iter12.hasNext();
    gi = iter12.next();//12@2
    pi_12_2 = (SecurePreciseInv)gi;
    assert gi != null;
    assert ((PreciseInv)gi).getAcceptStamp().equals(new AcceptStamp(stamp, new NodeId(2)));
  }
  
  int start5 = 8;
  AcceptStamp[] as5 = new AcceptStamp[5];
  for(int i = 0; i < 5; i ++){
    as5[i] = new AcceptStamp(start5, new NodeId(i));
  }
  startVV1 = new AcceptVV(as5);
  iter5 = filters[2].makeSecureInMemLogIterator(startVV1);
  
  //iter should return 9@0, 9@1, 10@2, 11@0, 11@1
  //note: jvm might order the pointers differently
  //      for (9@0, 9@1) and (11@0, 11@1)
  // if you get assertion error here,
  // try to reorder those items.
    this.verifyIter(iter5, 9, 1);
    this.verifyIter(iter5, 9, 0);
    this.verifyIter(iter5, 10, 2);
    this.verifyIter(iter5, 11, 1);
    this.verifyIter(iter5, 11, 0);
    if(apply12_2){
      this.verifyIter(iter5, 12, 2);
    }
    assert !iter5.hasNext();
    
    //make sure that src sent is what dest sees
    syncNodes(SecureCores[2], SecureCores[4]);
    
    for(int i = 0; i < totalNodes; i++){
        SecureCores[i].close();
    }
  }
  
  /**
   * do writeNum writes at SecureCores[nodeId] with path prefixed with /stage/
   * @param SecureCores
   * @param nodeId
   * @param writeNum
   * @param stage
   * @throws Exception
   */
  private void populateWrite(SecureCore[] SecureCores, int nodeId, int writeNum, int stage)
  throws Exception{
    ObjId oid = null;
    byte[] bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;
    SecureInMemLogIterator iter = null;
    AcceptVV excludedStartVV = SecureCores[nodeId].getCurrentVV();
    long start = excludedStartVV.getMaxTimeStamp()+1;
    iter =SecureCores[nodeId].getSecurityFilter().makeSecureInMemLogIterator(excludedStartVV);
    assert !iter.hasNext();
    GeneralInv inv = null;
    //
    // populate 10 write to node 0
    //
    PreciseInv pi1 = null;
  
  
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+ nodeId + "/" + stage + "/" + i);
      SecureCores[nodeId].write(oid, offset, len, 
                          SecureCore.DEFAULT_PRIORITY, 
                          body, 
                          false, 
                          Long.MAX_VALUE);

      pi1 = new PreciseInv(new ObjInvalTarget(oid, 
                                              offset, 
                                              len),
                           new AcceptStamp(start+i, new NodeId((long)nodeId)));


      assert iter.hasNext();
  
      inv = iter.next();
      assert inv instanceof SecurePreciseInv;
      assert ((SecurePreciseInv)inv).getAcceptStamp().equals(pi1.getAcceptStamp()):
        inv.toString() + " expected=" + pi1;
      assert ((SecurePreciseInv)inv).getObjId().equals(pi1.getObjId());
      assert !iter.hasNext();
    }
  }
  
  private boolean verifyAndApplyToNode(SecureCore SecureCore, GeneralInv gi){
    SecurityFilter filter = SecureCore.getSecurityFilter();
    boolean ret = filter.verifyAndApply(gi, SecureCore.getMyNodeId());
    SecureCore.applyInval(gi, null);
    return ret;
  }
  
  private void syncNodes(SecureCore srcSecureCore, SecureCore destSecureCore){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecureInMemLogIterator srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    SecureInMemLogIterator destIter = destFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext()){
      GeneralInv gi = srcIter.next();
      if(!this.verifyAndApplyToNode(destSecureCore, gi)){
        assert false:"can't apply" + gi.toString();
      }
    }
    //reset source
    srcIter = srcFilter.makeSecureInMemLogIterator(AcceptVV.makeVVAllNegatives());
    while(srcIter.hasNext() || destIter.hasNext()){
      assert destIter.hasNext();
      assert srcIter.hasNext();
      
      GeneralInv spiDest = destIter.next();
      GeneralInv spiSrc = srcIter.next();
      assert spiDest instanceof SecurePreciseInv;
      assert spiSrc instanceof SecurePreciseInv;
      if(dbg){
        if(!spiDest.equals(spiSrc))System.out.println("Mismatching values from iterator: Src:" + spiSrc + " Dest: " + spiDest);
        else System.out.println("Matching values from iterator: Src:" + spiSrc + " Dest: " + spiDest);
      }     
      
      assert spiDest.equals(spiSrc): "Mismatching values from iterator: Src:" + spiSrc + " Dest: " + spiDest;
    }
  }
  
  private GeneralInv applyToNode(SecureCore destSecureCore, 
                             SecureCore srcSecureCore,
                             GeneralInv secureInv){
    assert secureInv != null;
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    GeneralInv sii = null;
    if(secureInv instanceof ImpreciseInv){
      sii = srcFilter.createImpreciseInv((ImpreciseInv)secureInv);
    }else{
      assert secureInv instanceof SecurePreciseInv:secureInv;
      sii = secureInv;
    }
    assert destFilter.verifyAndApply(sii, srcSecureCore.getMyNodeId());
    destSecureCore.applyInval(sii, null); 
    return sii;
  }
  
  /**
   * verifies that the next inval is the one with the given stamp and from the given nodeid
   * @param iter
   * @param stamp
   * @param nodeId
   */
  private void verifyIter(SecureInMemLogIterator iter, 
                                 long stamp,
                                 long nodeId){
    assert iter.hasNext();
    GeneralInv gi = iter.next();
    assert gi != null;
    assert gi instanceof PreciseInv;
    PreciseInv pi = ((PreciseInv)(gi));
    assert pi.getAcceptStamp().equals(new AcceptStamp(stamp, new NodeId(nodeId))):
      pi.toString() + "expected:" + stamp +"@"+nodeId;
  }
 
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SecureInMemLogIteratorUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecureInMemLogIteratorUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }
  
}

