package code.security.unit;

import java.security.PrivateKey;
import java.security.PublicKey;

import code.AcceptStamp;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.SummaryHash;
import code.security.DataHash;
import code.security.SangminConfig;
import code.security.SecurePreciseInv;
import code.security.ahs.DependencyVV;
import junit.framework.TestCase;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;
public class SecurePreciseInvUnit extends TestCase{
  
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  PrivateKey privKey;
  PublicKey pubKey;
  
  SecurePreciseInv spi;
  PreciseInv pi;
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(10));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(10));
    
    byte[] buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    byte[] buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash(buffer, true);    
    DataHash dh = new DataHash(buffer,true);

    DependencyVV dvv = new DependencyVV();
    for(int i=0; i < 1; i++){
        dvv.put(new NodeId(i), i);
    }

    spi = new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand1"), 5, 10),
        new AcceptStamp(1, new NodeId(10)),
        new AcceptStamp(2, new NodeId(10)),
        false,
        dvv,
        sh,
        dh,
        privKey);
    pi = new PreciseInv(new ObjInvalTarget(new ObjId("/rand1"), 5, 10),
        new AcceptStamp(1, new NodeId(10)),
        new AcceptStamp(2, new NodeId(10)),
        false);
    //SangminConfig.securityLevel = SangminConfig.SIGNATURE;
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }
  public void testWriteExternal(){
    try{
//  Create a stream for writing.
    FileOutputStream fos = new FileOutputStream( "tmpz" );

    //  Next, create an object that can write to that file.
    ObjectOutputStream outStream = 
      new ObjectOutputStream( fos );
    
    spi.writeExternal(outStream);
    
    outStream.flush();
       
    
    
    
    
//  Create a stream for reading.
    FileInputStream fis = new FileInputStream( "tmpz" );

    //  Next, create an object that can read from that file.
    ObjectInputStream inStream = new ObjectInputStream( fis );
    
    SecurePreciseInv spi2 = new SecurePreciseInv();
    spi2.readExternal(inStream);
    
    if( !Arrays.equals(spi.getSH().getValue(), spi2.getSH().getValue())){
      System.out.println("spi1 : " + spi);
      System.out.println("spi2 : " + spi2);
      fail("serialization: SummaryHash does not match1");
    }
    
    if(!spi.getSH().equals(spi2.getSH())){
      System.out.println("spi1 : " + spi);
      System.out.println("spi2 : " + spi2);
      fail("serialization: SummaryHash does not match2");
    }
    
    if(!spi.getDH().equals(spi2.getDH())){
      fail("serialization: DataHash does not match");
    }

    if(!(spi.getDVV().includes(spi2.getDVV()) && spi2.getDVV().includes(spi.getDVV()))){
        fail("serialization: DVV does not match");
    }

    }catch(Exception e){
      System.out.println("Got Exception: "+ e.toString());
      fail("exception");
    }
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SecurePreciseInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SecurePreciseInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }


}
