package code.security.unit;

import code.StreamId;
import code.security.ahs.*;

import java.security.PrivateKey;
import java.security.PublicKey;

import code.LocalController;
import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.GeneralInv;
import code.ImmutableBytes;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.HierInvalTarget;
import code.PreciseInv;
import code.SubscriptionSet;
import code.SummaryHash;
import code.security.*;
import code.security.ahs.DependencyVV;
import junit.framework.TestCase;
import code.security.holesync.filter.*;
import code.security.holesync.*;
import code.security.liveness.*;
import code.security.unit.TestSecureRMIClient;
import code.serialization.SerializationHelper;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;
public class SerializationCostUnit extends TestCase{

  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  int totalNodes = 10;
  int nodeCount = 0;
  private static final boolean dbg = true; 
  //create SecureCore as URANode constructor did
  boolean filterOn = true;
  boolean cleanDb = true;  // start from empty
  SecureCore refSecureCore;
  AHSMap copyAHSMap;
  NodeId refNodeId;
  PrivateKey privKey;
  PublicKey pubKey;
  
  LinkedList<SecurePreciseInv> invals;
  


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    makePractiConfig(0, totalNodes);//generate nodes: 0, 1, 2, 3, 4

    Config.readKeys();

    privKey = (PrivateKey)Config.privateKeys.get(new Long(0));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(0));

    SecureRMIClient myRMIClient = new SecureRMIClient();   

    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    refNodeId = new NodeId(0);
    refSecureCore = new SecureCore(myRMIClient, filterOn, cleanDb, refNodeId, false, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);
    refSecureCore.testSkipRecoverLocalState();
    copyAHSMap = refSecureCore.securityFilter.getAhsMap();
    copyAHSMap.addFilter(ssf);

    invals = new LinkedList<SecurePreciseInv>();
    
    ObjId oid ;
    byte[] bdy = new byte[1];
    bdy[0] = 10;
    
    ImmutableBytes body = new ImmutableBytes(bdy);
    long offset = 0;
    long len = bdy.length;



    //
    // populate 10 write to node 0
    //
    int writeNum = 64;
    for(int i = 0; i < writeNum; i ++ ){
      oid = new ObjId("/"+i);
      refSecureCore.write(oid, offset, len, 
          SecureCore.DEFAULT_PRIORITY, 
          body, 
          false, 
          Long.MAX_VALUE);
      invals.add((SecurePreciseInv)refSecureCore.securityFilter.getAhsMap().getRootList(refNodeId).getTreeNodeTS(i).getInv());
    }
    


    //SangminConfig.securityLevel = SangminConfig.SIGNATURE;
  }


  private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";

    for(int i = 0; i < total; i++){

      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
          NODE_1_IP,
          port++,
          port++,
          port++,
          port++,
          port++,
          "test" + File.separatorChar + "local-" + 
          NODE_1_ID + ".db",
          "/*",
          -1L,
          NODE_1_IP,
          port++,
          port++,
          -1,
          Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES,
          Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();//needed for secure practi

  }

  public void testAHSSerCost(){
    Vector<Hashtable<String, Integer>> statTable = new Vector<Hashtable<String, Integer>>();

    Vector<Integer> sizes = new Vector<Integer>();
    try{
      SerializationHelper sh1 = new SerializationHelper();
      ObjectOutput out = sh1.getObjectOutputStream();
      invals.get(0).writeExternal(out);
      Hashtable<String, Integer> tmpStatTable = invals.get(0).getSize();
      tmpStatTable.put("Actual size", sh1.toBytes().length);
      statTable.add(tmpStatTable);
      
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }

    AHSEntry ahsEntry = null; 
    for(int i = 0; i < 6; i++)
    {
      ahsEntry = copyAHSMap.getRootList(refNodeId).createAHS(0, (long)Math.pow(2, i)-1).elementAt(0);
      try{
        SerializationHelper sh1 = new SerializationHelper();
        ObjectOutput out = sh1.getObjectOutputStream();
        ahsEntry.writeExternal(out);
        Hashtable<String, Integer> tmpStatTable = ahsEntry.getSize();
        tmpStatTable.put("Actual size", sh1.toBytes().length);
        statTable.add(tmpStatTable);
        
      }catch(IOException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }    
    }

    int lenght = 35;
    for(String s: statTable.get(0).keySet()){
      String str = s ;
      for(int j = s.length(); j < lenght; j++){
        str += " ";
      }
      for(int i = 0; i < statTable.size(); i++){
        str += "\t" + statTable.get(i).get(s);
      }
      System.out.println(str);
    }

  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  public void dotestInvalTargetSerCost(){
   
    HierInvalTarget hit = null;
    hit  = HierInvalTarget.makeHierInvalTarget("/2");
    
    try{
      SerializationHelper sh1 = new SerializationHelper();
      hit.writeExternal(sh1.getObjectOutputStream());
      System.out.println("actual size" + sh1.toBytes().length + " computed size " + hit.onDiskSize());
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    
    ObjInvalTarget oit = new ObjInvalTarget(new ObjId("/1"), 0, 0);
    try{
      SerializationHelper sh1 = new SerializationHelper();
      ObjectOutput out = sh1.getObjectOutputStream();
      out.writeObject(oit.getObjId().getPath());
      out.writeLong(oit.getOffset());
      out.writeLong(oit.getLength());
      System.out.println("actual size" + sh1.toBytes().length + " computed size " + oit.onDiskSize());
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    
    try{
      SerializationHelper sh1 = new SerializationHelper();
      ObjectOutput out = sh1.getObjectOutputStream();
      out.writeUTF(oit.getObjId().getPath());
      out.writeLong(oit.getOffset());
      out.writeLong(oit.getLength());
      System.out.println("actual size" + sh1.toBytes().length + " computed size " + oit.onDiskSize());
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    
    try{
      hit = (HierInvalTarget)hit.getUnion(oit, SubscriptionSet.makeSubscriptionSet("/*"));
      SerializationHelper sh1 = new SerializationHelper();
      hit.writeExternal(sh1.getObjectOutputStream());
      System.out.println("actual size" + sh1.toBytes().length + " computed size " + hit.onDiskSize());
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
  /**
   *  test whether the liveness filter is correctly processing these certificates
   */
  public void dotestLivenessFilter(){
    // 3 nodes: A:1 trusted server, B:  writer (writes to /a/* 1-4 and /b/* 5-8); also syncs both ways with A after writes to /a/*
    // C: syncs with B after it has synced with A
    // expected: C receives summarized information for /a/* while precise information for /b/*)
    int [] nodeId = new int[]{nodeCount++, nodeCount++, nodeCount++};

    try{
      SecureCore[] SecureCores = new SecureCore[totalNodes];
      SecurityFilter[] filters = new SecurityFilter[totalNodes];
      SecureRMIClient myRMIClient = new SecureRMIClient();   
      NodeId trusted = new NodeId(nodeId[0]);

      for(int nId = nodeId[0]; nId<=nodeId[nodeId.length-1]; nId++){

        SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
        LinkedList<Filter> f = new LinkedList<Filter>();
        f.add(ssf);
        SecureCores[nId] = new SecureCore(myRMIClient, filterOn, cleanDb, new NodeId(nId), false, 
            new code.security.liveness.TrustedServerTraceLivenessFilter(trusted), f);
        SecureCores[nId].testSkipRecoverLocalState();
        filters[nId] = SecureCores[nId].getSecurityFilter();
      }


      //
      //populate 1 write to node 0
      //
      ObjId oid = new ObjId("/foo");
      byte[] bdy = new byte[5];
      bdy[0] = 10;
      bdy[1] = 9;
      bdy[2] = 8;
      bdy[3] = 7;
      bdy[4] = 6;
      ImmutableBytes body = new ImmutableBytes(bdy);
      long offset = 0;
      long len = bdy.length;



      //
      // populate 10 write to node 0
      //
      int writeNum = 3;
      for(int i = 0; i < writeNum; i ++ ){
        oid = new ObjId("/A/" + i + "/" + i);
        SecureCores[nodeId[0]].write(oid, offset, len, 
            SecureCore.DEFAULT_PRIORITY, 
            body, 
            false, 
            Long.MAX_VALUE);
      }
      
      this.checkpointSyncNodes(SecureCores[nodeId[0]], SecureCores[nodeId[1]], SubscriptionSet.makeSubscriptionSet("/A/2/*"));
      SecureCores[nodeId[1]].printStats(new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/A/2/*")));
    }catch(Exception e){
      e.printStackTrace();
      System.out.println(e);
    }
    
         
  }


  private SecureCheckpoint checkpointSyncNodes(SecureCore srcSecureCore, SecureCore destSecureCore, SubscriptionSet ss/*, boolean includeAll*/){
    SecurityFilter srcFilter = srcSecureCore.getSecurityFilter();
    SecurityFilter destFilter = destSecureCore.getSecurityFilter();

    LivenessFilter lf = destFilter.getLivenessFilter().clone();
    lf.union(srcFilter.getLivenessFilter());
    boolean withBody = false;

    SecureCheckpoint chkPt = null;
    
    SecureNewIncomingInvalConnection sic = new SecureNewIncomingInvalConnection(StreamId.makeNewStreamId(), ss, destSecureCore.getCurrentVV(), destSecureCore, new LocalController());
    AcceptVV endVV = srcSecureCore.getCurrentVV().getDiff(destSecureCore.getCurrentVV());
    AcceptVV startVV  = destSecureCore.getCurrentVV().project(endVV);
    if(!startVV.includes(endVV)){
      Filter sf = new SubscriptionSetFilter(ss);
      chkPt = srcFilter.getSecureCheckpoint(AcceptVV.incrementAll(startVV), withBody, endVV/*, includeAll*/, lf, sf, new FilterKnowledge(destSecureCore.getCurrentVV(), sf));    
      chkPt.initExternalDVV();
      destFilter.apply(chkPt, sic, srcSecureCore.getMyNodeId());
    }

    return chkPt;
    
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SerializationCostUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SerializationCostUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }


}
