package code.security.unit;

import code.security.*;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.Hashtable;

import code.AcceptStamp;
import code.Config;
import code.Env;
import code.NodeId;
import code.RMIApplicationException;
import code.RMIClient;
import code.ImpreciseInv;
import code.RMINetworkException;

public class TestSecureRMIClient extends SecureRMIClient{
  
  private boolean printWarning = true;
  
  SecureCore[] _core;
  public TestSecureRMIClient(SecureCore[] core){
    _core = core;
  }
  
  public SecureImpreciseInv getSplitSecureImpreciseInv(
      long start, 
      long split, 
      long end, 
      NodeId sender, 
      NodeId splitId){
    System.out.println("Test getSplitSecureImpreciseInv called");
    if (_core[(int)sender.getIDint()].getCurrentVV().includes(new AcceptStamp(split, splitId))){
      SecureImpreciseInv ii =  ((SecureCore)(_core[(int)sender.getIDint()])).securityFilter.getSplitSecureImpreciseInv(start, split, end, splitId);
      System.out.println("Test getSplitSecureImpreciseInv returned " + ii);
      return ii;
    }else{
      System.out.println("Test getSplitSecureImpreciseInv returned null");
      return null;
    }
  }
}
