package code.serialization;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;

import code.security.SangminConfig;

public class IrisInputStream {

  private InputStream is;
  private long bytesRead = 0;
  /**
   * @param in
   * @throws IOException
   */
  public IrisInputStream(InputStream in) throws IOException{
    this(in, SangminConfig.useBufferedIO);
  }
  
  /**
   * @param in
   * @throws IOException
   */
  public IrisInputStream(InputStream in, boolean buffered) throws IOException{
    if(buffered){
      this.is = new BufferedInputStream(in, SangminConfig.IOBufferSize);
    }else{
      this.is = in;
    }
  }

  public long getBytesRead(){
    return bytesRead;
  }

  public String readShortString() throws IOException{
    short len = (short)this.readExtUnsignedInt(); //readShort();
    if(len > 0){
      byte[] bytes = new byte[len]; 
      SerializationHelper.readFully(is, bytes);
      return new String(bytes);
    }else{
      return null;
    }
  }
  
  public long readExtUnsignedInt() throws IOException {
    //    int len = 1;// number of bytes
    //    len += ((val > 128)?1:0); //2^7
    //    len += ((val > 16384)?1:0); //2^14
    //    len += ((val > 2097152)?1:0); //2^21
    //    len += ((val > 268435456L)?1:0); //2^28
    //    assert val < 4294967295L; 

    long l = 0;
    byte b;
    int pos = 0;
    boolean more = false;
    do{
      b = this.readByte();
      l += ((byte) (b & 0x7F))<<(7*pos);
      more = (b&0x80)!=0;
      pos++;
    }while(more);
    //l--;
    return l;
  }

  public short readShort() throws IOException {
    if(SangminConfig.optimizeLength){
      short ret = (short)this.readExtUnsignedInt();
      return ret;
    }
    return unoptimizedReadShort();
  }
  
  public short unoptimizedReadShort() throws IOException{
    bytesRead += 2;

    int b = is.read();
    if(b == -1) throw new EOFException("IrisInputStream found EOF");
    return (short) (((b & 0xFF) << 0) + 
        ((is.read()) << 8));
  }

  public  int readInt() throws IOException {
    if(SangminConfig.optimizeLength){
      int ret = (int)this.readExtUnsignedInt();
      return ret;
    }
    bytesRead += 4;

    int b = is.read();
    if(b == -1) throw new EOFException("IrisInputStream found EOF");
    return ((b & 0xFF) << 0) +
    ((is.read() & 0xFF) << 8) +
    ((is.read() & 0xFF) << 16) +
    ((is.read()) << 24);
  }

  public  long readLong() throws IOException{
    if(SangminConfig.optimizeLength){
      long ret = (long)this.readExtUnsignedInt();
      return ret;
    }
    bytesRead += 8;

    int b = is.read();
    if(b == -1) throw new EOFException("IrisInputStream found EOF");
    return ((b & 0xFFL) << 0) +
    ((is.read() & 0xFFL) << 8) +
    ((is.read() & 0xFFL) << 16) +
    ((is.read() & 0xFFL) << 24) +
    ((is.read() & 0xFFL) << 32) +
    ((is.read() & 0xFFL) << 40) +
    ((is.read() & 0xFFL) << 48) +
    (((long) is.read()) << 56);
  }

  public  boolean readBoolean() throws IOException{
    bytesRead += 1;

    int b = is.read();
    if(b == -1) throw new EOFException("IrisInputStream found EOF");
    return b != 0;
  }

  public  void readFully(byte[] buf) throws IOException{
    int nRead = 0;
    int r = 0;
    while(nRead < buf.length){
      r = is.read(buf, nRead, (buf.length-nRead));
      if(r== -1){
        throw new EOFException("IrisInputStream found EOF");
      }
      nRead += r; 
    }
    bytesRead += buf.length;

  }

  public byte readByte() throws IOException{
    bytesRead += 1;

    int b = is.read();
    if(b == -1) throw new EOFException("IrisInputStream found EOF");
    return (byte)b;
  }


}
