package code.serialization;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

import code.security.SangminConfig;

public class IrisOutputStream{

  private long bytes;
  private OutputStream os; 

  /**
   * @param out
   * @throws IOException
   */
  public IrisOutputStream(OutputStream out){
    this(out, SangminConfig.useBufferedIO);
  }
  
  public IrisOutputStream(OutputStream out, boolean buffered){
    if(buffered){
      this.os = new BufferedOutputStream(out, SangminConfig.IOBufferSize);
    }else{
      this.os = out;
    }
    bytes = 0;
  }

  public  void writeShortString(String str) throws IOException{
    if(str == null){
//      writeShort((short)0);
      this.writeExtUnsignedInt(0);
      return;
    }
    byte[] bytes = str.getBytes();
   // writeShort((short)bytes.length);
    this.writeExtUnsignedInt(bytes.length);
    if(bytes.length > 0){
      write(bytes);
    }
  }

  public void writeBoolean(boolean val) throws IOException {
    os.write((byte) (val ? 1 : 0));
    bytes+= 1;
  }


  public void writeShort(int val) throws IOException {
    if(SangminConfig.optimizeLength){
      this.writeExtUnsignedInt(val);
      return;
    }
    unoptimizedWriteShort(val);
  }
  
  public void unoptimizedWriteShort(int val) throws IOException {
    os.write((byte) (val >>> 0));
    os.write((byte) (val >>> 8));
    bytes+= 2;
  }

  public void writeExtUnsignedInt(long val) throws IOException {
      //    val++;
    assert val >= 0:val;
//    int len = 1;// number of bytes
//    len += ((val > 128)?1:0); //2^7
//    len += ((val > 16384)?1:0); //2^14
//    len += ((val > 2097152)?1:0); //2^21
//    len += ((val > 268435456L)?1:0); //2^28
//    assert val < 4294967295L; 
    
    byte b;
    do{
      b = 0x00;
    b = ((byte) (val & 0x7F));
    b |= ((val >= 128)?0x80:0x00);
    this.writeByte(b);
    val = val >>7;
    }while(val > 0);
  }

  public void writeInt(int val) throws IOException {
    if(SangminConfig.optimizeLength){
      this.writeExtUnsignedInt(val);
      return;
    }
    os.write((byte) (val >>> 0));
    os.write((byte) (val >>> 8));
    os.write((byte) (val >>> 16));
    os.write((byte) (val >>> 24));
    bytes+=4;
  }


  public void writeLong(long val) throws IOException {
    if(SangminConfig.optimizeLength){
      this.writeExtUnsignedInt(val);
      return;
    }
    os.write((byte) (val >>> 0));
    os.write((byte) (val >>> 8));
    os.write((byte) (val >>> 16));
    os.write((byte) (val >>> 24));
    os.write((byte) (val >>> 32));
    os.write((byte) (val >>> 40));
    os.write((byte) (val >>> 48));
    os.write((byte) (val >>> 56));
    bytes +=8;
  }


  public void write(byte[] buf) throws IOException{
    os.write(buf);
    bytes +=buf.length;
  }

  public void writeByte(int i) throws IOException{
    os.write(i);
    bytes++;
  }

  /**
   * @return the bytes
   */
  public long getBytes(){
    return bytes;
  }

  /**
   * @return the os
   */
  public OutputStream getOutputStream(){
    return os;
  }

  public void flush() throws IOException{
    os.flush();
  }
  
  public static void main(String[] args) throws IOException{
    ByteArrayOutputStream bs = new ByteArrayOutputStream();
    IrisOutputStream oos = new IrisOutputStream(bs);
    oos.writeExtUnsignedInt(5);
    assert oos.bytes == 1:bs.toByteArray();
    oos.writeExtUnsignedInt(55);
    assert oos.bytes == 2:bs.toByteArray();
    oos.writeExtUnsignedInt(145);
    assert oos.bytes == 4:bs.toByteArray();
    oos.writeExtUnsignedInt(1024);
    assert oos.bytes == 6:bs.toByteArray();
    oos.writeExtUnsignedInt(16384);
    assert oos.bytes == 9:bs.toByteArray();
    oos.writeExtUnsignedInt(16383);
    assert oos.bytes == 11:bs.toByteArray();
    System.out.println("written " + Arrays.toString(bs.toByteArray()));
    oos.flush();
    System.out.println("written " + Arrays.toString(bs.toByteArray()));
    
    IrisInputStream iis = new IrisInputStream(new ByteArrayInputStream(bs.toByteArray()));
    long r =iis.readExtUnsignedInt();
    assert r == 5:r;
    r =iis.readExtUnsignedInt();
    assert r == 55:r;
    r =iis.readExtUnsignedInt();
    assert r == 145:r;
    r =iis.readExtUnsignedInt();
    assert r == 1024;
    r =iis.readExtUnsignedInt();
    assert r == 16384:r;
    r =iis.readExtUnsignedInt();
    assert r == 16383:r;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "IrisOutputStream [bytes=" + bytes + "]";
  }
}
