package code.signedVV;


import code.Config;
import code.Core;
import code.CounterVV;
import code.DataStore;
import code.Env;
import code.GeneralInv;
import code.ISStatus;
import code.IncommingConnection;
import code.InvalIteratorFilter;
import code.InvalidateBuffer;
import code.InvalidateBufferWorkerThread;
import code.NodeId;
import code.RMIClient;
import code.StreamId;
import code.UpdateBuffer;
import code.security.SecureUpdateLog;
import code.security.SecurityFilter;

public class RCore extends Core{
  
  public RSecurityFilter rSecurityFilter;
  
  public
  RCore(RMIClient rmiClient_, 
      boolean filterOn, 
      boolean cleanDb, 
      NodeId myId,
      boolean noSyncLog){
    try{
      rSecurityFilter = new RSecurityFilter(this);

      UpdateBuffer updateBuffer = null;
      if(verbose){
        Env.dprintln(verbose, "Core constructor cleanDb=" + cleanDb);
      }
      
      this.myNodeId = myId;
      logPath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".log";
      storePath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".store";
      // logPath = ufsDir +Config.getConfigFile() + this.myNodeId + ".log";
      // storePath = ufsDir +Config.getConfigFile() + this.myNodeId + ".store";
      if(cleanDb) cleanEnv();
      this.rmiClient = rmiClient_;
      String name = Config.getConfigFile();
      if(verbose){
        Env.dprintln(verbose, "Core constructor logPath=" + logPath);
      }
      log = new RUpdateLog(logPath, myId, noSyncLog, rSecurityFilter);
      recovering = false;
      recoverEndVV = new CounterVV(log.getCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverEndVV=" + recoverEndVV.toString());
      }
      this.store = new DataStore(storePath, myId);
      updateBuffer = new UpdateBuffer(UpdateBuffer.INFINITE_BUFFER_BYTES,
          UpdateBuffer.FAIL_ON_FULL);
      this.invalBuffer = new InvalidateBuffer(this.store, updateBuffer);
      /*
      new InvalidateBufferWorkerThread(this.invalBuffer,
                                       this.store,
                                       updateBuffer);
       */
      this.store.setInvalBuffer(this.invalBuffer);
      this.localWriteStreamId = StreamId.makeNewStreamId();
      /*
        recoverStartVV = 
        new CounterVV(store.getCurrentVV(new DirectoryInterestSet("/*")));

        this doesn't work, because the interestset doesn't exist
       */
      recoverStartVV = new CounterVV(this.store.getMaxCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverStartVV=" + recoverStartVV.toString());
      }
      Env.tbd("recoverStartVV should be initialized as store.getMinLPVV()"+
      "when the new isstatus is placed in");
      assert(recoverEndVV.includes(recoverStartVV));
      assert(recoverStartVV.includes(log.getDiskOmitVV()));
      if(!recoverStartVV.includes(recoverEndVV)){
        recovering = true;
      }
      //System.err.println("recoverStartVV: " + recoverStartVV);

      iiFilter = new InvalIteratorFilter(filterOn);
      log.startGCWorker(store);

    } catch (Exception e){
      e.printStackTrace();
      assert false;

      Env.printDebug("Failed to initiate the core.." + e);
      System.exit(-1);
    }
  }

 /** 
 *  Core construction with option to choose null RAS - for testing only 
 **/ 


  public
  RCore(RMIClient rmiClient_, 
      boolean filterOn, 
      boolean cleanDb, 
      NodeId myId,
      boolean noSyncLog, 
      boolean nullRAS){
    try{
      rSecurityFilter = new RSecurityFilter(this);

      UpdateBuffer updateBuffer = null;
      if(verbose){
        Env.dprintln(verbose, "Core constructor cleanDb=" + cleanDb);
      }
      
      this.myNodeId = myId;
      logPath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".log";
      storePath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".store";
      // logPath = ufsDir +Config.getConfigFile() + this.myNodeId + ".log";
      // storePath = ufsDir +Config.getConfigFile() + this.myNodeId + ".store";
      if(cleanDb) cleanEnv();
      this.rmiClient = rmiClient_;
      String name = Config.getConfigFile();
      if(verbose){
        Env.dprintln(verbose, "Core constructor logPath=" + logPath);
      }
      log = new RUpdateLog(logPath, myId, noSyncLog, rSecurityFilter);
      recovering = false;
      recoverEndVV = new CounterVV(log.getCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverEndVV=" + recoverEndVV.toString());
      }
      this.store = new DataStore(storePath, myId, nullRAS);
      updateBuffer = new UpdateBuffer(UpdateBuffer.INFINITE_BUFFER_BYTES,
          UpdateBuffer.FAIL_ON_FULL);
      this.invalBuffer = new InvalidateBuffer(this.store, updateBuffer);
      /*
      new InvalidateBufferWorkerThread(this.invalBuffer,
                                       this.store,
                                       updateBuffer);
       */
      this.store.setInvalBuffer(this.invalBuffer);
      this.localWriteStreamId = StreamId.makeNewStreamId();
      /*
        recoverStartVV = 
        new CounterVV(store.getCurrentVV(new DirectoryInterestSet("/*")));

        this doesn't work, because the interestset doesn't exist
       */
      recoverStartVV = new CounterVV(this.store.getMaxCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverStartVV=" + recoverStartVV.toString());
      }
      Env.tbd("recoverStartVV should be initialized as store.getMinLPVV()"+
      "when the new isstatus is placed in");
      assert(recoverEndVV.includes(recoverStartVV));
      assert(recoverStartVV.includes(log.getDiskOmitVV()));
      if(!recoverStartVV.includes(recoverEndVV)){
        recovering = true;
      }
      //System.err.println("recoverStartVV: " + recoverStartVV);

      iiFilter = new InvalIteratorFilter(filterOn);
      log.startGCWorker(store);



    } catch (Exception e){
      e.printStackTrace();
      assert false;

      Env.printDebug("Failed to initiate the core.." + e);
      System.exit(-1);
    }
  }
  
 /** 
 *   Apply an invalidate 
 *     -- apply to log 
 *     -- apply to Datastore -- update cvv 
 *                              update per obj state if precise 
 **/ 
  public synchronized void applyInval(GeneralInv gi, StreamId streamId){
    // 
    // Note: The GeneralInv message can be a precise invalidation,
    // an imprecise invalidation, or a bound invalidation (e.g., a precise
    // invalidation *bound* to the message). 
    // In the third case, don't forget to mark the message
    // as "bound" in the log and to update the locally stored
    // copy. Also note -- no need to send update to subscribers
    // since it is bound, we will send the update with the inval
    // (though we might want to enqueue the update to subscribers
    // when we get an unbind message, though that risks sending
    // the same body twice, as well...perhaps track to whom
    // we have sent bound updates...


    try{
      
      if(!verify(gi)){
        System.out.println("security verification failed");
        assert(false);
        return;
      }
      
      if(!recovering){

        log.applyInval(gi);

        if(gi instanceof SVVInv){
          rSecurityFilter.advanceCurVV((SVVInv)gi);
        }
      } else {
        updateRecoverStartVV(gi.getEndVV());
      }

      //  this.invalBuffer.applyInval(gi,
      //                            streamId,
      //                            deadlineMS);
      this.store.applyInval(gi);

    }catch(Exception e){
      e.printStackTrace();
    }

  }
  
  
  public boolean verify(GeneralInv gi){
    //first check access control
    //then check consistency
    if(!(gi instanceof SVVInv)){
      System.out.println("RCore received non-SVVInv" + gi);
      // TODO for now we just return true to proceed
      //assert(false);
      return true;
    }
    return rSecurityFilter.verify((SVVInv)gi);
  }

  public RCore(RMIClient rmiClient_, boolean filterOn, boolean cleanDb,
      NodeId myId, ISStatus isStatus, boolean noSyncLog){
    // TODO Auto-generated constructor stub
    rSecurityFilter = new RSecurityFilter(this);

    try{
      UpdateBuffer updateBuffer = null;
      if(verbose){
        Env.dprintln(verbose, "Core constructor cleanDb=" + cleanDb);
      }
      
      this.myNodeId = myId;
      logPath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".log";
      storePath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".store";
      // logPath = ufsDir +Config.getConfigFile() + this.myNodeId + ".log";
      // storePath = ufsDir +Config.getConfigFile() + this.myNodeId + ".store";
      if(cleanDb) cleanEnv();
      this.rmiClient = rmiClient_;
      String name = Config.getConfigFile();
      int index = name.indexOf('.');
      String prefix = name.substring(0,index);
      if(verbose){
        Env.dprintln(verbose, "Core constructor logPath=" + logPath);
      }
      
      log = new RUpdateLog(logPath, myId, noSyncLog, rSecurityFilter);
      recovering = false;
      recoverEndVV = new CounterVV(log.getCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverEndVV=" + recoverEndVV.toString());
      }
      this.store = new DataStore(storePath, isStatus, myId);
      updateBuffer = new UpdateBuffer(UpdateBuffer.INFINITE_BUFFER_BYTES,
          UpdateBuffer.FAIL_ON_FULL);
      this.invalBuffer = new InvalidateBuffer(this.store, updateBuffer);
      new InvalidateBufferWorkerThread(this.invalBuffer,
          this.store,
          updateBuffer);
      this.store.setInvalBuffer(this.invalBuffer);
      this.localWriteStreamId = StreamId.makeNewStreamId();
      /*
        recoverStartVV = 
        new CounterVV(store.getCurrentVV(new DirectoryInterestSet("/*")));

        this doesn't work, because the interestset doesn't exist
       */
      recoverStartVV = new CounterVV(this.store.getMaxCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverStartVV=" + recoverStartVV.toString());
      }
      Env.tbd("recoverStartVV should be initialized as store.getMinLPVV()"+
      "when the new isstatus is placed in");
      assert(recoverEndVV.includes(recoverStartVV));
      assert(recoverStartVV.includes(log.getDiskOmitVV()));
      if(!recoverStartVV.includes(recoverEndVV)){
        recovering = true;
      }
      //System.err.println("recoverStartVV: " + recoverStartVV);

      iiFilter = new InvalIteratorFilter(filterOn);
      log.startGCWorker(store);


    } catch (Exception e){
      e.printStackTrace();
      assert false;

      Env.printDebug("Failed to initiate the core.." + e);
      System.exit(-1);
    }
  }

  public void printStats(){
    
    rSecurityFilter.printStats();
  }
}
