package code.signedVV;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.Core;
import code.NodeId;
import code.PreciseInv;
import code.Stats;

public class RSecurityFilter{

  Core core;
  SignedVV curSignedVV;

  HashMap<SVVInv, SVVInv> hashMap;

  int numReceivedInv;
  
  private HashSet<NodeId>     setInteracted;
  
  private boolean useDVV = true;
      

  public RSecurityFilter(Core _core){
    core = _core;
    curSignedVV = new SignedVV();
    
    if(!useDVV){
    Enumeration e = Config.getKnownNodeIds();
    while( e.hasMoreElements()){  
      try{
        NodeId nodeId = (NodeId)e.nextElement();
        PrivateKey privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
        
        long ts = AcceptStamp.BEFORE_TIME_BEGAN;
        //long ts = -100;
        
        Signature sig = Signature.getInstance(privKey.getAlgorithm());
        
        sig.initSign(privKey);

        sig.update((new Long(ts)).byteValue());

        byte[] signature =  sig.sign();
        curSignedVV.put(nodeId, new SignedVVEntry(ts,signature));
      }catch(Exception ee){
        System.out.println(ee.toString());
        System.out.println(ee.getStackTrace());
        System.exit(-1);
      }
    }
    
    }
    hashMap = new HashMap<SVVInv, SVVInv>();
    numReceivedInv = 0;
    
    if(useDVV){
      setInteracted = new HashSet<NodeId>();
    }
  }

  public PreciseInv createPreciseInval(PreciseInv pInv){
    SVVInv ret;
        
    if(useDVV){
      setInteracted.add(pInv.getNodeId()); 

      ret = new SVVInv(pInv, curSignedVV, setInteracted);
      
      System.out.println("DVV SIZE : " + setInteracted.size());
      setInteracted.clear();

    }else{
      ret = new SVVInv(pInv, curSignedVV);
    }
    return ret;

  }

  private boolean verifySignature(NodeId nodeId, SignedVVEntry svve){

    PublicKey pubKey = (PublicKey)(Config.publicKeys.get(new Long(nodeId.getIDint())));

    try{
      Signature sig = Signature.getInstance(pubKey.getAlgorithm());
      sig.initVerify(pubKey);

      sig.update((new Long(svve.getTS())).byteValue());

      return sig.verify(svve.getSingnature());
    }catch(Exception e){
      System.out.println(e.toString());
      System.out.println(e.getStackTrace());
      System.exit(-1);
    }
    return false;
  }

  public void advanceCurVV(SVVInv inv){
    core.getLog().lock.lock();
    
    NodeId nodeId = inv.getCreator();
    SignedVVEntry svve = inv.getVV().get(nodeId);
    
    if(!curSignedVV.containsNodeId(nodeId) || svve.getTS() > curSignedVV.get(nodeId).getTS()){
      curSignedVV.put(nodeId, svve);
    }
    
    
    core.getLog().lock.unlock();
  }
  
  public boolean verify(SVVInv inv){
    core.getLog().lock.lock();
    
    assert(this.isConsistent());

    for(NodeId nodeId : inv.getVV().keySet()){
      SignedVVEntry svve = inv.getVV().get(nodeId);

      if(curSignedVV.containsNodeId(nodeId) && curSignedVV.get(nodeId).getTS() == svve.getTS()){
        continue;
      }

      if(!verifySignature(nodeId, svve)){
        core.getLog().lock.unlock();
        return false;
      }            
            
      try{
        if(nodeId.equals(inv.getCreator())){
          //if(!curSignedVV.containsNodeId(nodeId) || svve.getTS() > curSignedVV.get(nodeId).getTS()){
          //  curSignedVV.put(nodeId, svve);
          //}
        }else{
          assert(curSignedVV.get(nodeId).getTS() >= svve.getTS()):"\ncur svve:"+curSignedVV.get(nodeId)+"\nsvve:"+svve;
        }

      }catch(Exception e){
        assert(false);
      }

      inv.increaseHops();
      SVVInv svvInv = hashMap.get(inv);
      if(svvInv != null){
        if(svvInv.getHops() > inv.getHops()){
          hashMap.put(inv, inv);
        }        
      }else{
        //System.out.println("Stats: msg Latency for " + inv + " : " + (System.currentTimeMillis() - inv.getReal()));
        hashMap.put(inv, inv);
      }

    }

    numReceivedInv++;
    
    if(useDVV){
      setInteracted.add(inv.getCreator());
    }
    
    core.getLog().lock.unlock();
    return true;
  }

  public void printStats(){
    //for(SVVInv svvInv : hashMap.keySet()){
    //  System.out.println(svvInv);
    //}
    System.out.println("total received inval: " + numReceivedInv);

    Hashtable h = Stats.getStats();
    Enumeration e = h.keys();
    long tot = 0;
    while(e.hasMoreElements()){
      String key = (String)e.nextElement();
      Long value = (Long)h.get(key);

      System.out.println("Stats: " + key + " " + value);

      tot += value.longValue();
    }

    System.out.println("Total Bandwidth: " + tot);


  }
  
  private boolean isConsistent(){
    AcceptVV cvv = core.getCurrentVV();
    for(NodeId nodeId : curSignedVV.keySet()){
      try{
        if(curSignedVV.get(nodeId).getTS() != cvv.getStampByServer(nodeId)){
          System.out.println("CVV: " + cvv);
          System.out.println("nodeId: " + nodeId.getIDint() + ": " + curSignedVV.get(nodeId).getTS());
          return false;
        }
      }catch(Exception e){
        e.printStackTrace();
        assert(false) : "CVV: " + cvv + "\n nodeID: " + nodeId.getIDint() + " "+ curSignedVV.get(nodeId).getTS();
      }
    }
    
    return true;
  }

}
