package code.signedVV;

import code.Config;
import code.Controller;
import code.Core;
import code.LocalInterface;
import code.NodeId;
import code.RMIClient;
import code.RMIServerImpl;
import code.SocketServer;
import code.URANode;

public class RURANode extends URANode{

  public RURANode(String localConfigFile,
      NodeId myId,
      int controllerType,
      boolean cleanDb){
    this(localConfigFile, myId, controllerType, cleanDb, false);
  }

 /** 
 * cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public RURANode(String localConfigFile,
      NodeId myId,
      int controllerType,
      boolean cleanDb,
      boolean noSyncLog){
    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();

//    ???????add filterOn to parameter later
      boolean filterOn = true;
      core = new RCore(rmiClient, filterOn, cleanDb, myId, noSyncLog);
      controller = makeController(controllerType, core, rmiClient);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 * cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public RURANode(String localConfigFile,
      NodeId myId,
      Controller c,
      boolean cleanDb,
      boolean noSyncLog){
    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();
      boolean filterOn = true;
      core = new RCore(rmiClient, filterOn, cleanDb, myId, noSyncLog);
      controller = c;
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 * nullRAS is used to pick a null random access state 
 **/ 
  public RURANode(String localConfigFile,
      NodeId myId,
      int controllerType,
      boolean cleanDb,
      boolean noSyncLog, 
      boolean nullRAS){

    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();

      boolean filterOn = true;
      core = new RCore(rmiClient, filterOn, cleanDb, myId, noSyncLog, nullRAS);
      controller = makeController(controllerType, core, rmiClient);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 * cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public RURANode(String localConfigFile,
      NodeId myId,
      int controllerType,
      boolean cleanDb,
      boolean noSyncLog,
      boolean logLIOpToFile,
      String logLIOpFileName){
    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();

//    ???????add filterOn to parameter later
      boolean filterOn = true;
      core = new RCore(rmiClient, filterOn, cleanDb, myId, noSyncLog);
      controller = makeController(controllerType, core, rmiClient);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core, logLIOpToFile, logLIOpFileName);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 * cleanDb is used for testing purpose. by default it's false. i.e. recover 
 * from disk 
 **/ 
  public RURANode(String localConfigFile, NodeId myId, int controllerType){

    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();

//    ???????add filterOn to parameter later
      boolean filterOn = true;
      boolean cleanDb = false; // by default, recover from disk
      core = new RCore(rmiClient, filterOn, cleanDb, myId, false);
      controller = makeController(controllerType, core, rmiClient);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

}
