package code.signedVV;

import java.io.IOException;

import code.AcceptStamp;
import code.BoundInval;
import code.CantRecoverCheckpointException;
import code.CausalOrderException;
import code.GeneralInv;
import code.ImmutableBytes;
import code.NoSuchEntryException;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.UpdateLog;
import code.security.SangminConfig;
import code.security.SecurityFilter;

public class RUpdateLog extends UpdateLog{

  RSecurityFilter securityFilter;

  public RUpdateLog(String logPath_, NodeId myNodeId_, boolean noSync,
      RSecurityFilter rsf) throws IOException, CantRecoverCheckpointException,
      SecurityException, NoSuchEntryException{
    super(logPath_, myNodeId_, noSync);
    this.securityFilter = rsf;
    // TODO Auto-generated constructor stub
  }

  
  // Create and apply BoundInv for local write
  public AcceptStamp
  writeInternal(ObjId objId,
        long offset,
        long len,
        double priority,
        AcceptStamp realStamp,
        ImmutableBytes buffer,
        boolean bound,
        long maxBoundHops,
        boolean embargoed){
    lock.lock();
    try{
      GeneralInv inv;
      long checkLamportClock = currentLamportClock;
      
      AcceptStamp acceptStamp = new AcceptStamp(currentLamportClock, myNodeId);
      
      if(bound){
        assert(SangminConfig.securityLevel == SangminConfig.NONE);
        inv = new BoundInval(objId,
                             offset,
                             len,
                             acceptStamp, 
                             buffer,
                             priority,
                             realStamp,
                             maxBoundHops,
                             embargoed);
      }else{
        PreciseInv pInv = new PreciseInv(new ObjInvalTarget(objId, offset, len),
                             acceptStamp,
                             realStamp,
                             embargoed);
        inv = securityFilter.createPreciseInval(pInv);
      }
      
      try{
        applyInvalAtomic(inv);
      }catch(CausalOrderException e){
        e.printStackTrace();
        assert false;
        //Assert.affirm(false, "Causal order exception on local write " 
        //              + e.toString());
      }
      
      return acceptStamp;
    }finally{
      lock.unlock();
    }
   
  }
  
  
}
