package code.signedVV;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Enumeration;
import java.util.HashSet;

import code.AcceptStamp;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.SummaryHash;
import code.VV;
import code.security.DataHash;
import code.security.SangminConfig;
import code.security.SecureInv;
import code.security.SecurePreciseInv;
import code.security.ahs.DependencyVV;

public class SVVInv extends PreciseInv{

  final SignedVV acceptVV;
  
  int hops;
  
  public SVVInv(){
    super();
    acceptVV = null;
    hops = 0;
  }

  public SVVInv(PreciseInv pi, SignedVV curVV){
    
    super(pi.getObjInvalTarget(),
        pi.getAcceptStamp(),
        pi.getRTAcceptStamp(),
        pi.isEmbargoed());
            
    PrivateKey privKey = (PrivateKey)Config.privateKeys.get(new Long(pi.getNodeId().getIDint()));    
    byte[] signature = sign(privKey);
    SignedVVEntry svve = new SignedVVEntry(acceptStamp.getLocalClock(), signature);
    curVV.put(getCreator(), svve);
    
    acceptVV = curVV.clone();
    
    hops = 0;
    
  }
  
  public SVVInv(PreciseInv pi, SignedVV curVV, HashSet<NodeId> setInteracted){
    
    super(pi.getObjInvalTarget(),
        pi.getAcceptStamp(),
        pi.getRTAcceptStamp(),
        pi.isEmbargoed());
            
    PrivateKey privKey = (PrivateKey)Config.privateKeys.get(new Long(pi.getNodeId().getIDint()));    
    byte[] signature = sign(privKey);
    SignedVVEntry svve = new SignedVVEntry(acceptStamp.getLocalClock(), signature);
    curVV.put(getCreator(), svve);
    
    acceptVV = new SignedVV();
    for(NodeId nodeId : setInteracted){
      acceptVV.put(nodeId, curVV.get(nodeId));
    }
    
    assert(acceptVV.containsNodeId(pi.getNodeId()));
    
    hops = 0;
    
  }
  
  private byte[] sign(PrivateKey privKey){
    assert (privKey != null);

    try{

      Signature sig = Signature.getInstance(privKey.getAlgorithm());

      sig.initSign(privKey);

      sig.update((new Long(this.acceptStamp.getLocalClock())).byteValue());

      return sig.sign();
    }catch(Exception e){
      System.out.println(e.toString());
      System.out.println(e.getStackTrace());
      System.exit(-1);
    }

    return null;
  }
  
  public NodeId getCreator(){

    return super.getNodeId();    
  }

  public SignedVV getVV(){
    return acceptVV;
  }


  public void writeExternal(ObjectOutput out) throws IOException{

    out.writeObject(this.getObjId().getPath());
    out.writeLong(this.getOffset());
    out.writeLong(this.getLength());
    
    //out.writeLong(this.getAcceptStamp().getLocalClock());
    out.writeLong(this.getAcceptStamp().getNodeId().getIDint());

    // realtime AcceptStamp & embargoed flag for tact/embargoed write
    out.writeLong(this.getRTAcceptStamp().getLocalClock());
    out.writeBoolean(this.isEmbargoed());

    // signed VV components
    out.writeInt(acceptVV.size());
    
    for(NodeId nodeId : acceptVV.keySet()){
      out.writeLong(nodeId.getIDint());
      SignedVVEntry svve = acceptVV.get(nodeId);
      out.writeLong(svve.getTS());
      byte[] sig = svve.getSingnature();
      out.writeInt(sig.length);
      out.write(sig);
    }
    
    out.writeInt(this.hops);

  }

  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{

    String objIdString = (String)(in.readObject());
    long  offset = in.readLong();
    long  length = in.readLong();
    long  localClock = -1;// = in.readLong();
    long  nodeIdInt = in.readLong();

    long realTime = in.readLong();
    boolean  myembargoed = in.readBoolean();

    int sizeOfVV = in.readInt();
    SignedVV myVV = new SignedVV();
        
    
    for(int i=0; i < sizeOfVV; i++){      
      long nodeId = in.readLong();
      long ts = in.readLong();
      int sizeSig = in.readInt();
      
      byte[] signature = new byte[sizeSig];
      in.read(signature,0,sizeSig);
      
      myVV.put(new NodeId(nodeId), new SignedVVEntry(ts, signature));
      
      if(nodeIdInt == nodeId){
        localClock = ts;
      }      
    }
    
    int _hops = in.readInt();

    Field[] f = new Field[6];

    try{

      f[0] = PreciseInv.class.getDeclaredField("obj");
      f[1] = PreciseInv.class.getDeclaredField("acceptStamp");
      f[2] = PreciseInv.class.getDeclaredField("rtAcceptStamp");
      f[3] = PreciseInv.class.getDeclaredField("embargoed");
      f[4] = SVVInv.class.getDeclaredField("acceptVV");
      f[5] = SVVInv.class.getDeclaredField("hops");

    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);

    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, new ObjInvalTarget(new ObjId(objIdString),
          offset,
          length));
      f[1].set(this, new AcceptStamp(localClock, new NodeId(nodeIdInt)));
      f[2].set(this, new AcceptStamp(realTime, new NodeId(nodeIdInt)));
      f[3].setBoolean(this, myembargoed);
      f[4].set(this, myVV);
      f[5].setInt(this, _hops);

    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
  }

  public boolean equals(Object o){
    if(!super.equals(o)){
      return false;
    }
    
    if( o instanceof SVVInv){
      SVVInv inv = (SVVInv)o;
      return acceptVV.equals(inv.acceptVV);
    }else{
      return false;
    }
    
  }
  
  public int hashCode(){
    return this.acceptStamp.getNodeId().hashCode() + acceptVV.hashCode();
  }
  
  public int getHops(){
    return hops;
  }
  
  public void increaseHops(){
    hops++;
  }
  
  public String toString(){
    return ( super.toString() + ", hops: "+hops);
  }
}
