package code.signedVV;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;

import code.AcceptStamp;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.SummaryHash;
import code.security.DataHash;
import code.security.SecurePreciseInv;
import code.security.ahs.DependencyVV;
import code.security.unit.SecurePreciseInvUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SVVInvUnit extends TestCase{

public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  PrivateKey privKey;
  PublicKey pubKey;
  
  SVVInv spi1;
  SVVInv spi2;
  SignedVV curVV;
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(1));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(1));
    
    curVV = new SignedVV();
    
    spi1 = new SVVInv(new PreciseInv(new ObjInvalTarget(new ObjId("/rand1"), 5, 10),
        new AcceptStamp(1, new NodeId(10)),
        new AcceptStamp(2, new NodeId(10)),
        false), curVV);
    

    spi2 = new SVVInv(new PreciseInv(new ObjInvalTarget(new ObjId("/rand1"), 5, 10),
        new AcceptStamp(2, new NodeId(10)),
        new AcceptStamp(3, new NodeId(10)),
        false), curVV);
    
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }
  public void testWriteExternal(){
    try{
//  Create a stream for writing.
    FileOutputStream fos = new FileOutputStream( "tmpz" );

    //  Next, create an object that can write to that file.
    ObjectOutputStream outStream = 
      new ObjectOutputStream( fos );
    
    spi1.writeExternal(outStream);
    spi2.writeExternal(outStream);
    
    outStream.flush();
//  Create a stream for reading.
    FileInputStream fis = new FileInputStream( "tmpz" );

    //  Next, create an object that can read from that file.
    ObjectInputStream inStream = new ObjectInputStream( fis );
    
    SVVInv rspi1 = new SVVInv();
    rspi1.readExternal(inStream);
    
    SVVInv rspi2 = new SVVInv();
    rspi2.readExternal(inStream);
    
    if(!spi1.equals(rspi1)){
      fail("SVVInV serialization failed 1");
    }
    

    if(!spi2.equals(rspi2)){
      fail("SVVInV serialization failed 2");
    }
    

    }catch(Exception e){
      System.out.println("Got Exception: "+ e.toString());
      fail("exception");
    }
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SVVInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SVVInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }


}
