package code.signedVV;

import java.util.HashMap;
import java.util.Set;

import code.NodeId;

public class SignedVV{
  HashMap<NodeId,SignedVVEntry> stamps;
  
  public SignedVV(){
    stamps = new HashMap<NodeId,SignedVVEntry>();
  }
  
  public synchronized SignedVV clone(){
    SignedVV ret = new SignedVV();
    for(NodeId nodeId : stamps.keySet()){
      ret.put(nodeId, this.get(nodeId).clone());
    }
    //ret.stamps = (HashMap<NodeId,SignedVVEntry>)this.stamps.clone();
    return ret;
  }
  
  public synchronized void put(NodeId nodeId, SignedVVEntry svve){
    stamps.put(nodeId, svve);
  }
  
  public Set<NodeId> keySet(){
    return stamps.keySet();
  }
  
  public synchronized SignedVVEntry get(NodeId nodeId){    
    return stamps.get(nodeId);    
  }
  
  public synchronized int size(){
    return stamps.size();
  }
  
  public boolean containsNodeId(NodeId nodeId){
    return stamps.containsKey(nodeId);
  }
  
  public boolean equals(Object o){
    if(o instanceof SignedVV){
      SignedVV svv = (SignedVV)o;
      if(this.size() != svv.size()){
        return false;
      }
      for(NodeId nodeId : stamps.keySet()){        
        if(!svv.containsNodeId(nodeId) || !this.get(nodeId).equals(svv.get(nodeId))){
          return false;
        }
      }
      
      return true;
    }else{
      return false;
    }
    
  }
  
  public int hashCode(){
    return stamps.hashCode();
  }
  
  public String toString(){
    String ret = "";
    
    for(NodeId nodeId : stamps.keySet()){
      ret += "[" + nodeId + ":" + stamps.get(nodeId) + " ] ";
    }
    
    return ret;
  }
}
